/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.model.explore;

import com.ontotext.trree.util.IRIUtil;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;

public class Node {
    private String iri;
    private boolean isTriple;
    private List<Map<String, Object>> labels = new ArrayList<Map<String, Object>>();
    private String comment;
    private List<String> types = new LinkedList<String>();
    private long size;
    private double rdfRank;

    public void setIri(Value resource) {
        if (resource instanceof IRI) {
            this.iri = resource.stringValue();
        } else {
            this.iri = IRIUtil.getTripleString((Triple)((Triple)resource));
            this.setTriple(true);
        }
    }

    public String getIri() {
        return this.iri;
    }

    public List<Map<String, Object>> getLabels() {
        return this.labels;
    }

    public void addLabel(@NotNull String lang, String label, int priority) {
        HashMap<String, Object> map = new HashMap<String, Object>(3);
        map.put("lang", lang);
        map.put("label", label);
        map.put("priority", priority);
        this.labels.add(map);
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void addType(String type) {
        this.types.add(type);
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public double getRdfRank() {
        return this.rdfRank;
    }

    public void setRdfRank(double rdfRank) {
        this.rdfRank = rdfRank;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isTriple() {
        return this.isTriple;
    }

    public void setTriple(boolean triple) {
        this.isTriple = triple;
    }
}

