/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.model.explore;

import com.ontotext.trree.util.IRIUtil;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;

public class Link {
    private String source;
    private boolean isTripleSource;
    private String target;
    private boolean isTripleTarget;
    private Set<IRI> rawPredicates = new HashSet<IRI>();
    private Set<String> predicates = new HashSet<String>();

    public void setSource(Value source) {
        if (source instanceof IRI) {
            this.source = source.stringValue();
        } else {
            this.source = IRIUtil.getTripleString((Triple)((Triple)source));
            this.setTripleSource(true);
        }
    }

    public String getSource() {
        return this.source;
    }

    public Set<String> getPredicates() {
        return this.predicates;
    }

    public void addPredicate(String predicate) {
        this.predicates.add(predicate);
    }

    public void addRawPredicate(IRI rawPredicate) {
        this.rawPredicates.add(rawPredicate);
    }

    public Set<IRI> getRawPredicates() {
        return this.rawPredicates;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(Value target) {
        if (target instanceof IRI) {
            this.target = target.stringValue();
        } else {
            this.target = IRIUtil.getTripleString((Triple)((Triple)target));
            this.setTripleTarget(true);
        }
    }

    public boolean isTripleSource() {
        return this.isTripleSource;
    }

    public void setTripleSource(boolean isTripleSource) {
        this.isTripleSource = isTripleSource;
    }

    public boolean isTripleTarget() {
        return this.isTripleTarget;
    }

    public void setTripleTarget(boolean isTripleTarget) {
        this.isTripleTarget = isTripleTarget;
    }

    public int hashCode() {
        return (this.source + this.target).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Link)) {
            return false;
        }
        Link objLink = (Link)obj;
        return objLink.source.equals(this.source) && objLink.target.equals(this.target);
    }
}

