/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Namespace;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonView(value={UIView.class})
public class RdfClass {
    private String name;
    private String fullName;
    private String tmpName;
    private String topLevelParentUri;
    private List<RdfClass> children;
    private int instancesCount;
    private int sortingRank;
    private int id;
    private int depth;
    @JsonProperty(value="size")
    private long normalisedCount;
    private String role;

    public RdfClass() {
    }

    public RdfClass(String name, String fullName, String tmpName, String topLevelParentName, int instancesCount, String role, int depth, int id) {
        this.name = name;
        this.fullName = fullName;
        this.tmpName = tmpName;
        this.topLevelParentUri = topLevelParentName;
        this.setInstancesCount(instancesCount);
        this.role = role;
        this.children = new ArrayList<RdfClass>();
        this.depth = depth;
        this.id = id;
    }

    public RdfClass addChild(RdfClass child) {
        this.children.add(child);
        return child;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFullName() {
        return this.fullName;
    }

    @JsonIgnore
    public String getTmpName() {
        return this.tmpName;
    }

    public String getTopLevelParentUri() {
        return this.topLevelParentUri;
    }

    public void setTopLevelParentUri(String topLevelParentUri) {
        this.topLevelParentUri = topLevelParentUri;
    }

    public String getRole() {
        return this.role;
    }

    public List<RdfClass> getChildren() {
        return this.children;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public int getInstancesCount() {
        return this.instancesCount;
    }

    public void setInstancesCount(int instancesCount) {
        this.instancesCount = instancesCount;
        this.normalisedCount = 10L + Math.round(100.0 * Math.pow(Math.log(instancesCount + 1), 2.0));
    }

    public int getSortingRank() {
        if (this.children == null || this.children.isEmpty()) {
            return this.instancesCount;
        }
        int rank = 0;
        for (RdfClass child : this.children) {
            rank += child.getSortingRank();
        }
        if (this.instancesCount != rank) {
            rank += this.instancesCount;
        }
        return rank;
    }

    public void setSortingRank(int sortingRank) {
        this.sortingRank = sortingRank;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @JsonIgnore
    private long getClassCount() {
        long count = 1L;
        for (RdfClass child : this.children) {
            count += child.getClassCount();
        }
        return count;
    }

    @JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonView(value={UIView.class})
    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ClassHierarchy {
        public static final String ROOT_PARENT_NAME = "RDF Class Hierarchy";
        private final String name = "RDF Class Hierarchy";
        private List<RdfClass> children;
        private boolean isUpdated;
        private String repoFingerprint;
        private transient Set<Namespace> namespaces;
        private Map<String, String> namespacesMap;

        public ClassHierarchy() {
        }

        public ClassHierarchy(List<RdfClass> children) {
            this.children = children;
        }

        public boolean isUpdated() {
            return this.isUpdated;
        }

        public void setUpdated(boolean isUpdated) {
            this.isUpdated = isUpdated;
        }

        @JsonView(value={StorageView.class})
        public String getRepoFingerprint() {
            return this.repoFingerprint;
        }

        public void setRepoFingerprint(String repoFingerprint) {
            this.repoFingerprint = repoFingerprint;
        }

        public String getName() {
            return ROOT_PARENT_NAME;
        }

        public List<RdfClass> getChildren() {
            return this.children;
        }

        public String getRole() {
            return "root";
        }

        public int getId() {
            return 1;
        }

        public int getDepth() {
            return 0;
        }

        @JsonIgnore
        public Set<Namespace> getNamespaces() {
            return this.namespaces;
        }

        public void setNamespaces(Set<Namespace> namespaces) {
            this.namespaces = namespaces;
        }

        @JsonView(value={StorageView.class})
        public Map<String, String> getNamespacesMap() {
            return this.namespacesMap;
        }

        public void setNamespacesMap(Map<String, String> namespacesMap) {
            this.namespacesMap = namespacesMap;
        }

        public long getClassCount() {
            long count = 0L;
            for (RdfClass child : this.children) {
                count += child.getClassCount();
            }
            return count;
        }
    }

    public static class NamespacesComparator
    implements Comparator<Namespace> {
        @Override
        public int compare(Namespace o1, Namespace o2) {
            int nameCompared = o1.getName().compareTo(o2.getName());
            if (nameCompared == 0) {
                return o1.getPrefix().compareTo(o2.getPrefix());
            }
            return nameCompared;
        }
    }

    public static interface StorageView
    extends UIView {
    }

    public static interface UIView {
    }
}

