/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collection;
import java.util.Set;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.PUBLIC_ONLY)
public class Graph {
    private Collection<Node> nodes;
    @JsonProperty(value="links")
    private Collection<Edge> edges;

    public Graph(Collection<Node> nodes, Collection<Edge> edges) {
        this.nodes = nodes;
        this.edges = edges;
    }

    public Collection<Edge> getEdges() {
        return this.edges;
    }

    public Collection<Node> getNodes() {
        return this.nodes;
    }

    public static class Edge {
        private String name;
        private String uri;
        private int source;
        private int target;
        private String propertyType;
        private boolean implicit;
        private int targetNodeEdgeCount;
        private String objectPropNodeClassUri;
        @JsonIgnore
        private Node node;

        public Edge(String name, String uri, String propertyType, boolean implicit, Node node) {
            this.name = name;
            this.uri = uri;
            this.propertyType = propertyType;
            this.implicit = implicit;
            this.node = node;
            this.objectPropNodeClassUri = node.getObjectPropClassUri();
        }

        public Edge(String name, String uri, String propertyType, boolean implicit, int source, int target, Node node) {
            this(name, uri, propertyType, implicit, node);
            this.source = source;
            this.target = target;
            this.objectPropNodeClassUri = node.getObjectPropClassUri();
        }

        public String getName() {
            return this.name;
        }

        public String getUri() {
            return this.uri;
        }

        public int getSource() {
            return this.source;
        }

        public void setSource(int source) {
            this.source = source;
        }

        public int getTarget() {
            return this.target;
        }

        public void setTarget(int target) {
            this.target = target;
        }

        public String getPropertyType() {
            return this.propertyType;
        }

        public Node getNode() {
            return this.node;
        }

        public int getTargetNodeEdgeCount() {
            return this.targetNodeEdgeCount;
        }

        public void setNode(Node node) {
            this.node = node;
        }

        public boolean isImplicit() {
            return this.implicit;
        }

        public void setImplicit(boolean implicit) {
            this.implicit = implicit;
        }

        public void setTargetNodeEdgeCount(int targetNodeEdgeCount) {
            this.targetNodeEdgeCount = targetNodeEdgeCount;
        }

        public String getObjectPropNodeClassUri() {
            return this.objectPropNodeClassUri;
        }
    }

    public static class Node {
        private double x;
        private double y;
        private String objectPropClassName;
        private String objectPropClassUri;
        private String classPosition;
        private Set<Edge> allEdges;

        public Node(double x, double y, String objectPropClassName, String objectPropClassUri, String classPosition) {
            this.x = x;
            this.y = y;
            this.objectPropClassName = objectPropClassName;
            this.objectPropClassUri = objectPropClassUri;
            this.classPosition = classPosition;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public String getObjectPropClassName() {
            return this.objectPropClassName;
        }

        public String getObjectPropClassUri() {
            return this.objectPropClassUri;
        }

        public String getClassPosition() {
            return this.classPosition;
        }

        public void setAllEdges(Set<Edge> allEdges) {
            this.allEdges = allEdges;
        }

        public Set<Edge> getAllEdges() {
            return this.allEdges;
        }
    }
}

