/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.graphexplore.listener;

import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.graphexplore.service.ClassHierachyStorageService;
import jakarta.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;

@Named
public class RepositoryActionClassHierarchyListener
implements ApplicationListener<PropertyChangedEvent> {
    private final ClassHierachyStorageService classHierachyStorageService;

    @Autowired
    public RepositoryActionClassHierarchyListener(ClassHierachyStorageService classHierachyStorageService) {
        this.classHierachyStorageService = classHierachyStorageService;
    }

    public void onApplicationEvent(PropertyChangedEvent event) {
        switch (event.getKey()) {
            case "repository.id.changed": {
                this.onRepoRenamed(event);
                break;
            }
            case "repository.id.deleted": {
                this.onRepoDeleted(event);
            }
        }
    }

    private void onRepoDeleted(PropertyChangedEvent event) {
        String repoId = (String)event.getSource();
        this.classHierachyStorageService.removeRepoClassHierarchyFromCache(repoId);
    }

    private void onRepoRenamed(PropertyChangedEvent event) {
        String oldRepoId = (String)event.getSource();
        String newRepoId = event.getValue();
        this.classHierachyStorageService.updateClassHierarchyCacheWhenRepoRenamed(oldRepoId, newRepoId);
    }
}

