/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.R2RMLView;
import eu.optique.r2rml.api.model.W3C_R2RML_Recommendation;
import eu.optique.r2rml.api.model.impl.LogicalTableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class R2RMLViewImpl
extends LogicalTableImpl
implements R2RMLView {
    @W3C_R2RML_Recommendation(value="http://www.w3.org/ns/r2rml#sqlQuery")
    private String sqlQuery;
    @W3C_R2RML_Recommendation(value="http://www.w3.org/ns/r2rml#sqlVersion")
    private ArrayList<IRI> versionList;

    R2RMLViewImpl(RDF c, String sqlQuery) {
        super(c);
        this.setSqlQuery(sqlQuery);
        this.versionList = new ArrayList();
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    @Override
    public void setSqlQuery(String sqlQuery) {
        if (sqlQuery == null) {
            throw new NullPointerException("An R2RMLView must have a SQL query.");
        }
        this.sqlQuery = sqlQuery;
    }

    @Override
    public void addSQLVersion(IRI version) {
        this.versionList.add(version);
    }

    @Override
    public String getSQLQuery() {
        return this.sqlQuery;
    }

    @Override
    public IRI getSQLVersion(int index) {
        return this.versionList.get(index);
    }

    @Override
    public List<IRI> getSQLVersions() {
        return Collections.unmodifiableList(this.versionList);
    }

    @Override
    public void removeSQLVersion(IRI version) {
        this.versionList.remove(version);
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#R2RMLView")));
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#sqlQuery"), (RDFTerm)this.getRDF().createLiteral(this.getSQLQuery())));
        for (IRI version : this.versionList) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#sqlVersion"), (RDFTerm)version));
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getNode() == null ? 0 : this.getNode().hashCode());
        result = 31 * result + (this.sqlQuery == null ? 0 : this.sqlQuery.hashCode());
        result = 31 * result + (this.versionList == null ? 0 : this.versionList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof R2RMLViewImpl)) {
            return false;
        }
        R2RMLViewImpl other = (R2RMLViewImpl)obj;
        if (this.getNode() == null ? other.getNode() != null : !this.getNode().equals((Object)other.getNode())) {
            return false;
        }
        if (this.sqlQuery == null ? other.sqlQuery != null : !this.sqlQuery.equals(other.sqlQuery)) {
            return false;
        }
        return !(this.versionList == null ? other.versionList != null : !this.versionList.equals(other.versionList));
    }

    public String toString() {
        return "R2RMLViewImpl [sqlQuery=" + this.sqlQuery + ", versionList=" + String.valueOf(this.versionList) + ", node=" + String.valueOf(this.node) + "]";
    }
}

