/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.MappingFactory;
import eu.optique.r2rml.api.R2RMLMappingManager;
import eu.optique.r2rml.api.model.R2RMLMappingCollection;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import eu.optique.r2rml.api.model.impl.MappingFactoryImpl;
import eu.optique.r2rml.api.model.impl.R2RMLMappingCollectionImpl;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.RDF;

public class R2RMLMappingManagerImpl
implements R2RMLMappingManager {
    private final RDF rdf;
    private MappingFactory mf;

    public R2RMLMappingManagerImpl(RDF rdf) {
        this.rdf = rdf;
        this.mf = new MappingFactoryImpl(rdf);
    }

    protected RDF getRDF() {
        return this.rdf;
    }

    @Override
    public MappingFactory getMappingFactory() {
        return this.mf;
    }

    @Override
    public Collection<TriplesMap> importMappings(Graph graph) throws IllegalArgumentException, InvalidR2RMLMappingException {
        R2RMLMappingCollection mc = this.extractR2RMLMapping(graph);
        if (mc == null || mc.getTriplesMaps().isEmpty()) {
            throw new IllegalArgumentException("Does not contain any (valid) TriplesMaps");
        }
        for (TriplesMap map : mc.getTriplesMaps()) {
            Objects.requireNonNull(map.getLogicalTable(), () -> "No logical table for TriplesMap " + map.getNode().toString());
            if (map.getLogicalTable().getNode() == null && map.getLogicalTable().getSQLQuery() == null) {
                throw new IllegalArgumentException("No logical table for TriplesMap " + map.getNode().toString());
            }
            Objects.requireNonNull(map.getSubjectMap(), () -> map.getNode().toString() + " does not have any SubjectMap");
        }
        return mc.getTriplesMaps();
    }

    @Override
    public Graph exportMappings(Collection<TriplesMap> maps) {
        Objects.requireNonNull(maps, "The mapping collection is null.");
        if (maps.isEmpty()) {
            throw new IllegalArgumentException("The mapping collection is empty");
        }
        Graph m = this.rdf.createGraph();
        for (TriplesMap tm : maps) {
            tm.serialize().forEach(arg_0 -> ((Graph)m).add(arg_0));
        }
        return m;
    }

    protected R2RMLMappingCollection extractR2RMLMapping(Graph graph) throws InvalidR2RMLMappingException {
        return new R2RMLMappingCollectionImpl(this, this.rdf, graph);
    }
}

