/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.lang;

import java.util.Arrays;
import java.util.Set;

public final class Keywords {
    public static final String ANY = "@any";
    public static final String BASE = "@base";
    public static final String CONTAINER = "@container";
    public static final String CONTEXT = "@context";
    public static final String DIRECTION = "@direction";
    public static final String GRAPH = "@graph";
    public static final String ID = "@id";
    public static final String IMPORT = "@import";
    public static final String INCLUDED = "@included";
    public static final String INDEX = "@index";
    public static final String JSON = "@json";
    public static final String LANGUAGE = "@language";
    public static final String LIST = "@list";
    public static final String NEST = "@nest";
    public static final String NONE = "@none";
    public static final String PREFIX = "@prefix";
    public static final String PRESERVE = "@preserve";
    public static final String PROPAGATE = "@propagate";
    public static final String PROTECTED = "@protected";
    public static final String REVERSE = "@reverse";
    public static final String SET = "@set";
    public static final String TYPE = "@type";
    public static final String VALUE = "@value";
    public static final String VERSION = "@version";
    public static final String VOCAB = "@vocab";
    public static final String DEFAULT = "@default";
    public static final String EMBED = "@embed";
    public static final String ALWAYS = "@always";
    public static final String ONCE = "@once";
    public static final String NEVER = "@never";
    public static final String EXPLICIT = "@explicit";
    public static final String NULL = "@null";
    public static final String OMIT_DEFAULT = "@omitDefault";
    public static final String REQUIRE_ALL = "@requireAll";
    public static final String MERGED = "@merged";
    public static final String ANNOTATION = "@annotation";
    private static final Set<String> ALL_KEYWORDS = Set.of("@any", "@base", "@container", "@context", "@direction", "@graph", "@id", "@import", "@included", "@index", "@json", "@language", "@list", "@nest", "@none", "@prefix", "@preserve", "@propagate", "@protected", "@reverse", "@set", "@type", "@value", "@version", "@vocab", "@default", "@embed", "@always", "@once", "@never", "@explicit", "@null", "@omitDefault", "@requireAll", "@merged", "@annotation");
    private static final int ALL_KEYWORDS_MAX_LENGTH = ALL_KEYWORDS.stream().mapToInt(String::length).max().getAsInt();
    private static final int ALL_KEYWORDS_MIN_LENGTH = ALL_KEYWORDS.stream().mapToInt(String::length).min().getAsInt();

    protected Keywords() {
    }

    public static boolean contains(String value) {
        if (value == null) {
            return false;
        }
        int length = value.length();
        if (length >= ALL_KEYWORDS_MIN_LENGTH && length <= ALL_KEYWORDS_MAX_LENGTH) {
            return ALL_KEYWORDS.contains(value);
        }
        return false;
    }

    public static boolean matchForm(String value) {
        if (value.length() < 2 || value.charAt(0) != '@') {
            return false;
        }
        for (int i = 1; i < value.length(); ++i) {
            if (Character.isAlphabetic(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean noneMatch(String key, String keyword1, String keyword2) {
        return !key.equals(keyword1) && !key.equals(keyword2);
    }

    public static boolean noneMatch(String key, String ... keywords) {
        for (String k : keywords) {
            if (!k.equals(key)) continue;
            return false;
        }
        return true;
    }

    public static boolean anyMatch(String key, String ... keywords) {
        return Arrays.asList(keywords).contains(key);
    }

    public static boolean notAllMatch(Set<String> values, Set<String> keywords) {
        return !keywords.containsAll(values);
    }
}

