/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.json;

import com.apicatalog.jsonld.StringUtils;
import com.apicatalog.jsonld.json.JsonProvider;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class JsonUtils {
    JsonUtils() {
    }

    public static boolean contains(String text, JsonValue value) {
        if (text == null) {
            return value == null;
        }
        if (value == null) {
            return false;
        }
        if (JsonUtils.isString(value)) {
            return text.equals(((JsonString)value).getString());
        }
        if (JsonUtils.isArray(value)) {
            return value.asJsonArray().contains((Object)JsonProvider.instance().createValue(text));
        }
        if (JsonUtils.isObject(value)) {
            return value.asJsonObject().containsKey((Object)text);
        }
        return false;
    }

    public static boolean containsKey(JsonValue object, String key) {
        return object != null && JsonValue.ValueType.OBJECT == object.getValueType() && object.asJsonObject().containsKey((Object)key);
    }

    public static boolean isScalar(JsonValue value) {
        return value != null && JsonValue.ValueType.ARRAY != value.getValueType() && JsonValue.ValueType.OBJECT != value.getValueType();
    }

    public static boolean isNotScalar(JsonValue value) {
        return !JsonUtils.isScalar(value);
    }

    public static boolean isNull(JsonValue value) {
        return value == null || JsonValue.ValueType.NULL == value.getValueType();
    }

    public static boolean isNotNull(JsonValue value) {
        return !JsonUtils.isNull(value);
    }

    public static boolean isString(JsonValue value) {
        return value != null && JsonValue.ValueType.STRING == value.getValueType();
    }

    public static boolean isNotString(JsonValue value) {
        return value == null || JsonValue.ValueType.STRING != value.getValueType();
    }

    public static boolean isNotArray(JsonValue value) {
        return value == null || JsonValue.ValueType.ARRAY != value.getValueType();
    }

    public static boolean isArray(JsonValue value) {
        return value != null && JsonValue.ValueType.ARRAY == value.getValueType();
    }

    public static boolean isObject(JsonValue value) {
        return value != null && JsonValue.ValueType.OBJECT == value.getValueType();
    }

    public static boolean isNotObject(JsonValue value) {
        return value == null || JsonValue.ValueType.OBJECT != value.getValueType();
    }

    public static boolean isNumber(JsonValue value) {
        return value != null && JsonValue.ValueType.NUMBER == value.getValueType();
    }

    public static boolean isNotBoolean(JsonValue value) {
        return value == null || JsonValue.ValueType.TRUE != value.getValueType() && JsonValue.ValueType.FALSE != value.getValueType();
    }

    public static boolean isNotNumber(JsonValue value) {
        return value == null || JsonValue.ValueType.NUMBER != value.getValueType();
    }

    public static boolean isTrue(JsonValue value) {
        return value != null && JsonValue.ValueType.TRUE == value.getValueType();
    }

    public static boolean isFalse(JsonValue value) {
        return value != null && JsonValue.ValueType.FALSE == value.getValueType();
    }

    public static boolean isEmptyObject(JsonValue value) {
        return JsonUtils.isObject(value) && value.asJsonObject().isEmpty();
    }

    public static boolean isEmptyArray(JsonValue value) {
        return JsonUtils.isArray(value) && value.asJsonArray().isEmpty();
    }

    public static JsonObject toJsonObject(Map<String, JsonValue> map) {
        JsonObjectBuilder builder = JsonProvider.instance().createObjectBuilder();
        map.forEach((arg_0, arg_1) -> ((JsonObjectBuilder)builder).add(arg_0, arg_1));
        return builder.build();
    }

    public static JsonObject merge(JsonObject target, JsonObject source) {
        LinkedHashMap<String, JsonValue> targetMap = new LinkedHashMap<String, JsonValue>((Map<String, JsonValue>)target);
        targetMap.putAll((Map<String, JsonValue>)source);
        return JsonUtils.toJsonObject(targetMap);
    }

    public static Collection<JsonValue> toCollection(JsonValue value) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (JsonValue.ValueType.ARRAY == value.getValueType()) {
            return value.asJsonArray();
        }
        return Collections.singletonList(value);
    }

    public static Stream<JsonValue> toStream(JsonValue value) {
        if (value == null) {
            return Stream.empty();
        }
        if (JsonValue.ValueType.ARRAY == value.getValueType()) {
            return value.asJsonArray().stream();
        }
        return Stream.of(value);
    }

    public static JsonArray toJsonArray(JsonValue value) {
        return JsonUtils.isArray(value) ? value.asJsonArray() : JsonProvider.instance().createArrayBuilder().add(value).build();
    }

    public static boolean isBlankString(JsonValue value) {
        return JsonUtils.isString(value) && StringUtils.isBlank(((JsonString)value).getString());
    }

    public static JsonValue toJsonValue(String value) {
        return StringUtils.isNotBlank(value) ? JsonProvider.instance().createValue(value) : JsonValue.NULL;
    }

    public static boolean isNonEmptyArray(JsonValue value) {
        return JsonUtils.isArray(value) && !value.asJsonArray().isEmpty();
    }

    public static boolean isNonEmptyObject(JsonValue value) {
        return JsonUtils.isObject(value) && !value.asJsonObject().isEmpty();
    }

    @Deprecated
    public static boolean isNotEmptyArray(JsonValue value) {
        return JsonUtils.isNotArray(value) || !value.asJsonArray().isEmpty();
    }

    @Deprecated
    public static boolean isNotEmptyObject(JsonValue value) {
        return JsonUtils.isNotObject(value) || !value.asJsonObject().isEmpty();
    }

    public static JsonValue flatten(JsonValue value, String key) {
        if (JsonUtils.isArray(value) && value.asJsonArray().size() == 1) {
            value = (JsonValue)value.asJsonArray().get(0);
        }
        if (JsonUtils.isObject(value) && value.asJsonObject().containsKey((Object)key)) {
            value = (JsonValue)value.asJsonObject().get((Object)key);
        }
        return value;
    }

    public static void withStrings(JsonValue value, Consumer<String> addContainerMapping) {
        if (JsonValue.ValueType.ARRAY == value.getValueType()) {
            JsonArray asJsonArray = value.asJsonArray();
            int asJsonArraySize = asJsonArray.size();
            for (int i = 0; i < asJsonArraySize; ++i) {
                JsonValue v = (JsonValue)asJsonArray.get(i);
                if (!JsonUtils.isString(v)) continue;
                addContainerMapping.accept(((JsonString)v).getString());
            }
        } else if (JsonUtils.isString(value)) {
            addContainerMapping.accept(((JsonString)value).getString());
        }
    }

    public static List<String> optimizedGetStrings(JsonValue value) {
        if (JsonValue.ValueType.ARRAY == value.getValueType()) {
            JsonArray jsonArray = value.asJsonArray();
            if (jsonArray.isEmpty()) {
                return List.of();
            }
            if (jsonArray.size() == 1) {
                if (JsonUtils.isString((JsonValue)jsonArray.get(0))) {
                    return List.of(jsonArray.getString(0));
                }
                return List.of();
            }
            if (jsonArray.size() == 2 && JsonUtils.isString((JsonValue)jsonArray.get(0)) && JsonUtils.isString((JsonValue)jsonArray.get(1))) {
                String string1;
                String string0 = jsonArray.getString(0);
                if (string0.compareTo(string1 = jsonArray.getString(1)) <= 0) {
                    return List.of(string0, string1);
                }
                return List.of(string1, string0);
            }
        } else if (JsonUtils.isString(value)) {
            return List.of(((JsonString)value).getString());
        }
        return JsonUtils.toStream(value).filter(JsonUtils::isString).map(JsonString.class::cast).map(JsonString::getString).sorted().collect(Collectors.toList());
    }
}

