/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.flattening;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.json.JsonProvider;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.lang.NodeObject;
import com.apicatalog.jsonld.lang.Utils;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class NodeMapBuilder {
    private JsonStructure element;
    private final NodeMap nodeMap;
    private String activeGraph;
    private String activeSubject;
    private String activeProperty;
    private Map<String, JsonValue> referencedNode;
    private Map<String, JsonValue> list;

    private NodeMapBuilder(JsonStructure element, NodeMap nodeMap) {
        this.element = element;
        this.nodeMap = nodeMap;
        this.activeGraph = "@default";
        this.activeSubject = null;
        this.activeProperty = null;
        this.list = null;
        this.referencedNode = null;
    }

    public static NodeMapBuilder with(JsonStructure element, NodeMap nodeMap) {
        return new NodeMapBuilder(element, nodeMap);
    }

    public NodeMapBuilder activeGraph(String activeGraph) {
        this.activeGraph = activeGraph;
        return this;
    }

    public NodeMapBuilder activeProperty(String activeProperty) {
        this.activeProperty = activeProperty;
        return this;
    }

    public NodeMapBuilder activeSubject(String activeSubject) {
        this.activeSubject = activeSubject;
        return this;
    }

    public NodeMapBuilder list(Map<String, JsonValue> list) {
        this.list = list;
        return this;
    }

    public NodeMapBuilder referencedNode(Map<String, JsonValue> referencedNode) {
        this.referencedNode = referencedNode;
        return this;
    }

    public static NodeMap getNodeMap(JsonStructure element, JsonLdOptions options) throws JsonLdError {
        NodeMap nodeMap = NodeMapBuilder.with(element, options != null && options.getGenerator() != null ? new NodeMap(options.getGenerator()) : new NodeMap()).build();
        if (options != null) {
            options.setGenerator(options.getGenerator());
        }
        return nodeMap;
    }

    public NodeMap build() throws JsonLdError {
        if (JsonUtils.isArray((JsonValue)this.element)) {
            for (JsonValue item2 : this.element.asJsonArray()) {
                JsonObject itemValue;
                if (JsonUtils.isObject(item2)) {
                    itemValue = item2.asJsonObject();
                } else if (JsonUtils.isArray(item2)) {
                    itemValue = item2.asJsonArray();
                } else {
                    throw new IllegalStateException();
                }
                NodeMapBuilder.with((JsonStructure)itemValue, this.nodeMap).activeGraph(this.activeGraph).activeProperty(this.activeProperty).activeSubject(this.activeSubject).list(this.list).referencedNode(this.referencedNode).build();
            }
            return this.nodeMap;
        }
        LinkedHashMap<String, JsonValue> elementObject = new LinkedHashMap<String, JsonValue>((Map<String, JsonValue>)this.element.asJsonObject());
        if (elementObject.containsKey("@type")) {
            JsonArrayBuilder types = JsonProvider.instance().createArrayBuilder();
            JsonUtils.toStream((JsonValue)elementObject.get("@type")).map(item -> JsonUtils.isString(item) && BlankNode.hasPrefix(((JsonString)item).getString()) ? JsonProvider.instance().createValue(this.nodeMap.createIdentifier(((JsonString)item).getString())) : item).forEach(arg_0 -> ((JsonArrayBuilder)types).add(arg_0));
            elementObject.put("@type", (JsonValue)types.build());
        }
        if (elementObject.containsKey("@value")) {
            if (this.list == null) {
                JsonValue jsonValue = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty);
                if (jsonValue != null) {
                    JsonArray activePropertyValue = jsonValue.asJsonArray();
                    if (NodeMapBuilder.noneMatch(activePropertyValue, this.element)) {
                        this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder(activePropertyValue).add((JsonValue)this.element).build());
                    }
                } else {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder().add((JsonValue)JsonUtils.toJsonObject(elementObject)).build());
                }
            } else {
                this.list.put("@list", (JsonValue)JsonProvider.instance().createArrayBuilder(this.list.get("@list").asJsonArray()).add((JsonValue)this.element).build());
            }
        } else if (elementObject.containsKey("@list")) {
            LinkedHashMap<String, JsonValue> result = new LinkedHashMap<String, JsonValue>();
            result.put("@list", (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
            NodeMapBuilder.with((JsonStructure)elementObject.get("@list"), this.nodeMap).activeGraph(this.activeGraph).activeSubject(this.activeSubject).activeProperty(this.activeProperty).referencedNode(this.referencedNode).list(result).build();
            if (this.list == null) {
                if (this.nodeMap.contains(this.activeGraph, this.activeSubject, this.activeProperty)) {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder(this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty).asJsonArray()).add((JsonValue)JsonUtils.toJsonObject(result)).build());
                } else {
                    this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder().add((JsonValue)JsonUtils.toJsonObject(result)).build());
                }
            } else {
                this.list.put("@list", (JsonValue)JsonProvider.instance().createArrayBuilder(this.list.get("@list").asJsonArray()).add((JsonValue)JsonUtils.toJsonObject(result)).build());
            }
        } else if (NodeObject.isNodeObject((JsonValue)this.element)) {
            boolean finished = false;
            String id = null;
            if (elementObject.containsKey("@id")) {
                JsonValue idValue = (JsonValue)elementObject.get("@id");
                if (JsonUtils.isNull(idValue) || JsonUtils.isNotString(idValue)) {
                    finished = true;
                } else {
                    id = ((JsonString)idValue).getString();
                    if (BlankNode.hasPrefix(id)) {
                        id = this.nodeMap.createIdentifier(id);
                    }
                    elementObject.remove("@id");
                }
            } else {
                id = this.nodeMap.createIdentifier();
            }
            if (!finished) {
                if (id != null && !this.nodeMap.contains(this.activeGraph, id)) {
                    this.nodeMap.set(this.activeGraph, id, "@id", (JsonValue)JsonProvider.instance().createValue(id));
                }
                if (this.referencedNode != null) {
                    if (this.nodeMap.contains(this.activeGraph, id, this.activeProperty)) {
                        JsonArray activePropertyValue = this.nodeMap.get(this.activeGraph, id, this.activeProperty).asJsonArray();
                        if (activePropertyValue.stream().filter(JsonUtils::isObject).noneMatch(e -> Objects.equals(e.asJsonObject(), JsonUtils.toJsonObject(this.referencedNode)))) {
                            this.nodeMap.set(this.activeGraph, id, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder(activePropertyValue).add((JsonValue)JsonUtils.toJsonObject(this.referencedNode)).build());
                        }
                    } else {
                        this.nodeMap.set(this.activeGraph, id, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder().add((JsonValue)JsonUtils.toJsonObject(this.referencedNode)).build());
                    }
                } else if (this.activeProperty != null) {
                    JsonObject reference = JsonProvider.instance().createObjectBuilder().add("@id", id).build();
                    if (this.list == null) {
                        if (this.nodeMap.contains(this.activeGraph, this.activeSubject, this.activeProperty)) {
                            JsonArray activePropertyValue = this.nodeMap.get(this.activeGraph, this.activeSubject, this.activeProperty).asJsonArray();
                            if (activePropertyValue.stream().noneMatch(e -> Objects.equals(e, reference))) {
                                this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder(activePropertyValue).add((JsonValue)reference).build());
                            }
                        } else {
                            this.nodeMap.set(this.activeGraph, this.activeSubject, this.activeProperty, (JsonValue)JsonProvider.instance().createArrayBuilder().add((JsonValue)reference).build());
                        }
                    } else {
                        this.list.put("@list", (JsonValue)JsonProvider.instance().createArrayBuilder(this.list.get("@list").asJsonArray()).add((JsonValue)reference).build());
                    }
                }
                if (elementObject.containsKey("@type")) {
                    Object typeValue;
                    Set<JsonValue> nodeType = Set.of();
                    JsonValue nodeTypeValue = this.nodeMap.get(this.activeGraph, id, "@type");
                    if (JsonUtils.isArray(nodeTypeValue)) {
                        for (Object jsonValue : nodeTypeValue.asJsonArray()) {
                            if (!JsonUtils.isNotNull((JsonValue)jsonValue)) continue;
                            nodeType = NodeMapBuilder.optimizedAddToSet((JsonValue)jsonValue, nodeType);
                        }
                    } else if (JsonUtils.isNotNull(nodeTypeValue)) {
                        nodeType = NodeMapBuilder.optimizedAddToSet(nodeTypeValue, nodeType);
                    }
                    if (JsonUtils.isArray((JsonValue)(typeValue = (JsonValue)elementObject.get("@type")))) {
                        for (JsonValue jsonValue : typeValue.asJsonArray()) {
                            if (!JsonUtils.isNotNull(jsonValue)) continue;
                            nodeType = NodeMapBuilder.optimizedAddToSet(jsonValue, nodeType);
                        }
                    } else if (JsonUtils.isNotNull((JsonValue)typeValue)) {
                        nodeType = NodeMapBuilder.optimizedAddToSet((JsonValue)typeValue, nodeType);
                    }
                    JsonArrayBuilder nodeTypeBuilder = JsonProvider.instance().createArrayBuilder();
                    nodeType.forEach(arg_0 -> ((JsonArrayBuilder)nodeTypeBuilder).add(arg_0));
                    this.nodeMap.set(this.activeGraph, id, "@type", (JsonValue)nodeTypeBuilder.build());
                    elementObject.remove("@type");
                }
                if (elementObject.containsKey("@index")) {
                    if (this.nodeMap.contains(this.activeGraph, id, "@index")) {
                        throw new JsonLdError(JsonLdErrorCode.CONFLICTING_INDEXES);
                    }
                    this.nodeMap.set(this.activeGraph, id, "@index", (JsonValue)elementObject.get("@index"));
                    elementObject.remove("@index");
                }
                if (elementObject.containsKey("@reverse")) {
                    LinkedHashMap<String, JsonValue> referenced = new LinkedHashMap<String, JsonValue>();
                    referenced.put("@id", (JsonValue)JsonProvider.instance().createValue(id));
                    JsonValue reverseMap = (JsonValue)elementObject.get("@reverse");
                    for (Map.Entry entry : reverseMap.asJsonObject().entrySet()) {
                        for (JsonValue value : ((JsonValue)entry.getValue()).asJsonArray()) {
                            NodeMapBuilder.with((JsonStructure)value, this.nodeMap).activeGraph(this.activeGraph).referencedNode(referenced).activeProperty((String)entry.getKey()).build();
                        }
                    }
                    elementObject.remove("@reverse");
                }
                if (elementObject.containsKey("@graph")) {
                    NodeMapBuilder.with((JsonStructure)elementObject.get("@graph"), this.nodeMap).activeGraph(id).build();
                    elementObject.remove("@graph");
                }
                if (elementObject.containsKey("@included")) {
                    NodeMapBuilder.with((JsonStructure)elementObject.get("@included"), this.nodeMap).activeGraph(this.activeGraph).build();
                    elementObject.remove("@included");
                }
                for (String property : Utils.index(elementObject.keySet(), true)) {
                    JsonValue value = (JsonValue)elementObject.get(property);
                    if (value == null || !JsonValue.ValueType.ARRAY.equals((Object)value.getValueType()) && !JsonValue.ValueType.OBJECT.equals((Object)value.getValueType())) continue;
                    if (BlankNode.hasPrefix(property)) {
                        property = this.nodeMap.createIdentifier(property);
                    }
                    if (!this.nodeMap.contains(this.activeGraph, id, property)) {
                        this.nodeMap.set(this.activeGraph, id, property, (JsonValue)JsonValue.EMPTY_JSON_ARRAY);
                    }
                    NodeMapBuilder.with((JsonStructure)value, this.nodeMap).activeGraph(this.activeGraph).activeSubject(id).activeProperty(property).build();
                }
            }
        }
        return this.nodeMap;
    }

    private static Set<JsonValue> optimizedAddToSet(JsonValue jsonValue, Set<JsonValue> nodeType) {
        if (nodeType.isEmpty()) {
            nodeType = Set.of(jsonValue);
        } else if (nodeType.size() == 1 && !nodeType.contains(jsonValue)) {
            nodeType = Set.of((JsonValue)nodeType.toArray()[0], jsonValue);
        } else if (nodeType.size() == 2) {
            nodeType = new LinkedHashSet<JsonValue>(nodeType);
            nodeType.add(jsonValue);
        } else if (nodeType.size() > 2) {
            nodeType.add(jsonValue);
        }
        return nodeType;
    }

    private static boolean noneMatch(JsonArray activePropertyValue, JsonStructure reference) {
        if (activePropertyValue.isEmpty()) {
            return true;
        }
        int referenceHashCode = reference.hashCode();
        int activePropertyValueSize = activePropertyValue.size();
        for (int i = 0; i < activePropertyValueSize; ++i) {
            JsonValue e = (JsonValue)activePropertyValue.get(i);
            if (referenceHashCode != e.hashCode() || !reference.equals(e)) continue;
            return false;
        }
        return true;
    }
}

