/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.util;

import com.ontotext.trree.plugin.externalsync.util.XsdTemporalAccessor;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class ValuesUtil {
    public static final ValuesUtil WITH_TIMEZONE = new ValuesUtil(false);
    public static final ValuesUtil WITHOUT_TIMEZONE;
    public static final ValuesUtil INSTANCE;
    private static final DateTimeFormatter ISO_DATE_TIME_COMPACT;
    private static final DateTimeFormatter ISO_DATE_COMPACT;
    private static final DateTimeFormatter FLEXIBLE_ISO_DATE_TIME;
    private static final DateTimeFormatter FLEXIBLE_ISO_TIME;
    private static final Map<IRI, DateTimeFormatter> ISO_TO_XML_CONVERSION;
    private static final Set<IRI> YEAR_BASED_XSD_TYPES;
    private final Map<IRI, DateTimeFormatter> xmlToIsoConversion = new HashMap<IRI, DateTimeFormatter>(){
        {
            this.put(XSD.DATETIME, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
            this.put(XSD.DATE, DateTimeFormatter.ISO_OFFSET_DATE);
            this.put(XSD.TIME, DateTimeFormatter.ISO_OFFSET_TIME);
            this.put(XSD.GYEAR, DateTimeFormatter.ofPattern("uuuu"));
            this.put(XSD.GYEARMONTH, DateTimeFormatter.ofPattern("uuuu-MM"));
        }
    };
    public boolean ignoreTimezoneWithoutTime;

    private ValuesUtil(boolean ignoreTimezoneWithoutTime) {
        this.ignoreTimezoneWithoutTime = ignoreTimezoneWithoutTime;
        if (ignoreTimezoneWithoutTime) {
            this.xmlToIsoConversion.put(XSD.DATE, DateTimeFormatter.ofPattern("uuuu-MM-dd"));
        }
    }

    public String xsdTemporalAsNormalizedCompactISO(String value, IRI datatype) {
        if (!YEAR_BASED_XSD_TYPES.contains(datatype)) {
            throw new IllegalArgumentException("Unsupported datatype: " + String.valueOf(datatype));
        }
        return this.xsdTemporalAsISOWithFormatter(value, datatype, ISO_DATE_TIME_COMPACT);
    }

    public String xsdTemporalAsNormalizedCompactDateOnlyISO(String value, IRI datatype) {
        if (!YEAR_BASED_XSD_TYPES.contains(datatype)) {
            throw new IllegalArgumentException("Unsupported datatype: " + String.valueOf(datatype));
        }
        return this.xsdTemporalAsISOWithFormatter(value, datatype, ISO_DATE_COMPACT);
    }

    public String xsdTemporalAsNormalizedISO(String value, IRI datatype) {
        if (!YEAR_BASED_XSD_TYPES.contains(datatype)) {
            throw new IllegalArgumentException("Unsupported datatype: " + String.valueOf(datatype));
        }
        return this.xsdTemporalAsISOWithFormatter(value, datatype, DateTimeFormatter.ISO_INSTANT);
    }

    public String xsdTemporalAsISO(String value, IRI datatype) {
        DateTimeFormatter formatter = this.xmlToIsoConversion.get(datatype);
        if (formatter == null) {
            throw new IllegalArgumentException("Unsupported datatype: " + String.valueOf(datatype));
        }
        return this.xsdTemporalAsISOWithFormatter(value, datatype, formatter);
    }

    public boolean isSupportedType(IRI datatype) {
        return this.xmlToIsoConversion.containsKey(datatype);
    }

    public String xsdTemporalAsISOWithFormatter(String value, IRI datatype, DateTimeFormatter formatter) {
        if (XMLDatatypeUtil.isValidValue((String)value, (IRI)datatype)) {
            XMLGregorianCalendar xmlCal = XMLDatatypeUtil.parseCalendar((String)value);
            if (xmlCal.getTimezone() == Integer.MIN_VALUE || this.ignoreTimezoneWithoutTime && xmlCal.getHour() == Integer.MIN_VALUE) {
                xmlCal.setTimezone(0);
            }
            return formatter.format(xmlCal.toGregorianCalendar().toZonedDateTime());
        }
        throw new IllegalArgumentException("Not a valid " + String.valueOf(datatype) + " value: " + value);
    }

    public long xsdTemporalAsMillis(String value, IRI datatype) {
        DateTimeFormatter formatter = this.xmlToIsoConversion.get(datatype);
        if (formatter == null) {
            throw new IllegalArgumentException("Unsupported datatype: " + String.valueOf(datatype));
        }
        if (XMLDatatypeUtil.isValidValue((String)value, (IRI)datatype)) {
            XMLGregorianCalendar xmlCal = XMLDatatypeUtil.parseCalendar((String)value);
            if (xmlCal.getTimezone() == Integer.MIN_VALUE || this.ignoreTimezoneWithoutTime && xmlCal.getHour() == Integer.MIN_VALUE) {
                xmlCal.setTimezone(0);
            }
            return xmlCal.toGregorianCalendar().getTimeInMillis();
        }
        throw new IllegalArgumentException("Not a valid " + String.valueOf(datatype) + " value: " + value);
    }

    public Literal isoToXsd(String value, IRI datatype, ValueFactory valueFactory) {
        DateTimeFormatter isoFormatter = XSD.TIME.equals((Object)datatype) ? FLEXIBLE_ISO_TIME : FLEXIBLE_ISO_DATE_TIME;
        XsdTemporalAccessor parsed = new XsdTemporalAccessor(isoFormatter.parse(value), this.ignoreTimezoneWithoutTime);
        DateTimeFormatter xsdFormatter = ISO_TO_XML_CONVERSION.get(datatype);
        String xsdValue = xsdFormatter.format(parsed);
        if (xsdValue.endsWith("Z")) {
            xsdValue = xsdValue.substring(0, xsdValue.length() - 1);
        }
        return valueFactory.createLiteral(xsdValue, datatype);
    }

    static {
        INSTANCE = WITHOUT_TIMEZONE = new ValuesUtil(true);
        ISO_DATE_TIME_COMPACT = DateTimeFormatter.ofPattern("uuuuMMddHHmmss").withZone(ZoneOffset.UTC);
        ISO_DATE_COMPACT = DateTimeFormatter.ofPattern("uuuuMMdd").withZone(ZoneOffset.UTC);
        FLEXIBLE_ISO_DATE_TIME = DateTimeFormatter.ofPattern("uuuu[-MM[-dd['T'HH:mm:ss[.SSS]]]][ZZZZZ]").withZone(ZoneOffset.UTC);
        FLEXIBLE_ISO_TIME = DateTimeFormatter.ofPattern("HH:mm:ss[.SSS][ZZZZZ]").withZone(ZoneOffset.UTC);
        ISO_TO_XML_CONVERSION = new HashMap<IRI, DateTimeFormatter>(){
            {
                this.put(XSD.DATETIME, DateTimeFormatter.ISO_DATE_TIME);
                this.put(XSD.DATE, DateTimeFormatter.ISO_DATE);
                this.put(XSD.TIME, DateTimeFormatter.ISO_TIME);
                this.put(XSD.GYEAR, DateTimeFormatter.ofPattern("uuuu[ZZZZZ]"));
                this.put(XSD.GYEARMONTH, DateTimeFormatter.ofPattern("uuuu-MM[ZZZZZ]"));
            }
        };
        YEAR_BASED_XSD_TYPES = new HashSet<IRI>(){
            {
                this.add(XSD.DATETIME);
                this.add(XSD.DATE);
                this.add(XSD.GYEARMONTH);
                this.add(XSD.GYEAR);
            }
        };
    }
}

