/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.sequences;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.ontotext.trree.plugin.sequences.FingerprintedSequences;
import com.ontotext.trree.plugin.sequences.Sequence;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.InitReason;
import com.ontotext.trree.sdk.PatternInterpreter;
import com.ontotext.trree.sdk.PluginBase;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.PluginException;
import com.ontotext.trree.sdk.PluginTransactionListener;
import com.ontotext.trree.sdk.RequestContext;
import com.ontotext.trree.sdk.ShutdownReason;
import com.ontotext.trree.sdk.StatementIterator;
import com.ontotext.trree.sdk.UpdateInterpreter;
import gnu.trove.TLongObjectHashMap;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class SequencesPlugin
extends PluginBase
implements PluginTransactionListener,
PatternInterpreter,
UpdateInterpreter {
    private static final String NS = "http://www.ontotext.com/plugins/sequences#";
    private static final String CREATE_LOCAL_NAME = "create";
    private static final String DROP_LOCAL_NAME = "drop";
    private static final String RESET_LOCAL_NAME = "reset";
    private static final String PREPARE_LOCAL_NAME = "prepare";
    private static final String NEXT_VALUE_LOCAL_NAME = "nextValue";
    private static final String CURRENT_VALUE_LOCAL_NAME = "currentValue";
    private static final IRI RESET_IRI = SimpleValueFactory.getInstance().createIRI("http://www.ontotext.com/plugins/sequences#", "reset");
    private long createSequenceId;
    private long dropSequenceId;
    private long resetSequenceId;
    private long prepareSequenceId;
    private long nextValueId;
    private long currentValueId;
    private volatile boolean preparedForUse;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final TLongObjectHashMap<Sequence> sequencesById = new TLongObjectHashMap();
    private final TreeMap<String, Sequence> sequencesByIRI = new TreeMap();
    private Path statePath;
    private final FingerprintedSequences fingerprintedSequences = new FingerprintedSequences();
    private long expectedFingerprint;

    public String getName() {
        return "sequences";
    }

    public void initialize(InitReason reason, PluginConnection pluginConnection) {
        super.initialize(reason, pluginConnection);
        this.createSequenceId = this.newSystemIri(pluginConnection, CREATE_LOCAL_NAME);
        this.dropSequenceId = this.newSystemIri(pluginConnection, DROP_LOCAL_NAME);
        this.resetSequenceId = this.newSystemIri(pluginConnection, RESET_LOCAL_NAME);
        this.prepareSequenceId = this.newSystemIri(pluginConnection, PREPARE_LOCAL_NAME);
        this.nextValueId = this.newSystemIri(pluginConnection, NEXT_VALUE_LOCAL_NAME);
        this.currentValueId = this.newSystemIri(pluginConnection, CURRENT_VALUE_LOCAL_NAME);
        this.statePath = this.getDataDir().toPath().resolve("state.js");
        this.readStateFromDisk(pluginConnection);
    }

    public void shutdown(ShutdownReason reason) {
        this.sequencesById.clear();
        this.sequencesByIRI.clear();
        this.fingerprintedSequences.clear();
    }

    public void transactionStarted(PluginConnection pluginConnection) {
    }

    public void transactionCommit(PluginConnection pluginConnection) {
        if (this.preparedForUse) {
            this.sequencesById.forEachValue(sequence -> {
                sequence.prepare();
                return true;
            });
            this.saveStateToDisk();
        }
    }

    public void transactionCompleted(PluginConnection pluginConnection) {
        if (this.preparedForUse) {
            this.preparedForUse = false;
            this.sequencesById.forEachValue(sequence -> {
                sequence.commit();
                return true;
            });
        }
    }

    public void transactionAborted(PluginConnection pluginConnection) {
        if (this.preparedForUse) {
            this.preparedForUse = false;
            this.sequencesById.forEachValue(sequence -> {
                sequence.rollback();
                return true;
            });
        }
    }

    public double estimate(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (subject == 0L || object == Long.MAX_VALUE) {
            return Double.POSITIVE_INFINITY;
        }
        return 1.0;
    }

    public StatementIterator interpret(long subject, long predicate, long object, long context, PluginConnection pluginConnection, RequestContext requestContext) {
        if (predicate == this.nextValueId || predicate == this.currentValueId) {
            long value;
            if (!this.preparedForUse || pluginConnection.getTransactionId() == 0L) {
                throw new PluginException("Sequences must be prepared before use in transaction");
            }
            if (subject == 0L) {
                return StatementIterator.EMPTY;
            }
            Sequence sequence = (Sequence)this.sequencesById.get(subject);
            if (sequence == null) {
                throw new PluginException("No such sequence: " + pluginConnection.getEntities().get(subject));
            }
            if (predicate == this.nextValueId) {
                value = sequence.nextValue();
                pluginConnection.getRepository().addStatement((Resource)pluginConnection.getEntities().get(subject), RESET_IRI, (Value)SimpleValueFactory.getInstance().createLiteral(value + 1L), new Resource[0]);
            } else {
                value = sequence.currentValue();
            }
            return StatementIterator.create((long)subject, (long)predicate, (long)pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createLiteral(value), Entities.Scope.REQUEST), (long)context);
        }
        return null;
    }

    public long[] getPredicatesToListenFor() {
        return new long[]{this.createSequenceId, this.dropSequenceId, this.prepareSequenceId, this.resetSequenceId};
    }

    public boolean interpretUpdate(long subject, long predicate, long object, long context, boolean isAddition, boolean isExplicit, PluginConnection pluginConnection) {
        if (predicate == this.createSequenceId) {
            Value subjectValue = pluginConnection.getEntities().get(subject);
            subject = pluginConnection.getEntities().put(subjectValue, Entities.Scope.SYSTEM);
            if (this.sequencesById.contains(subject)) {
                throw new PluginException("Sequence " + subjectValue + " already exists");
            }
            Sequence sequence = new Sequence(this.parseNumber(pluginConnection, object));
            this.sequencesById.put(subject, (Object)sequence);
            this.sequencesByIRI.put(subjectValue.stringValue(), sequence);
            this.getLogger().debug("Created sequence {}", (Object)subjectValue);
        } else if (predicate == this.dropSequenceId) {
            Value subjectValue = pluginConnection.getEntities().get(subject);
            this.sequencesById.remove(subject);
            this.sequencesByIRI.remove(subjectValue.stringValue());
            this.getLogger().debug("Removed sequence {}", (Object)subjectValue);
        } else if (predicate == this.resetSequenceId) {
            Value subjectValue = pluginConnection.getEntities().get(subject);
            Sequence sequence = (Sequence)this.sequencesById.get(subject);
            if (sequence == null) {
                throw new PluginException("Sequence " + subjectValue + " does not exist");
            }
            long value = this.parseNumber(pluginConnection, object);
            sequence.setValue(value);
            this.getLogger().debug("Set sequence {} to value {}", (Object)subjectValue, (Object)value);
        } else if (predicate == this.prepareSequenceId) {
            this.getLogger().debug("Prepared sequences");
        }
        this.preparedForUse = true;
        return true;
    }

    public long getFingerprint() {
        if (this.sequencesByIRI.isEmpty()) {
            return 0L;
        }
        return this.sequencesByIRI.hashCode();
    }

    public void setFingerprint(long fingerprint) {
        this.expectedFingerprint = fingerprint;
    }

    private long newSystemIri(PluginConnection pluginConnection, String localName) {
        return pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createIRI(NS, localName), Entities.Scope.SYSTEM);
    }

    private long parseNumber(PluginConnection pluginConnection, long valueId) {
        Value value = pluginConnection.getEntities().get(valueId);
        if (value instanceof BNode) {
            return 0L;
        }
        if (value instanceof Literal) {
            try {
                return ((Literal)value).longValue() - 1L;
            }
            catch (NumberFormatException e) {
                throw new PluginException("Provided sequence start is not a number: " + value);
            }
        }
        throw new PluginException("Provided sequence start is not a number: " + value);
    }

    private void saveStateToDisk() {
        try {
            long fingerprint = this.getFingerprint();
            TreeMap<String, Sequence> sequencesByIRICopy = new TreeMap<String, Sequence>();
            this.copySequenceMap(this.sequencesByIRI, sequencesByIRICopy);
            this.fingerprintedSequences.put(fingerprint, sequencesByIRICopy);
            Files.createDirectories(this.statePath.getParent(), new FileAttribute[0]);
            this.objectMapper.writeValue(this.statePath.toFile(), (Object)this.fingerprintedSequences);
        }
        catch (IOException e) {
            throw new PluginException("Unable to save sequence state", (Throwable)e);
        }
    }

    private void readStateFromDisk(PluginConnection pluginConnection) {
        if (Files.exists(this.statePath, new LinkOption[0])) {
            try {
                this.fingerprintedSequences.putAll((Map)this.objectMapper.readValue(this.statePath.toFile(), FingerprintedSequences.class));
            }
            catch (IOException e) {
                throw new PluginException("Unable to restore sequences from disk", (Throwable)e);
            }
        }
        if (this.expectedFingerprint != 0L) {
            TreeMap storedSequencesByIRI = (TreeMap)this.fingerprintedSequences.get(this.expectedFingerprint);
            if (storedSequencesByIRI == null) {
                throw new PluginException("Expected sequences fingerprint not found in stored state");
            }
            this.copySequenceMap(storedSequencesByIRI, this.sequencesByIRI);
            this.sequencesByIRI.forEach((iri, sequence) -> {
                long id = pluginConnection.getEntities().put((Value)SimpleValueFactory.getInstance().createIRI(iri), Entities.Scope.SYSTEM);
                this.sequencesById.put(id, sequence);
            });
        }
    }

    private void copySequenceMap(TreeMap<String, Sequence> sourceMap, TreeMap<String, Sequence> targetMap) {
        sourceMap.forEach((iri, sequence) -> targetMap.put((String)iri, sequence.copy()));
    }
}

