/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.sequences;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;

class Sequence {
    private final AtomicLong value;
    private volatile transient long committedValue;
    private volatile transient boolean prepared;

    Sequence() {
        this(0L);
    }

    Sequence(long sequenceStart) {
        this.value = new AtomicLong(sequenceStart);
        this.committedValue = sequenceStart;
    }

    void prepare() {
        this.prepared = true;
    }

    void commit() {
        this.committedValue = this.value.get();
        this.prepared = false;
    }

    void rollback() {
        this.value.set(this.committedValue);
        this.prepared = false;
    }

    long nextValue() {
        return this.value.incrementAndGet();
    }

    long currentValue() {
        return this.value.get();
    }

    Sequence copy() {
        return new Sequence(this.value.get());
    }

    @JsonProperty
    public long getValue() {
        return this.value.get();
    }

    public void setValue(long value) {
        this.value.set(value);
    }

    public int hashCode() {
        return this.prepared ? Objects.hash(this.value.get()) : Objects.hash(this.committedValue);
    }
}

