/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.dependencies.iterators.dependencies;

import com.ontotext.trree.plugin.dependencies.DependenciesPlugin;
import com.ontotext.trree.plugin.dependencies.Edge;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.StatementIterator;
import gnu.trove.TLongLongHashMap;
import gnu.trove.TLongLongIterator;
import gnu.trove.TLongObjectIterator;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class DependenciesMainIterator
extends StatementIterator {
    private final TLongObjectIterator<TLongLongHashMap> fromEntities;
    private Entities entities;
    TLongLongIterator edgesForEntity;
    private Edge currentEdge;

    public DependenciesMainIterator(DependenciesPlugin dependenciesPlugin, Entities entities, long subject, long predicate, long object, long context) {
        this.fromEntities = dependenciesPlugin.getDependenciesGraph(dependenciesPlugin.longContextToIRI(entities, context)).iterator();
        this.entities = entities;
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public boolean next() {
        if (this.edgesForEntity == null || !this.edgesForEntity.hasNext()) {
            if (this.fromEntities.hasNext()) {
                this.fromEntities.advance();
                this.edgesForEntity = ((TLongLongHashMap)this.fromEntities.value()).iterator();
            } else {
                return false;
            }
        }
        if (this.edgesForEntity.hasNext()) {
            this.edgesForEntity.advance();
            this.subject = this.fromEntities.key();
            BNode node = SimpleValueFactory.getInstance().createBNode();
            this.object = this.entities.put((Value)node, Entities.Scope.REQUEST);
            this.currentEdge = new Edge(this.fromEntities.key(), this.edgesForEntity.key(), this.edgesForEntity.value());
            return true;
        }
        return false;
    }

    public void close() {
    }

    public Edge getCurrentEdge() {
        return this.currentEdge;
    }
}

