/*
 * Decompiled with CFR 0.152.
 */
package io.json.compare;

import io.json.compare.CompareMode;
import io.json.compare.JsonComparator;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DefaultJsonComparator
implements JsonComparator {
    private final Set<CompareMode> compareModes;

    public DefaultJsonComparator(Set<CompareMode> compareModes) {
        this.compareModes = compareModes;
    }

    @Override
    public boolean compareValues(Object expected, Object actual) {
        if (this.compareModes != null && this.compareModes.contains((Object)CompareMode.REGEX_DISABLED)) {
            return expected.toString().equals(actual.toString());
        }
        try {
            Pattern pattern = Pattern.compile(expected.toString(), 40);
            return pattern.matcher(actual.toString()).matches();
        }
        catch (PatternSyntaxException e) {
            return expected.toString().equals(actual.toString());
        }
    }

    @Override
    public boolean compareFields(String expected, String actual) {
        if (this.compareModes != null && this.compareModes.contains((Object)CompareMode.REGEX_DISABLED)) {
            return expected.equals(actual);
        }
        try {
            Pattern pattern = Pattern.compile(expected, 40);
            return pattern.matcher(actual).matches();
        }
        catch (PatternSyntaxException e) {
            return expected.equals(actual);
        }
    }
}

