/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import java.util.List;

public class StatUtils {
    public static double getMean(List<Double> numbers) {
        double sum = 0.0;
        for (double number : numbers) {
            sum += number;
        }
        return sum / (double)numbers.size();
    }

    public static double getVariance(List<Double> numbers) {
        double mean = StatUtils.getMean(numbers);
        double sumSquareDiffs = 0.0;
        for (double number : numbers) {
            double diff = number - mean;
            sumSquareDiffs += diff * diff;
        }
        return sumSquareDiffs / (double)numbers.size();
    }

    public static float sigmoid(float x) {
        float esubx = (float)Math.pow(Math.E, -x);
        return 1.0f / (1.0f + esubx);
    }

    public static double rangeEnvelopeScore(double anchor, double target) {
        if (anchor < 0.0 || target < 0.0) {
            throw new IllegalArgumentException(String.format("Arguments must be positive numbers, not %f, %f", anchor, target));
        }
        if (target < anchor) {
            return 1.0;
        }
        return anchor / target;
    }

    public static double proportionScore(double anchor, double target) {
        if (anchor < 0.0 || target < 0.0) {
            throw new IllegalArgumentException(String.format("Arguments must be positive numbers, not %f, %f", anchor, target));
        }
        return target < anchor ? target / anchor : anchor / target;
    }
}

