/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.utils;

import java.util.Random;

public class SigmoidTable {
    private int maxExponent = 6;
    private int tableSize = 1000;
    private double[] sigmoidTable;

    public SigmoidTable(int maxExponent, int tableSize) {
        this.maxExponent = maxExponent;
        this.tableSize = tableSize;
        this.sigmoidTable = new double[tableSize];
        for (int i = 0; i < tableSize; ++i) {
            double j = (double)(maxExponent * (i + 1)) / (double)tableSize;
            this.sigmoidTable[i] = Math.exp(-1.0 * j);
            this.sigmoidTable[i] = 1.0 / (1.0 + this.sigmoidTable[i]);
        }
    }

    public double sigmoid(double z) {
        double answer = 0.0;
        if (z >= (double)this.maxExponent) {
            return 1.0;
        }
        if (z <= (double)(-this.maxExponent)) {
            return 0.0;
        }
        double index = (double)this.tableSize * Math.abs(z) / (double)this.maxExponent;
        answer = this.sigmoidTable[(int)index];
        if (z < 0.0) {
            answer = 1.0 - answer;
        }
        return answer;
    }

    public static void main(String[] args) {
        Random random = new Random();
        SigmoidTable st = new SigmoidTable(6, 1000);
        for (int q = -9; q < 10; ++q) {
            double test = new Double(q) + random.nextDouble();
            System.out.println(test + "\t" + st.sigmoid(test));
            System.out.print(test + "\t");
            test = Math.pow(Math.E, -1.0 * test);
            test = 1.0 / (1.0 + test);
            System.out.print(test + "\n");
            System.out.println("---------------------------");
        }
    }
}

