/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.tables;

import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class TypeSpec {
    private SupportedType type = SupportedType.DOUBLE;
    private double minDoubleValue = Double.MAX_VALUE;
    private double maxDoubleValue = Double.MIN_VALUE;
    private Vector minBookendVector;
    private Vector maxBookendVector;

    public SupportedType getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Type: " + (Object)((Object)this.type));
        if (this.type == SupportedType.DOUBLE) {
            sb.append(" Min: " + this.minDoubleValue + " Max: " + this.maxDoubleValue);
        }
        return sb.toString();
    }

    public double getMinDoubleValue() {
        if (this.type != SupportedType.DOUBLE) {
            throw new IllegalArgumentException("Must have type DOUBLE, not " + (Object)((Object)this.type));
        }
        return this.minDoubleValue;
    }

    public double getMaxDoubleValue() {
        if (this.type != SupportedType.DOUBLE) {
            throw new IllegalArgumentException("Must have type DOUBLE, not " + (Object)((Object)this.type));
        }
        return this.maxDoubleValue;
    }

    public void setMinDoubleValue(double min) {
        if (this.type != SupportedType.DOUBLE) {
            throw new IllegalArgumentException("Must have type DOUBLE, not " + (Object)((Object)this.type));
        }
        this.minDoubleValue = min;
    }

    public void setMaxDoubleValue(double max) {
        if (this.type != SupportedType.DOUBLE) {
            throw new IllegalArgumentException("Must have type DOUBLE, not " + (Object)((Object)this.type));
        }
        this.maxDoubleValue = max;
    }

    private TypeSpec() {
    }

    public static TypeSpec getEmptyType() {
        return new TypeSpec();
    }

    public void addExample(String example) {
        if (example.trim().isEmpty()) {
            return;
        }
        switch (this.type) {
            case STRING: {
                return;
            }
            case DOUBLE: {
                try {
                    Double newDouble = Double.parseDouble(example);
                    if (newDouble < this.minDoubleValue) {
                        this.minDoubleValue = newDouble;
                    }
                    if (!(newDouble > this.maxDoubleValue)) break;
                    this.maxDoubleValue = newDouble;
                    break;
                }
                catch (NumberFormatException e) {
                    VerbatimLogger.info("Changing to string type because did not parse as following as number: '" + example + "'.\n");
                    VerbatimLogger.info("Spec was: " + this.toString() + "\n");
                    this.type = SupportedType.STRING;
                    return;
                }
            }
        }
    }

    public void addMinMaxVectors(FlagConfig flagConfig, String columnName) {
        if (this.getType() != SupportedType.DOUBLE) {
            throw new IllegalArgumentException("Min and max vectors only supported for type DOUBLE so far.");
        }
        long randomSeed = Bobcat.asLong(columnName);
        Random random = new Random(randomSeed);
        while (true) {
            this.minBookendVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
            this.maxBookendVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
            if (this.minBookendVector.measureOverlap(this.maxBookendVector) < 0.1 || flagConfig.vectortype().equals((Object)VectorType.BINARY) && this.minBookendVector.measureOverlap(this.maxBookendVector) < 0.01) break;
            VerbatimLogger.info("Bookend vectors too similar to each other ... repeating generation.\n");
        }
    }

    public Vector getDoubleValueVector(FlagConfig flagConfig, double value) {
        if (this.getType() != SupportedType.DOUBLE) {
            throw new IllegalArgumentException("Bad call to getDoubleValue.");
        }
        if (value < this.minDoubleValue || value > this.maxDoubleValue) {
            throw new IllegalArgumentException("Value out of bounds: " + value);
        }
        double doubleRange = this.maxDoubleValue - this.minDoubleValue;
        Vector result = VectorUtils.weightedSuperposition(this.minBookendVector, value - this.minDoubleValue, this.maxBookendVector, this.maxDoubleValue - value);
        return result;
    }

    public static enum SupportedType {
        STRING,
        DOUBLE;

    }
}

