/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.tables;

import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorSearcher;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreOrthographical;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.tables.TypeSpec;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class Table {
    private FlagConfig flagConfig;
    private ObjectVector[] columnHeaders;
    private TypeSpec[] columnTypes;
    private VectorStoreRAM rowSummaryVectors;
    private VectorStoreOrthographical orthographicVectorStore;
    private ElementalVectorStore randomElementalVectors;

    public Table(FlagConfig flagConfig, String[] columnNames, List<String[]> dataRows) {
        this.flagConfig = flagConfig;
        this.orthographicVectorStore = new VectorStoreOrthographical(flagConfig);
        this.randomElementalVectors = new ElementalVectorStore(flagConfig);
        this.columnHeaders = new ObjectVector[columnNames.length];
        this.columnTypes = new TypeSpec[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            Vector columnNameVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength, new Random(Bobcat.asLong(columnNames[i])));
            this.columnHeaders[i] = new ObjectVector(columnNames[i], columnNameVector);
        }
        this.prepareTypeSchema(dataRows);
        for (TypeSpec type : this.columnTypes) {
            System.out.println(type);
        }
        this.rowSummaryVectors = new VectorStoreRAM(flagConfig);
        for (String[] dataRow : dataRows) {
            this.addRow(dataRow);
        }
    }

    public VectorStore getRowVectorStore() {
        return this.rowSummaryVectors;
    }

    public Vector getColumnVector(int colIndex) {
        return this.columnHeaders[colIndex].getVector().copy();
    }

    public Vector getColumnAlphaVector(int colIndex) {
        return this.columnTypes[colIndex].getDoubleValueVector(this.flagConfig, this.columnTypes[colIndex].getMinDoubleValue()).copy();
    }

    public Vector getColumnOmegaVector(int colIndex) {
        return this.columnTypes[colIndex].getDoubleValueVector(this.flagConfig, this.columnTypes[colIndex].getMaxDoubleValue()).copy();
    }

    public Vector getDemarcatorVector(int colIndex, double value) {
        return this.columnTypes[colIndex].getDoubleValueVector(this.flagConfig, value).copy();
    }

    public Vector makeCellVector(int colIndex, String value) {
        if (value.trim().isEmpty()) {
            return VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
        }
        Vector valueVector = null;
        boolean useTabular = true;
        if (useTabular) {
            switch (this.columnTypes[colIndex].getType()) {
                case STRING: {
                    valueVector = this.randomElementalVectors.getVector(value);
                    break;
                }
                case DOUBLE: {
                    valueVector = this.columnTypes[colIndex].getDoubleValueVector(this.flagConfig, Double.parseDouble(value));
                }
            }
        } else {
            switch (this.flagConfig.elementalmethod()) {
                case RANDOM: {
                    valueVector = this.randomElementalVectors.getVector(value);
                    break;
                }
                case CONTENTHASH: 
                case ORTHOGRAPHIC: {
                    valueVector = this.orthographicVectorStore.getVector(value);
                }
            }
        }
        if (valueVector == null) {
            return VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
        }
        Vector boundColVal = this.columnHeaders[colIndex].getVector().copy();
        boundColVal.bind(valueVector);
        return boundColVal;
    }

    public LinkedList<SearchResult> searchRowVectors(Vector queryVector) {
        VectorSearcher.VectorSearcherPlain searcher = new VectorSearcher.VectorSearcherPlain(this.getRowVectorStore(), queryVector, this.flagConfig);
        return searcher.getNearestNeighbors(this.flagConfig.numsearchresults());
    }

    public LinkedList<SearchResult> searchProxRowVectors(Vector elementalYOB, Vector elementalTTO, Vector demarcatorAlpha, Vector demarcatorOmega) {
        VectorSearcher.VectorSearcherProximity searcher = new VectorSearcher.VectorSearcherProximity(elementalYOB, elementalTTO, demarcatorAlpha, demarcatorOmega, this.getRowVectorStore(), this.flagConfig);
        return searcher.getNearestNeighbors(this.flagConfig.numsearchresults());
    }

    private void addRow(String[] rowValues) {
        Vector accumulator = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
        for (int i = 0; i < this.columnHeaders.length; ++i) {
            accumulator.superpose(this.makeCellVector(i, rowValues[i]), 1.0, null);
        }
        accumulator.normalize();
        this.rowSummaryVectors.putVector(rowValues[0], accumulator);
    }

    private void prepareTypeSchema(List<String[]> dataRows) {
        for (int i = 0; i < this.columnTypes.length; ++i) {
            this.columnTypes[i] = TypeSpec.getEmptyType();
        }
        for (String[] entries : dataRows) {
            for (int i = 0; i < entries.length; ++i) {
                this.columnTypes[i].addExample(entries[i]);
            }
        }
        for (int i = 0; i < this.columnTypes.length; ++i) {
            if (this.columnTypes[i].getType() != TypeSpec.SupportedType.DOUBLE) continue;
            this.columnTypes[i].addMinMaxVectors(this.flagConfig, this.columnHeaders[i].getObject().toString());
        }
    }
}

