/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.orthography;

import java.util.Random;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.orthography.NumberRepresentation;
import pitt.search.semanticvectors.utils.Bobcat;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class StringEdit {
    private FlagConfig flagConfig;
    private NumberRepresentation numberRepresentation;
    private VectorStore theLetters;
    private Vector lengthVector;
    private static boolean useLengthAsFeature = false;

    public StringEdit(FlagConfig flagConfig, NumberRepresentation theNumbers, VectorStore theLetters) {
        this.flagConfig = flagConfig;
        this.numberRepresentation = theNumbers;
        this.theLetters = theLetters;
        Random random = new Random(Bobcat.asLong("**LENGTH**"));
        this.lengthVector = VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.seedlength(), random);
    }

    public Vector getStringVector(String theTerm) {
        Vector theVector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
        if (theTerm.length() == 0) {
            return theVector;
        }
        VectorStoreRAM positionVectors = this.numberRepresentation.getNumberVectors(0, theTerm.length() + 1);
        for (int position = 1; position <= theTerm.length(); ++position) {
            String letter = "" + theTerm.charAt(position - 1);
            Vector posVector = positionVectors.getVector(position);
            if (posVector == null) {
                throw new NullPointerException("No position vector for position: " + position);
            }
            Vector letterVector = this.theLetters.getVector(letter).copy();
            if (letterVector == null) {
                throw new NullPointerException("No letter vector for letter: '" + letter + "'");
            }
            letterVector.bind(posVector);
            theVector.superpose(letterVector, 1.0, null);
        }
        if (useLengthAsFeature) {
            theVector.superpose(this.lengthVector, theTerm.length() - 1, null);
        }
        theVector.normalize();
        return theVector;
    }
}

