/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.lsh;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.netlib.blas.BLAS;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.collections.BinaryVectorBufferConverter;
import pitt.search.semanticvectors.collections.RealVectorBufferConverter;
import pitt.search.semanticvectors.collections.VectorBufferConverter;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class LocalitySensitiveHash {
    private static final int MAX_NUM_HASHES = 15;
    private int numOfHashes;
    private int numBitsDifference;
    List<Vector> randomVectors;
    BLAS blas;

    private LocalitySensitiveHash() {
    }

    public LocalitySensitiveHash(FlagConfig flagConfig) {
        this.numOfHashes = Math.min(flagConfig.lsh_hashes_num(), 15);
        this.numBitsDifference = Math.min(flagConfig.lsh_max_bits_diff(), this.numOfHashes);
        this.randomVectors = new ArrayList<Vector>(this.numOfHashes);
        this.blas = BLAS.getInstance();
        Random random = new Random();
        for (int i = 0; i < this.numOfHashes; ++i) {
            this.randomVectors.add(VectorFactory.generateRandomVector(flagConfig.vectortype(), flagConfig.dimension(), flagConfig.dimension() / 2, random));
        }
        VectorUtils.orthogonalizeVectors(this.randomVectors);
    }

    public short getHash(Vector vector) {
        short hash = 0;
        for (int i = 0; i < this.numOfHashes; ++i) {
            if (!(VectorUtils.scalarProduct(vector, this.randomVectors.get(i), null, this.blas) > 0.0)) continue;
            hash = (short)(hash | 1 << i);
        }
        return hash;
    }

    public short[] getSimilarHashes(Vector vector) {
        short hash = this.getHash(vector);
        HashSet<Short> candidates = new HashSet<Short>();
        candidates.add(hash);
        this.collectCandidates(hash, candidates, this.numBitsDifference);
        short[] result = new short[candidates.size()];
        int size = 0;
        for (Short candidate : candidates) {
            result[size++] = candidate;
        }
        return result;
    }

    public void writeToFile(File file) throws IOException {
        if (this.randomVectors.size() == 0) {
            return;
        }
        Vector sample = this.randomVectors.get(0);
        VectorType type = sample.getVectorType();
        int dimension = sample.getDimension();
        VectorBufferConverter converter = LocalitySensitiveHash.getVectorBufferConverter(type, dimension);
        try (FileOutputStream fw = new FileOutputStream(file);
             DataOutputStream dw = new DataOutputStream(fw);
             FileChannel fc = fw.getChannel();){
            dw.writeInt(this.numOfHashes);
            dw.writeInt(this.numBitsDifference);
            dw.writeUTF(type.toString());
            dw.writeInt(dimension);
            for (Vector randomVector : this.randomVectors) {
                fc.write(converter.writeToBuffer(randomVector));
            }
        }
    }

    public static LocalitySensitiveHash initFromFile(File file) throws IOException {
        LocalitySensitiveHash lsh = new LocalitySensitiveHash();
        try (FileInputStream fis = new FileInputStream(file);
             DataInputStream dis = new DataInputStream(fis);
             FileChannel fc = fis.getChannel();){
            lsh.numOfHashes = dis.readInt();
            lsh.numBitsDifference = dis.readInt();
            VectorType type = VectorType.valueOf(dis.readUTF());
            int dimension = dis.readInt();
            VectorBufferConverter converter = LocalitySensitiveHash.getVectorBufferConverter(type, dimension);
            lsh.randomVectors = new ArrayList<Vector>();
            ByteBuffer buffer = ByteBuffer.allocateDirect(converter.getBufferSizeInBytes());
            for (int i = 0; i < lsh.numOfHashes; ++i) {
                fc.read(buffer);
                buffer.position(0);
                lsh.randomVectors.add(converter.readFromBuffer(buffer));
            }
        }
        lsh.blas = BLAS.getInstance();
        return lsh;
    }

    private static VectorBufferConverter getVectorBufferConverter(VectorType type, int dimension) {
        VectorBufferConverter converter;
        if (type == VectorType.REAL) {
            converter = new RealVectorBufferConverter(dimension);
        } else if (type == VectorType.BINARY) {
            converter = new BinaryVectorBufferConverter(dimension);
        } else {
            throw new RuntimeException("Unsupported vector type " + (Object)((Object)type));
        }
        return converter;
    }

    private void collectCandidates(short hash, Set<Short> candidates, int numBitsDifference) {
        if (numBitsDifference == 0) {
            return;
        }
        for (int i = 0; i < this.numOfHashes; i = (int)((short)(i + 1))) {
            short modified = (short)(hash ^ 1 << i);
            candidates.add(modified);
            this.collectCandidates(modified, candidates, numBitsDifference - 1);
        }
    }
}

