/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.experiments;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class Retrofit {
    public static void main(String[] args) throws IOException {
        double alpha = 1.0;
        double beta = 1.0;
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        VectorStoreRAM initialVectors = new VectorStoreRAM(flagConfig);
        VectorStoreRAM retroVectors = new VectorStoreRAM(flagConfig);
        initialVectors.initFromFile(flagConfig.initialtermvectors());
        retroVectors.initFromFile(flagConfig.initialtermvectors());
        BufferedReader lexiconReader = new BufferedReader(new FileReader(new File(flagConfig.startlistfile())));
        Hashtable<String, String[]> relations = new Hashtable<String, String[]>();
        String lexiconLine = lexiconReader.readLine();
        while (lexiconLine != null) {
            String[] tokenizedLine = lexiconLine.split(" ");
            relations.put(tokenizedLine[0].toLowerCase(), tokenizedLine);
            lexiconLine = lexiconReader.readLine();
        }
        lexiconReader.close();
        ArrayList keyList = new ArrayList();
        Enumeration keySet = relations.keys();
        while (keySet.hasMoreElements()) {
            keyList.add(keySet.nextElement());
        }
        for (int epoch = 0; epoch < flagConfig.trainingcycles(); ++epoch) {
            System.out.println("Training cycle " + epoch);
            Collections.shuffle(keyList);
            for (String key : keyList) {
                String[] relationships = (String[])relations.get(key);
                if (!retroVectors.containsVector(key) || relationships.length <= 1) continue;
                retroVectors.removeVector(key);
                retroVectors.putVector(key, VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension()));
                int relcnt = 0;
                for (int x = 1; x < relationships.length; ++x) {
                    if (!retroVectors.containsVector(relationships[x].toLowerCase())) continue;
                    retroVectors.getVector(key).superpose(retroVectors.getVector(relationships[x].toLowerCase()), beta, null);
                    retroVectors.getVector(key).superpose(initialVectors.getVector(key), alpha, null);
                    ++relcnt;
                }
                if (relcnt <= 0) continue;
                int y = 0;
                while (y < flagConfig.dimension()) {
                    float[] fArray = ((RealVector)retroVectors.getVector(key)).getCoordinates();
                    int n = y++;
                    fArray[n] = (float)((double)fArray[n] / (2.0 * alpha * beta * (double)relcnt));
                }
            }
        }
        VectorStoreWriter.writeVectorsInLuceneFormat(flagConfig.initialtermvectors().substring(0, flagConfig.initialtermvectors().indexOf(".")) + flagConfig.startlistfile().substring(flagConfig.startlistfile().lastIndexOf("/") + 1, flagConfig.startlistfile().indexOf(".")) + ".bin", flagConfig, retroVectors);
    }
}

