/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.experiments;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;

public class PairwiseCorrelation {
    public static ArrayList<Double> Rank(ArrayList<Double> values) {
        int i;
        ArrayList<Double> sortedValues = new ArrayList<Double>(values);
        Collections.sort(sortedValues);
        ArrayList<Double> ranks = new ArrayList<Double>();
        Hashtable<Double, Integer> valueCounts = new Hashtable<Double, Integer>();
        Hashtable<Double, Integer> rankSums = new Hashtable<Double, Integer>();
        for (i = 0; i < sortedValues.size(); ++i) {
            double next = sortedValues.get(i);
            if (!valueCounts.containsKey(next)) {
                valueCounts.put(next, 1);
            } else {
                valueCounts.put(next, (Integer)valueCounts.get(next) + 1);
            }
            if (!rankSums.containsKey(next)) {
                rankSums.put(next, Integer.valueOf(i) + 1);
                continue;
            }
            rankSums.put(next, (Integer)rankSums.get(next) + i + 1);
        }
        for (i = 0; i < values.size(); ++i) {
            ranks.add(new Double((double)((Integer)rankSums.get(values.get(i))).intValue() / (double)((Integer)valueCounts.get(values.get(i))).intValue()));
        }
        return ranks;
    }

    public static void main(String[] args) throws IOException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        VectorStoreRAM termvectors = new VectorStoreRAM(flagConfig);
        termvectors.initFromFile(flagConfig.queryvectorfile());
        BufferedReader theReader = new BufferedReader(new FileReader(flagConfig.remainingArgs[0]));
        String inline = theReader.readLine();
        inline = theReader.readLine();
        ArrayList<Double> humanScores = new ArrayList<Double>();
        ArrayList<Double> modelScores = new ArrayList<Double>();
        int paircount = 0;
        int foundcount = 0;
        while (inline != null && foundcount < 100000) {
            String[] components = inline.toLowerCase().split(",|\t");
            ++paircount;
            Vector v1 = CompoundVectorBuilder.getQueryVector(termvectors, null, flagConfig, components[0].split(" "));
            Vector v2 = CompoundVectorBuilder.getQueryVector(termvectors, null, flagConfig, components[1].split(" "));
            if (v1.isZeroVector() || v2.isZeroVector()) {
                inline = theReader.readLine();
                continue;
            }
            if (v1 == null || v2 == null) {
                inline = theReader.readLine();
                continue;
            }
            double score = v1.measureOverlap(v2);
            if (!Double.isNaN(score)) {
                ++foundcount;
                humanScores.add(Double.parseDouble(components[2]));
                modelScores.add(score);
            } else {
                if (Double.isNaN(v1.measureOverlap(v1))) {
                    System.err.print("Vector not found for term " + components[0] + "; ");
                }
                if (Double.isNaN(v2.measureOverlap(v2))) {
                    System.err.print("Vector not found for term " + components[1] + "; ");
                }
                System.err.println();
            }
            inline = theReader.readLine();
        }
        ArrayList<Double> humanRanks = PairwiseCorrelation.Rank(humanScores);
        ArrayList<Double> modelRanks = PairwiseCorrelation.Rank(modelScores);
        Double[] human = humanScores.toArray(new Double[1]);
        Double[] model = modelScores.toArray(new Double[1]);
        Double[] humanR = humanRanks.toArray(new Double[1]);
        Double[] modelR = modelRanks.toArray(new Double[1]);
        double meanH = 0.0;
        double meanM = 0.0;
        for (int q = 0; q < human.length; ++q) {
            meanH += human[q].doubleValue();
            meanM += model[q].doubleValue();
        }
        meanH /= (double)human.length;
        meanM /= (double)human.length;
        float[] coH = new float[human.length];
        float[] coM = new float[human.length];
        double coSP = 0.0;
        for (int q = 0; q < human.length; ++q) {
            coH[q] = (float)(human[q] - meanH);
            coM[q] = (float)(model[q] - meanM);
            coSP += Math.pow(humanR[q].floatValue() - modelR[q].floatValue(), 2.0);
        }
        RealVector vectorH = new RealVector(coH);
        RealVector vectorM = new RealVector(coM);
        System.out.println("Found vectors for " + foundcount + " of " + paircount + " pairs");
        System.out.println("Pearson's r \t= " + vectorH.measureOverlap(vectorM));
        System.out.println("Spearman's rho  = " + (1.0 - 6.0 * coSP / ((double)foundcount * (Math.pow(foundcount, 2.0) - 1.0))));
        theReader.close();
    }
}

