/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors.experiments;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorSearcher;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.ZeroVectorException;

public class AnalogyTest {
    List<Double> reciptot = Collections.synchronizedList(new ArrayList());
    AtomicInteger exampletot = new AtomicInteger();
    AtomicInteger acctot = new AtomicInteger();
    List<Double> recipsubset = Collections.synchronizedList(new ArrayList());
    AtomicInteger examplessubset = new AtomicInteger();
    AtomicInteger accsubset = new AtomicInteger();
    HashSet<String> seenEm = new HashSet();

    public void runTests(String[] args) throws IOException, InterruptedException, ExecutionException {
        ObjectVector nextOV;
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        VectorStoreRAM termVectors = new VectorStoreRAM(flagConfig);
        termVectors.initFromFile(flagConfig.queryvectorfile());
        if (!flagConfig.initialtermvectors().isEmpty()) {
            CloseableVectorStore secondSet = VectorStoreReader.openVectorStore(flagConfig.initialtermvectors(), flagConfig);
            Enumeration<ObjectVector> secondSetObjectVectors = secondSet.getAllVectors();
            while (secondSetObjectVectors.hasMoreElements()) {
                nextOV = secondSetObjectVectors.nextElement();
                termVectors.getVector(nextOV.getObject()).superpose(nextOV.getVector(), 1.0, null);
            }
            System.err.println("Added " + flagConfig.initialtermvectors() + " to " + flagConfig.queryvectorfile() + "");
        }
        if (!flagConfig.startlistfile().isEmpty()) {
            Enumeration<ObjectVector> allObjectVectors = termVectors.getAllVectors();
            LuceneUtils lUtils = new LuceneUtils(flagConfig);
            while (allObjectVectors.hasMoreElements()) {
                nextOV = allObjectVectors.nextElement();
                if (lUtils.startlistContains(nextOV.getObject().toString())) continue;
                termVectors.removeVector(nextOV.getObject());
            }
        }
        BufferedReader inputFileReader = new BufferedReader(new FileReader(new File(flagConfig.remainingArgs[0])));
        String header = "";
        int numthreads = flagConfig.numthreads();
        String inLine = inputFileReader.readLine();
        ExecutorService executor = Executors.newFixedThreadPool(numthreads);
        int threadno = 0;
        ArrayList futures = new ArrayList();
        while (inLine != null) {
            if (inLine.isEmpty()) {
                inLine = inputFileReader.readLine();
                continue;
            }
            if (inLine.startsWith("#") || inLine.startsWith(":")) {
                boolean allDone = false;
                while (!allDone) {
                    allDone = true;
                    for (Future future : futures) {
                        allDone = Boolean.logicalAnd(allDone, future.isDone());
                    }
                }
                futures = new ArrayList();
                String toReturn = "";
                double d = 0.0;
                for (Double nextD : this.recipsubset) {
                    d += nextD.doubleValue();
                }
                if (!header.isEmpty()) {
                    toReturn = toReturn + flagConfig.remainingArgs[0] + " " + header + ": mean reciprocal rank " + d / (double)this.examplessubset.get() + "\n";
                    toReturn = toReturn + flagConfig.remainingArgs[0] + " " + header + ": overall accuracy " + (double)this.accsubset.get() / (double)this.examplessubset.get() + "\n";
                    toReturn = toReturn + flagConfig.remainingArgs[0] + " " + header + ": total number of examples " + this.examplessubset + "\n";
                    System.out.println(toReturn);
                }
                header = inLine;
                this.recipsubset.clear();
                this.examplessubset.set(0);
                this.accsubset.set(0);
            } else {
                futures.add(executor.submit(new AnalogyProcessor(flagConfig, termVectors, inLine, ++threadno)));
            }
            inLine = inputFileReader.readLine();
        }
        executor.shutdown();
        while (!executor.isTerminated()) {
        }
        inputFileReader.close();
        double recipsubsetTot = 0.0;
        for (Double nextD : this.recipsubset) {
            recipsubsetTot += nextD.doubleValue();
        }
        System.out.println(flagConfig.remainingArgs[0] + " " + header + ": mean reciprocal rank " + recipsubsetTot / (double)this.examplessubset.get());
        System.out.println(flagConfig.remainingArgs[0] + " " + header + ": overall accuracy " + (double)this.accsubset.get() / (double)this.examplessubset.get());
        System.out.println(flagConfig.remainingArgs[0] + " " + header + ": total number of examples " + this.examplessubset.get());
        header = "total";
        double d = 0.0;
        for (Double nextD : this.reciptot) {
            d += nextD.doubleValue();
        }
        System.out.println(flagConfig.remainingArgs[0] + " " + header + ": mean reciprocal rank " + d / (double)this.exampletot.get());
        System.out.println(flagConfig.remainingArgs[0] + " " + header + ": overall accuracy " + (double)this.acctot.get() / (double)this.exampletot.get());
        System.out.println(flagConfig.remainingArgs[0] + " " + header + ": total number of examples " + this.exampletot.get());
    }

    public static void main(String[] args) throws IOException, InterruptedException, ExecutionException {
        new AnalogyTest().runTests(args);
    }

    private class AnalogyProcessor
    implements Runnable {
        FlagConfig flagConfig;
        VectorStoreRAM termVectors;
        String inLine;
        int threadno;

        public AnalogyProcessor(FlagConfig flagConfig, VectorStoreRAM termVectors, String inLine, int threadno) {
            this.flagConfig = flagConfig;
            this.termVectors = termVectors;
            this.inLine = inLine;
            this.threadno = threadno;
        }

        public void processAnalogy() {
            String[] queryTerms = this.inLine.toLowerCase().split(" ");
            if (queryTerms.length < 4) {
                System.out.println(this.threadno + ": " + this.inLine + ": Skipping line");
                return;
            }
            Vector aTermVector = null;
            Vector bTermVector = null;
            Vector cTermVector = null;
            String missingTerms = "";
            if (!this.termVectors.containsVector(queryTerms[0])) {
                missingTerms = missingTerms + queryTerms[0] + "; ";
            }
            if (!this.termVectors.containsVector(queryTerms[1])) {
                missingTerms = missingTerms + queryTerms[1] + "; ";
            }
            if (!this.termVectors.containsVector(queryTerms[2])) {
                missingTerms = missingTerms + queryTerms[2] + "; ";
            }
            if (!this.termVectors.containsVector(queryTerms[3])) {
                missingTerms = missingTerms + queryTerms[3] + "; ";
            }
            if (!missingTerms.isEmpty()) {
                System.out.println(this.threadno + ": Missing terms " + missingTerms);
                return;
            }
            aTermVector = this.termVectors.getVector(queryTerms[0]);
            bTermVector = this.termVectors.getVector(queryTerms[1]);
            cTermVector = this.termVectors.getVector(queryTerms[2]);
            Vector cueVector = bTermVector.copy();
            cueVector.superpose(aTermVector, -1.0, null);
            cueVector.superpose(cTermVector, 1.0, null);
            cueVector.normalize();
            int rank = 1;
            String object = "";
            try {
                SearchResult sr;
                VectorSearcher.VectorSearcherCosine analogySearcher = new VectorSearcher.VectorSearcherCosine((VectorStore)this.termVectors, (VectorStore)this.termVectors, null, this.flagConfig, cueVector);
                LinkedList<SearchResult> results = analogySearcher.getNearestNeighbors(1003);
                Iterator iterator = results.iterator();
                while (iterator.hasNext() && !(object = (sr = (SearchResult)iterator.next()).getObjectVector().getObject().toString()).equals(queryTerms[3])) {
                    if (object.equals(queryTerms[0]) || object.equals(queryTerms[1]) || object.equals(queryTerms[2])) continue;
                    ++rank;
                }
            }
            catch (ZeroVectorException e) {
                e.printStackTrace();
                System.out.println(this.threadno + ": Error on example " + this.inLine);
            }
            double reciprank = 1.0 / (double)rank;
            if (reciprank < 0.001) {
                reciprank = 0.0;
            }
            AnalogyTest.this.examplessubset.incrementAndGet();
            AnalogyTest.this.exampletot.incrementAndGet();
            AnalogyTest.this.recipsubset.add(reciprank);
            AnalogyTest.this.reciptot.add(reciprank);
            if (reciprank == 1.0) {
                AnalogyTest.this.accsubset.incrementAndGet();
                AnalogyTest.this.acctot.incrementAndGet();
            }
            System.out.println(this.threadno + ": " + this.inLine + " --> " + object + " " + rank + " " + reciprank);
        }

        @Override
        public void run() {
            this.processAnalogy();
        }
    }
}

