/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import com.ontotext.trree.sdk.PluginException;
import java.io.File;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;

public class VectorStoreUtils {
    public static String getStoreFileName(String storeName, FlagConfig flagConfig) {
        switch (flagConfig.indexfileformat()) {
            case LUCENE: {
                if (storeName.endsWith(".bin")) {
                    return storeName;
                }
                return storeName + ".bin";
            }
            case TEXT: {
                if (storeName.endsWith(".txt")) {
                    return storeName;
                }
                return storeName + ".txt";
            }
        }
        throw new IllegalStateException("Unknown -indexfileformat: " + (Object)((Object)flagConfig.indexfileformat()));
    }

    private static File getStoreFile(String fileName, FlagConfig flagConfig) {
        return VectorStoreUtils.getFile(fileName, flagConfig, "");
    }

    private static File getEntityMapFile(String fileName, FlagConfig flagConfig) {
        return VectorStoreUtils.getFile(fileName, flagConfig, ".map");
    }

    private static File getFile(String fileName, FlagConfig flagConfig, String suffix) {
        String extension = "";
        switch (flagConfig.indexfileformat()) {
            case LUCENE: {
                extension = ".bin" + suffix;
                break;
            }
            case TEXT: {
                extension = ".txt" + suffix;
            }
        }
        return new File(fileName + extension);
    }

    static void renameTrainedVectorsFile(String fileName, FlagConfig flagConfig) {
        File initialFile = VectorStoreUtils.getStoreFile(fileName, flagConfig);
        if (!initialFile.delete()) {
            throw new PluginException("Could not delete initial file");
        }
        VectorStoreUtils.getStoreFile(fileName + flagConfig.trainingcycles(), flagConfig).renameTo(initialFile);
    }

    static void renameEntityMapVectorsFile(String fileName, FlagConfig flagConfig) {
        File initialFile = VectorStoreUtils.getEntityMapFile(fileName, flagConfig);
        if (!initialFile.delete()) {
            throw new PluginException("Could not delete initial file");
        }
        VectorStoreUtils.getEntityMapFile(fileName + flagConfig.trainingcycles(), flagConfig).renameTo(initialFile);
    }

    public static void closeVectorStores(CloseableVectorStore ... vectorStores) {
        for (CloseableVectorStore vectorStore : vectorStores) {
            if (vectorStore == null) continue;
            vectorStore.close();
        }
    }

    public static enum VectorStoreFormat {
        LUCENE,
        TEXT;

    }
}

