/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorStoreReaderText
implements CloseableVectorStore {
    private static final Logger logger = Logger.getLogger(VectorStoreReaderText.class.getCanonicalName());
    private VectorType vectorType;
    private int dimension;
    private String vectorFileText;
    private BufferedReader inBuf;

    public VectorStoreReaderText(String vectorFileText, FlagConfig flagConfig) throws IOException {
        this.vectorFileText = vectorFileText;
        this.inBuf = new BufferedReader(new FileReader(vectorFileText));
        try {
            String firstLine = this.inBuf.readLine();
            FlagConfig.mergeWriteableFlagsFromString(firstLine, flagConfig);
            this.dimension = flagConfig.dimension();
            this.vectorType = flagConfig.vectortype();
        }
        catch (IOException e) {
            System.out.println("Cannot read file: " + vectorFileText + "\n" + e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            this.inBuf.close();
        }
        catch (IOException e) {
            System.out.println("Cannot close resources from file: " + this.vectorFileText + "\n" + e.getMessage());
        }
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        BufferedReader vecBuf;
        try {
            vecBuf = new BufferedReader(new FileReader(this.vectorFileText));
            vecBuf.readLine();
        }
        catch (IOException e) {
            vecBuf = new BufferedReader(new StringReader(""));
            e.printStackTrace();
        }
        return new VectorEnumerationText(vecBuf);
    }

    public ObjectVector parseVectorLine(String line) throws IOException {
        int firstSplitPoint = line.indexOf("|");
        String objectName = new String(line.substring(0, firstSplitPoint));
        Vector tmpVector = VectorFactory.createZeroVector(this.vectorType, this.dimension);
        tmpVector.readFromString(line.substring(firstSplitPoint + 1, line.length()));
        return new ObjectVector(objectName, tmpVector);
    }

    @Override
    public Vector getVector(Object desiredObject) {
        try {
            String line;
            this.close();
            this.inBuf = new BufferedReader(new FileReader(this.vectorFileText));
            this.inBuf.readLine();
            while ((line = this.inBuf.readLine()) != null) {
                String[] entries = line.split("\\|");
                if (!entries[0].equals(desiredObject)) continue;
                VerbatimLogger.info("Found vector for '" + desiredObject + "'\n");
                return this.parseVectorLine(line).getVector();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VerbatimLogger.info("Failed to find vector for '" + desiredObject + "'\n");
        return null;
    }

    @Override
    public int getNumVectors() {
        Enumeration<ObjectVector> allVectors = this.getAllVectors();
        int i = 0;
        while (allVectors.hasMoreElements()) {
            allVectors.nextElement();
            ++i;
        }
        return i;
    }

    @Override
    public boolean containsVector(Object object) {
        return this.getVector(object) != null;
    }

    public class VectorEnumerationText
    implements Enumeration<ObjectVector> {
        BufferedReader vecBuf;

        public VectorEnumerationText(BufferedReader vecBuf) {
            this.vecBuf = vecBuf;
        }

        @Override
        public boolean hasMoreElements() {
            try {
                char[] cbuf = new char[1];
                this.vecBuf.mark(10);
                if (this.vecBuf.read(cbuf, 0, 1) != -1) {
                    this.vecBuf.reset();
                    return true;
                }
                this.vecBuf.close();
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }

        @Override
        public ObjectVector nextElement() throws NoSuchElementException {
            try {
                return VectorStoreReaderText.this.parseVectorLine(this.vecBuf.readLine());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new NoSuchElementException("Failed to get next element from vector store.");
            }
        }
    }
}

