/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.FileSystems;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.logging.Logger;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.lsh.DirectByteBufferCleaner;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class VectorStoreReaderLucene
implements CloseableVectorStore {
    private static final Logger logger = Logger.getLogger(VectorStoreReaderLucene.class.getCanonicalName());
    private String vectorFileName;
    private File vectorFile;
    private Directory directory;
    private FlagConfig flagConfig;
    private ThreadLocal<IndexInput> threadLocalIndexInput;

    public IndexInput getIndexInput() {
        return this.threadLocalIndexInput.get();
    }

    public VectorStoreReaderLucene(String vectorFileName, FlagConfig flagConfig) throws IOException {
        this.flagConfig = flagConfig;
        this.vectorFileName = vectorFileName;
        this.vectorFile = new File(vectorFileName);
        try {
            String parentPath = this.vectorFile.getParent();
            if (parentPath == null) {
                parentPath = "";
            }
            this.directory = FSDirectory.open(FileSystems.getDefault().getPath(parentPath, new String[0]));
            this.threadLocalIndexInput = new ThreadLocal<IndexInput>(){

                @Override
                protected IndexInput initialValue() {
                    try {
                        return VectorStoreReaderLucene.this.directory.openInput(VectorStoreReaderLucene.this.vectorFile.getName(), IOContext.READ);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e.getMessage(), e);
                    }
                }
            };
            this.readHeadersFromIndexInput(flagConfig);
        }
        catch (IOException e) {
            logger.warning("Cannot open file: " + this.vectorFileName + "\n" + e.getMessage());
            throw e;
        }
    }

    protected VectorStoreReaderLucene(ThreadLocal<IndexInput> threadLocalIndexInput, FlagConfig flagConfig) throws IOException {
        this.threadLocalIndexInput = threadLocalIndexInput;
        this.flagConfig = flagConfig;
        this.readHeadersFromIndexInput(flagConfig);
    }

    public void readHeadersFromIndexInput(FlagConfig flagConfig) throws IOException {
        String header = this.threadLocalIndexInput.get().readString();
        FlagConfig.mergeWriteableFlagsFromString(header, flagConfig);
    }

    @Override
    public void close() {
        this.closeIndexInput();
        try {
            this.directory.close();
        }
        catch (IOException e) {
            logger.severe("Failed to close() directory resources: have they already been destroyed?");
            e.printStackTrace();
        }
    }

    public void closeIndexInput() {
        try {
            this.getIndexInput().close();
        }
        catch (IOException e) {
            logger.info("Cannot close resources from file: " + this.vectorFile + "\n" + e.getMessage());
        }
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        try {
            this.getIndexInput().seek(0L);
            this.getIndexInput().readString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new VectorEnumeration(this.getIndexInput());
    }

    @Override
    public Vector getVector(Object desiredObject) {
        File map = new File(this.vectorFileName + ".map");
        if (map.exists()) {
            Vector vector = this.findVectorInMap(map, desiredObject);
            if (vector == null) {
                logger.info("Didn't find vector for '" + desiredObject + "'\n");
            }
            return vector;
        }
        try {
            String stringTarget = desiredObject.toString();
            this.getIndexInput().seek(0L);
            this.getIndexInput().readString();
            while (this.getIndexInput().getFilePointer() < this.getIndexInput().length() - 1L) {
                String objectString = this.getIndexInput().readString();
                if (objectString.equals(stringTarget)) {
                    VerbatimLogger.info("Found vector for '" + stringTarget + "'\n");
                    Vector vector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
                    vector.readFromLuceneStream(this.getIndexInput());
                    return vector;
                }
                this.getIndexInput().seek(this.getIndexInput().getFilePointer() + (long)VectorFactory.getLuceneByteSize(this.flagConfig.vectortype(), this.flagConfig.dimension()));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        VerbatimLogger.info("Didn't find vector for '" + desiredObject + "'\n");
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector findVectorInMap(File map, Object desiredObject) {
        try (FileChannel channel = FileChannel.open(map.toPath(), new OpenOption[0]);){
            Vector vector = this.findVectorInMap(channel, desiredObject, 0, (int)channel.size() / 8);
            return vector;
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector findVectorInMap(FileChannel map, Object desiredObject, int start, int end) {
        if (end < start) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(8);
        int testIdx = (start + end) / 2;
        try {
            if (map.position(testIdx * 8).read(buffer) == -1) {
                Vector vector = null;
                return vector;
            }
            buffer.flip();
            this.getIndexInput().seek(buffer.getLong());
            String testObject = this.getIndexInput().readString();
            if (testObject.equals(desiredObject.toString())) {
                VerbatimLogger.info("Found vector for '" + desiredObject + "'\n");
                Vector vector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
                vector.readFromLuceneStream(this.getIndexInput());
                Vector vector2 = vector;
                return vector2;
            }
            if (testObject.compareTo(desiredObject.toString()) > 0) {
                Vector vector = this.findVectorInMap(map, desiredObject, start, testIdx - 1);
                return vector;
            }
            Vector vector = this.findVectorInMap(map, desiredObject, testIdx + 1, end);
            return vector;
        }
        catch (IOException e) {
            logger.severe(e.getMessage());
        }
        finally {
            DirectByteBufferCleaner.closeDirectByteBuffer(buffer);
        }
        return null;
    }

    @Override
    public int getNumVectors() {
        Enumeration<ObjectVector> allVectors = this.getAllVectors();
        int i = 0;
        while (allVectors.hasMoreElements()) {
            allVectors.nextElement();
            ++i;
        }
        return i;
    }

    @Override
    public boolean containsVector(Object object) {
        return this.getVector(object) != null;
    }

    public final File getVectorFile() {
        return this.vectorFile;
    }

    public class VectorEnumeration
    implements Enumeration<ObjectVector> {
        IndexInput indexInput;

        public VectorEnumeration(IndexInput indexInput) {
            this.indexInput = indexInput;
        }

        @Override
        public boolean hasMoreElements() {
            return this.indexInput.getFilePointer() < this.indexInput.length();
        }

        @Override
        public ObjectVector nextElement() {
            String object = null;
            Vector vector = VectorFactory.createZeroVector(VectorStoreReaderLucene.this.flagConfig.vectortype(), VectorStoreReaderLucene.this.flagConfig.dimension());
            try {
                object = this.indexInput.readString();
                vector.readFromLuceneStream(this.indexInput);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return new ObjectVector(object, vector);
        }
    }
}

