/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.VectorStoreReaderLucene;
import pitt.search.semanticvectors.VectorStoreReaderText;
import pitt.search.semanticvectors.VectorStoreUtils;

public class VectorStoreReader {
    public static CloseableVectorStore openVectorStore(String storeName, FlagConfig flagConfig) throws IOException {
        CloseableVectorStore vectorStore = null;
        storeName = VectorStoreUtils.getStoreFileName(storeName, flagConfig);
        switch (flagConfig.indexfileformat()) {
            case LUCENE: {
                vectorStore = new VectorStoreReaderLucene(storeName, flagConfig);
                break;
            }
            case TEXT: {
                vectorStore = new VectorStoreReaderText(storeName, flagConfig);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown -indexfileformat: " + (Object)((Object)flagConfig.indexfileformat()));
            }
        }
        return vectorStore;
    }
}

