/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.utils.Distribution;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.RealVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;

public class VectorStoreRAM
implements VectorStore {
    private static final Logger logger = Logger.getLogger(VectorStoreRAM.class.getCanonicalName());
    private FlagConfig flagConfig;
    private ConcurrentHashMap<Object, ObjectVector> objectVectors = new ConcurrentHashMap();
    private VectorType vectorType;
    private int dimension;
    private Vector zeroVector;

    public VectorStoreRAM(FlagConfig flagConfig) {
        this.flagConfig = flagConfig;
        this.vectorType = flagConfig.vectortype();
        this.dimension = flagConfig.dimension();
        this.zeroVector = VectorFactory.createZeroVector(this.vectorType, this.dimension);
    }

    public static VectorStoreRAM readFromFile(FlagConfig flagConfig, String vectorFile) throws IOException {
        if (vectorFile.isEmpty()) {
            throw new IllegalArgumentException("vectorFile argument cannot be empty.");
        }
        VectorStoreRAM store = new VectorStoreRAM(flagConfig);
        store.initFromFile(vectorFile);
        return store;
    }

    public void initFromFile(String vectorFile) throws IOException {
        CloseableVectorStore vectorReaderDisk = VectorStoreReader.openVectorStore(vectorFile, this.flagConfig);
        Enumeration<ObjectVector> vectorEnumeration = vectorReaderDisk.getAllVectors();
        logger.fine("Reading vectors from store on disk into memory cache  ...");
        while (vectorEnumeration.hasMoreElements()) {
            ObjectVector objectVector = vectorEnumeration.nextElement();
            this.objectVectors.put(objectVector.getObject().toString(), objectVector);
        }
        vectorReaderDisk.close();
        logger.log(Level.FINE, "Cached {0} vectors.", this.objectVectors.size());
    }

    public void putVector(Object key, Vector vector) {
        IncompatibleVectorsException.checkVectorsCompatible(this.zeroVector, vector);
        ObjectVector objectVector = new ObjectVector(key, vector);
        this.objectVectors.put(key, objectVector);
    }

    @Override
    public Enumeration<ObjectVector> getAllVectors() {
        return this.objectVectors.elements();
    }

    @Override
    public int getNumVectors() {
        return this.objectVectors.size();
    }

    @Override
    public Vector getVector(Object desiredObject) {
        ObjectVector objectVector = this.objectVectors.get(desiredObject);
        if (objectVector != null) {
            return objectVector.getVector();
        }
        return null;
    }

    public Vector getVectorOrZero(Object desiredObject) {
        ObjectVector objectVector = this.objectVectors.get(desiredObject);
        if (objectVector != null) {
            return objectVector.getVector();
        }
        this.putVector(desiredObject, VectorFactory.createZeroVector(this.vectorType, this.dimension));
        return this.getVector(desiredObject);
    }

    public Vector removeVector(Object desiredObject) {
        ObjectVector objectVector = this.objectVectors.get(desiredObject);
        if (objectVector != null) {
            return this.objectVectors.remove(desiredObject).getVector();
        }
        return null;
    }

    @Override
    public boolean containsVector(Object object) {
        return this.objectVectors.containsKey(object);
    }

    public static VectorStoreRAM createRedistributedVectorStore(VectorStore source, FlagConfig flagConfig, int sampleSize) {
        if (flagConfig.vectortype() != VectorType.REAL) {
            throw new IllegalArgumentException("Vector store redistribution only works with VectorType.REAL vectors.");
        }
        if (source.getNumVectors() < sampleSize) {
            logger.info(String.format("Source vector store only has %d elements, using all in sample.", source.getNumVectors()));
            sampleSize = source.getNumVectors();
        }
        float[][] sampleCoordinates = new float[sampleSize][flagConfig.dimension()];
        Enumeration<ObjectVector> vectorEnumeration = source.getAllVectors();
        for (int i = 0; i < sampleSize; ++i) {
            sampleCoordinates[i] = ((RealVector)vectorEnumeration.nextElement().getVector()).getCoordinates();
        }
        Distribution[] distributions = new Distribution[flagConfig.dimension()];
        for (int dim = 0; dim < flagConfig.dimension(); ++dim) {
            float[] coords = new float[sampleSize];
            for (int i = 0; i < sampleSize; ++i) {
                coords[i] = sampleCoordinates[i][dim];
            }
            distributions[dim] = new Distribution(coords);
        }
        VectorStoreRAM rescaledStore = new VectorStoreRAM(flagConfig);
        Enumeration<ObjectVector> vecEnum = source.getAllVectors();
        while (vecEnum.hasMoreElements()) {
            ObjectVector objectVector = vecEnum.nextElement();
            RealVector oldVector = (RealVector)objectVector.getVector();
            float[] oldCoords = oldVector.getCoordinates();
            float[] newCoords = new float[flagConfig.dimension()];
            for (int i = 0; i < flagConfig.dimension(); ++i) {
                newCoords[i] = 2.0f * distributions[i].getCumulativePosition(oldCoords[i]) - 1.0f;
            }
            rescaledStore.putVector(objectVector.getObject(), new RealVector(newCoords));
        }
        VerbatimLogger.info("Created new vector store with redistributed coordinates.\n");
        return rescaledStore;
    }
}

