/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;

public class TermVectorsFromLucene {
    private static final Logger logger = Logger.getLogger(TermVectorsFromLucene.class.getCanonicalName());
    private FlagConfig flagConfig;
    private VectorStore termVectors;
    private LuceneUtils luceneUtils;
    private VectorStore elementalDocVectors;

    private TermVectorsFromLucene(FlagConfig flagConfig) throws IOException {
        this.flagConfig = flagConfig;
        this.luceneUtils = new LuceneUtils(flagConfig);
    }

    public VectorStore getElementalDocVectors() {
        return this.elementalDocVectors;
    }

    public LuceneUtils getLuceneUtils() {
        return this.luceneUtils;
    }

    public VectorStore getSemanticTermVectors() {
        return this.termVectors;
    }

    public static TermVectorsFromLucene createTermVectorsFromLucene(FlagConfig flagConfig, VectorStore elementalDocVectors) throws IOException, RuntimeException {
        return TermVectorsFromLucene.createTermVectorsFromLucene(flagConfig, elementalDocVectors, new AtomicBoolean());
    }

    public static TermVectorsFromLucene createTermVectorsFromLucene(FlagConfig flagConfig, VectorStore elementalDocVectors, AtomicBoolean isCreationInterruptedByUser) throws IOException, RuntimeException {
        TermVectorsFromLucene vectorStore = new TermVectorsFromLucene(flagConfig);
        vectorStore.elementalDocVectors = elementalDocVectors;
        vectorStore.createTermVectorsFromLuceneImpl(isCreationInterruptedByUser);
        vectorStore.luceneUtils.closeLuceneDir();
        return vectorStore;
    }

    private void createTermVectorsFromLuceneImpl(AtomicBoolean isCreationInterruptedByUser) throws IOException {
        if (this.elementalDocVectors != null) {
            logger.info("Reusing basic doc vectors; number of documents: " + this.elementalDocVectors.getNumVectors());
            if (this.elementalDocVectors.getNumVectors() != this.luceneUtils.getNumDocs()) {
                throw new RuntimeException("Wrong number of basicDocVectors passed into constructor ...");
            }
            if (this.flagConfig.rescaleintraining()) {
                this.elementalDocVectors = VectorStoreRAM.createRedistributedVectorStore(this.elementalDocVectors, this.flagConfig, 200);
            }
        } else {
            this.elementalDocVectors = new ElementalVectorStore(this.flagConfig);
        }
        this.trainTermVectors(isCreationInterruptedByUser);
    }

    private void trainTermVectors(AtomicBoolean isCreationInterruptedByUser) throws IOException {
        TermsEnum terms;
        this.termVectors = new VectorStoreRAM(this.flagConfig);
        VerbatimLogger.log(Level.INFO, "Creating semantic term vectors ...\n");
        for (String fieldName : this.flagConfig.contentsfields()) {
            Terms termsForField = this.luceneUtils.getTermsForField(fieldName);
            terms = termsForField.iterator();
            int tc = 0;
            while (terms.next() != null) {
                ++tc;
            }
            VerbatimLogger.info("There are " + tc + " terms (and " + this.luceneUtils.getNumDocs() + " docs).\n");
        }
        for (String fieldName : this.flagConfig.contentsfields()) {
            BytesRef bytes;
            VerbatimLogger.info("Training term vectors for field " + fieldName + "\n");
            int tc = 0;
            terms = this.luceneUtils.getTermsForField(fieldName).iterator();
            while ((bytes = terms.next()) != null) {
                if (isCreationInterruptedByUser.get()) {
                    throw new QueryInterruptedException("Transaction was aborted by the user");
                }
                if (tc % 10000 == 0 || tc < 10000 && tc % 1000 == 0) {
                    VerbatimLogger.info("Processed " + tc + " terms ... ");
                }
                ++tc;
                Term term = new Term(fieldName, bytes);
                if (!this.luceneUtils.termFilter(term)) continue;
                Vector termVector = VectorFactory.createZeroVector(this.flagConfig.vectortype(), this.flagConfig.dimension());
                PostingsEnum docsEnum = this.luceneUtils.getDocsForTerm(term);
                while (docsEnum.nextDoc() != Integer.MAX_VALUE) {
                    String docID = this.luceneUtils.getExternalDocId(docsEnum.docID());
                    int freq = docsEnum.freq();
                    termVector.superpose(this.elementalDocVectors.getVector(docID), freq, null);
                }
                termVector.normalize();
                ((VectorStoreRAM)this.termVectors).putVector(term.text(), termVector);
            }
        }
        VerbatimLogger.info("\nCreated " + this.termVectors.getNumVectors() + " term vectors.\n");
    }

    public static TermVectorsFromLucene createTermBasedRRIVectors(FlagConfig flagConfig) throws IOException, RuntimeException {
        TermVectorsFromLucene termVectors = new TermVectorsFromLucene(flagConfig);
        termVectors.luceneUtils = new LuceneUtils(flagConfig);
        termVectors.createTermBasedRRIVectorsImpl();
        termVectors.luceneUtils.closeLuceneDir();
        return termVectors;
    }

    private void createTermBasedRRIVectorsImpl() throws IOException, RuntimeException {
        this.termVectors = new ElementalVectorStore(this.flagConfig);
        if (!this.flagConfig.initialtermvectors().isEmpty() && !this.flagConfig.initialtermvectors().equals("random")) {
            VerbatimLogger.info("Using elemental term vectors from file " + this.flagConfig.initialtermvectors());
            CloseableVectorStore inputReader = VectorStoreReader.openVectorStore(this.flagConfig.initialtermvectors(), this.flagConfig);
            Enumeration<ObjectVector> termEnumeration = inputReader.getAllVectors();
            this.termVectors = new VectorStoreRAM(this.flagConfig);
            int count = 0;
            while (termEnumeration.hasMoreElements()) {
                ObjectVector next = termEnumeration.nextElement();
                ((VectorStoreRAM)this.termVectors).putVector(next.getObject(), next.getVector());
                ++count;
            }
            inputReader.close();
            logger.info("Read in " + count + " vectors");
        } else {
            logger.info("Generating new elemental term vectors");
            this.termVectors = new ElementalVectorStore(this.flagConfig);
            for (String fieldName : this.flagConfig.contentsfields()) {
                BytesRef bytes;
                TermsEnum terms = this.luceneUtils.getTermsForField(fieldName).iterator();
                while ((bytes = terms.next()) != null) {
                    Term term = new Term(fieldName, bytes);
                    if (!this.luceneUtils.termFilter(term)) continue;
                    this.termVectors.getVector(term.text());
                }
            }
        }
    }
}

