/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.time.Duration;
import java.time.Instant;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.SearchResult;
import pitt.search.semanticvectors.VectorSearcher;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreDeterministic;
import pitt.search.semanticvectors.VectorStoreOrthographical;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.utils.PsiUtils;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.ZeroVectorException;
import pitt.search.semanticvectors.viz.PathFinder;

public class Search {
    private static final Logger logger = Logger.getLogger(Search.class.getCanonicalName());
    private static LuceneUtils luceneUtils;
    public static String usageMessage;

    public static List<SearchResult> runSearch(FlagConfig flagConfig) {
        return Search.runSearch(flagConfig, null);
    }

    public static List<SearchResult> runSearch(FlagConfig flagConfig, Map<String, Float> boostedTerms) throws IllegalArgumentException {
        VectorSearcher vecSearcher;
        Instant start;
        Instant startSearch = Instant.now();
        if (flagConfig == null) {
            throw new NullPointerException("flagConfig cannot be null");
        }
        if (flagConfig.remainingArgs == null) {
            throw new IllegalArgumentException("No query terms left after flag parsing!");
        }
        String[] queryArgs = flagConfig.remainingArgs;
        CloseableVectorStore queryVecReader = null;
        CloseableVectorStore boundVecReader = null;
        CloseableVectorStore elementalVecReader = null;
        CloseableVectorStore semanticVecReader = null;
        CloseableVectorStore predicateVecReader = null;
        CloseableVectorStore searchVecReader = null;
        VectorStoreRAM permutationCache = null;
        try {
            if (!flagConfig.permutationcachefile().equals("permutationvectors") && flagConfig.searchtype().equals((Object)SearchType.PERMUTATION)) {
                VerbatimLogger.info("Opening permutation cache from file " + flagConfig.permutationcachefile() + "\n");
                VectorType typeA = flagConfig.vectortype();
                flagConfig.setVectortype(VectorType.PERMUTATION);
                permutationCache = new VectorStoreRAM(flagConfig);
                permutationCache.initFromFile(flagConfig.permutationcachefile());
                flagConfig.setVectortype(typeA);
            }
            if (!(flagConfig.elementalvectorfile().equals("elementalvectors") || flagConfig.semanticvectorfile().equals("semanticvectors") || flagConfig.elementalpredicatevectorfile().equals("predicatevectors"))) {
                VerbatimLogger.info("Opening query vector store from file: " + flagConfig.queryvectorfile() + "\n");
                if (flagConfig.elementalvectorfile().equals("deterministic")) {
                    if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.ORTHOGRAPHIC)) {
                        elementalVecReader = new VectorStoreOrthographical(flagConfig);
                    } else if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH)) {
                        elementalVecReader = new VectorStoreDeterministic(flagConfig);
                    } else {
                        VerbatimLogger.info("Please select either -elementalmethod orthographic OR -elementalmethod contenthash depending upon the deterministic approach you would like used.");
                    }
                } else {
                    elementalVecReader = VectorStoreReader.openVectorStore(flagConfig.elementalvectorfile(), flagConfig);
                }
                VerbatimLogger.info("Opening elemental query vector store from file: " + flagConfig.elementalvectorfile() + "\n");
                VerbatimLogger.info("Opening semantic query vector store from file: " + flagConfig.semanticvectorfile() + "\n");
                VerbatimLogger.info("Opening predicate query vector store from file: " + flagConfig.elementalpredicatevectorfile() + "\n");
                semanticVecReader = VectorStoreReader.openVectorStore(flagConfig.semanticvectorfile(), flagConfig);
                predicateVecReader = VectorStoreReader.openVectorStore(flagConfig.elementalpredicatevectorfile(), flagConfig);
            } else {
                VerbatimLogger.info("Opening query vector store from file: " + flagConfig.queryvectorfile() + "\n");
                if (flagConfig.queryvectorfile().equals("deterministic")) {
                    if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.ORTHOGRAPHIC)) {
                        queryVecReader = new VectorStoreOrthographical(flagConfig);
                    } else if (flagConfig.elementalmethod().equals((Object)ElementalVectorStore.ElementalGenerationMethod.CONTENTHASH)) {
                        queryVecReader = new VectorStoreDeterministic(flagConfig);
                    } else {
                        VerbatimLogger.info("Please select either -elementalmethod orthographic OR -elementalmethod contenthash depending upon the deterministic approach you would like used.");
                    }
                } else {
                    queryVecReader = VectorStoreReader.openVectorStore(flagConfig.queryvectorfile(), flagConfig);
                }
            }
            if (flagConfig.boundvectorfile().length() > 0) {
                VerbatimLogger.info("Opening second query vector store from file: " + flagConfig.boundvectorfile() + "\n");
                boundVecReader = VectorStoreReader.openVectorStore(flagConfig.boundvectorfile(), flagConfig);
            }
            if (flagConfig.queryvectorfile().equals(flagConfig.searchvectorfile()) || flagConfig.searchvectorfile().isEmpty()) {
                searchVecReader = queryVecReader;
            } else {
                VerbatimLogger.info("Opening search vector store from file: " + flagConfig.searchvectorfile() + "\n");
                searchVecReader = VectorStoreReader.openVectorStore(flagConfig.searchvectorfile(), flagConfig);
            }
            if (!flagConfig.luceneindexpath().isEmpty()) {
                try {
                    luceneUtils = new LuceneUtils(flagConfig);
                }
                catch (IOException e) {
                    logger.warning("Couldn't open Lucene index at " + flagConfig.luceneindexpath() + ". Will continue without term weighting.");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!flagConfig.matchcase()) {
            for (int i = 0; i < queryArgs.length; ++i) {
                queryArgs[i] = queryArgs[i].toLowerCase();
            }
        }
        VerbatimLogger.info("Searching term vectors, searchtype " + (Object)((Object)flagConfig.searchtype()) + "\n");
        try {
            switch (flagConfig.searchtype()) {
                case SUM: {
                    if (boostedTerms != null && !boostedTerms.isEmpty()) {
                        start = Instant.now();
                        Vector qv = CompoundVectorBuilder.getQueryVector(queryVecReader, luceneUtils, flagConfig, queryArgs, term -> {
                            Float boostFactor = (Float)boostedTerms.get(term);
                            return Float.valueOf(boostFactor != null ? boostFactor.floatValue() : 1.0f);
                        });
                        logger.fine("Found vector in : " + Duration.between(start, Instant.now()).toMillis());
                        vecSearcher = new VectorSearcher.VectorSearcherCosine((VectorStore)queryVecReader, (VectorStore)searchVecReader, luceneUtils, flagConfig, qv);
                        break;
                    }
                    vecSearcher = new VectorSearcher.VectorSearcherCosine((VectorStore)queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case SUBSPACE: {
                    vecSearcher = new VectorSearcher.VectorSearcherSubspaceSim(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case MAXSIM: {
                    vecSearcher = new VectorSearcher.VectorSearcherMaxSim((VectorStore)queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case MINSIM: {
                    vecSearcher = new VectorSearcher.VectorSearcherMinSim((VectorStore)queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case BOUNDPRODUCT: {
                    if (queryArgs.length == 2) {
                        vecSearcher = new VectorSearcher.VectorSearcherBoundProduct((VectorStore)queryVecReader, boundVecReader, (VectorStore)searchVecReader, luceneUtils, flagConfig, queryArgs[0], queryArgs[1]);
                        break;
                    }
                    vecSearcher = new VectorSearcher.VectorSearcherBoundProduct((VectorStore)elementalVecReader, semanticVecReader, predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                    break;
                }
                case BOUNDPRODUCTSUBSPACE: {
                    if (queryArgs.length == 2) {
                        vecSearcher = new VectorSearcher.VectorSearcherBoundProductSubSpace((VectorStore)queryVecReader, boundVecReader, (VectorStore)searchVecReader, luceneUtils, flagConfig, queryArgs[0], queryArgs[1]);
                        break;
                    }
                    vecSearcher = new VectorSearcher.VectorSearcherBoundProductSubSpace((VectorStore)elementalVecReader, semanticVecReader, predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                    break;
                }
                case INTERSECTION: {
                    vecSearcher = new VectorSearcher.VectorSearcherIntersection(elementalVecReader, semanticVecReader, predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                    break;
                }
                case BOUNDMINIMUM: {
                    if (queryArgs.length == 2) {
                        vecSearcher = new VectorSearcher.VectorSearcherBoundMinimum((VectorStore)queryVecReader, boundVecReader, (VectorStore)searchVecReader, luceneUtils, flagConfig, queryArgs[0], queryArgs[1]);
                        break;
                    }
                    vecSearcher = new VectorSearcher.VectorSearcherBoundMinimum((VectorStore)elementalVecReader, semanticVecReader, predicateVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs[0]);
                    break;
                }
                case PERMUTATION: {
                    vecSearcher = new VectorSearcher.VectorSearcherPerm(queryVecReader, searchVecReader, permutationCache, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case BALANCEDPERMUTATION: {
                    vecSearcher = new VectorSearcher.BalancedVectorSearcherPerm(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case ANALOGY: {
                    vecSearcher = new VectorSearcher.AnalogySearcher(queryVecReader, searchVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case PROXIMITY: {
                    vecSearcher = new VectorSearcher.VectorSearcherProximity(queryVecReader, searchVecReader, boundVecReader, luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case LUCENE: {
                    vecSearcher = new VectorSearcher.VectorSearcherLucene(luceneUtils, flagConfig, queryArgs);
                    break;
                }
                case PRINTQUERY: {
                    Vector queryVector = CompoundVectorBuilder.getQueryVector(queryVecReader, luceneUtils, flagConfig, queryArgs);
                    System.out.println(queryVector.toString());
                    return new LinkedList<SearchResult>();
                }
                case PRINTPSIQUERY: {
                    Vector psiQueryVector = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, queryArgs[0]);
                    if (flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
                        BinaryVector.setDebugPrintLength(flagConfig.dimension());
                    }
                    System.out.println(psiQueryVector.toString());
                    return new LinkedList<SearchResult>();
                }
                default: {
                    throw new IllegalArgumentException("Unknown search type: " + (Object)((Object)flagConfig.searchtype()));
                }
            }
        }
        catch (ZeroVectorException zve) {
            logger.info(zve.getMessage());
            return new LinkedList<SearchResult>();
        }
        start = Instant.now();
        LinkedList<SearchResult> results = ((VectorSearcher)vecSearcher).getNearestNeighbors(flagConfig.numsearchresults());
        logger.fine("Found nearest vector in: " + Duration.between(start, Instant.now()).toMillis());
        VectorStoreUtils.closeVectorStores(queryVecReader, searchVecReader, boundVecReader, elementalVecReader, semanticVecReader, predicateVecReader);
        if (luceneUtils != null) {
            luceneUtils.closeLuceneDir();
        }
        logger.fine("Finished the compete search in : " + Duration.between(startSearch, Instant.now()).toMillis());
        return results;
    }

    public static ObjectVector[] getSearchResultVectors(FlagConfig flagConfig) throws IllegalArgumentException {
        List<SearchResult> results = Search.runSearch(flagConfig);
        CloseableVectorStore searchVecReader = null;
        try {
            searchVecReader = VectorStoreReader.openVectorStore(flagConfig.searchvectorfile(), flagConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ObjectVector[] resultsList = new ObjectVector[results.size()];
        for (int i = 0; i < results.size(); ++i) {
            String term = results.get(i).getObjectVector().getObject().toString();
            Vector tmpVector = searchVecReader.getVector(term);
            resultsList[i] = new ObjectVector(term, tmpVector);
        }
        if (searchVecReader != null) {
            searchVecReader.close();
        }
        return resultsList;
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        List<SearchResult> results;
        FlagConfig flagConfig;
        try {
            flagConfig = FlagConfig.getFlagConfig(args);
            results = Search.runSearch(flagConfig);
        }
        catch (IllegalArgumentException e) {
            System.err.println(usageMessage);
            throw e;
        }
        int ranking = 0;
        if (results.size() > 0) {
            VerbatimLogger.info("Search output follows ...\n");
            for (SearchResult result : results) {
                ++ranking;
                if (flagConfig.treceval() == -1) {
                    System.out.println(result.toSimpleString());
                } else {
                    System.out.println(result.toTrecString(flagConfig.treceval(), ranking));
                }
                if (!flagConfig.boundvectorfile().isEmpty() || !flagConfig.elementalvectorfile().isEmpty()) continue;
                PsiUtils.printNearestPredicate(flagConfig);
            }
            if (!flagConfig.jsonfile().isEmpty()) {
                PathFinder.pathfinderWriterWrapper(flagConfig, results);
            }
        } else {
            VerbatimLogger.info("No search output.\n");
        }
    }

    static {
        usageMessage = "\nSearch class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.Search [-queryvectorfile query_vector_file]\n                                               [-searchvectorfile search_vector_file]\n                                               [-luceneindexpath path_to_lucene_index]\n                                               [-searchtype TYPE]\n                                               <QUERYTERMS>\nIf no query or search file is given, default will be\n    termvectors.bin in local directory.\n-luceneindexpath argument is needed if to get term weights from\n    term frequency, doc frequency, etc. in lucene index.\n-searchtype can be one of SUM, SUBSPACE, MAXSIM, MINSIM\n    BALANCEDPERMUTATION, PERMUTATION, PRINTQUERY\n<QUERYTERMS> should be a list of words, separated by spaces.\n    If the term NOT is used, terms after that will be negated.";
    }

    public static enum SearchType {
        SUM,
        SUBSPACE,
        MAXSIM,
        MINSIM,
        PERMUTATION,
        BALANCEDPERMUTATION,
        BOUNDPRODUCT,
        LUCENE,
        BOUNDMINIMUM,
        BOUNDPRODUCTSUBSPACE,
        INTERSECTION,
        ANALOGY,
        PRINTQUERY,
        PRINTPSIQUERY,
        PROXIMITY;

    }
}

