/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.BinaryVector;
import pitt.search.semanticvectors.vectors.BinaryVectorUtils;
import pitt.search.semanticvectors.vectors.IncompatibleVectorsException;
import pitt.search.semanticvectors.vectors.PermutationUtils;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorFactory;
import pitt.search.semanticvectors.vectors.VectorType;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class CompoundVectorBuilder {
    public static final String NEGATION_TOKEN = "~NOT";
    private VectorStore vecReader;
    private LuceneUtils luceneUtils;
    private static final Logger logger = Logger.getLogger(CompoundVectorBuilder.class.getCanonicalName());

    public CompoundVectorBuilder(VectorStore vecReader, LuceneUtils lUtils) {
        this.vecReader = vecReader;
        this.luceneUtils = lUtils;
    }

    public CompoundVectorBuilder(VectorStore vecReader) {
        this.vecReader = vecReader;
        this.luceneUtils = null;
    }

    public static Vector getPermutedQueryVector(VectorStore vecReader, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) throws IllegalArgumentException {
        int queryTermPosition = -1;
        for (int j = 0; j < queryTerms.length; ++j) {
            if (!queryTerms[j].equals("?")) continue;
            if (queryTermPosition == -1) {
                queryTermPosition = j;
                continue;
            }
            logger.severe("Illegal query argument: arguments to getPermutedQueryVector must have only one '?' string to denote target term position.");
            throw new IllegalArgumentException();
        }
        if (queryTermPosition == -1) {
            logger.severe("Illegal query argument: arguments to getPermutedQueryVector must have exactly one '?' string to denote target term position.");
            throw new IllegalArgumentException();
        }
        Vector queryVec = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        Vector tmpVec = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        float weight = 1.0f;
        for (int j = 0; j < queryTerms.length; ++j) {
            if (j == queryTermPosition) continue;
            tmpVec = vecReader.getVector(queryTerms[j]);
            int shift = j - queryTermPosition;
            if (luceneUtils != null) {
                weight = luceneUtils.getGlobalTermWeightFromString(queryTerms[j]);
                logger.log(Level.FINE, "Term {0} weight {1}", new Object[]{queryTerms[j], Float.valueOf(weight)});
            } else {
                weight = 1.0f;
            }
            if (tmpVec != null) {
                queryVec.superpose(tmpVec, weight, PermutationUtils.getShiftPermutation(flagConfig.vectortype(), flagConfig.dimension(), shift));
                continue;
            }
            VerbatimLogger.warning("No vector for '" + queryTerms[j] + "'\n");
        }
        queryVec.normalize();
        return queryVec;
    }

    private static Vector getVector(FlagConfig flagConfig, VectorStore elementalVectors, VectorStore semanticVectors, VectorStore predicateVectors, String term) {
        try {
            if (term.contains(NEGATION_TOKEN)) {
                ArrayList<Vector> disjunctSpace = new ArrayList<Vector>();
                String[] terms = term.split(NEGATION_TOKEN);
                disjunctSpace.add(CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, terms[1]));
                disjunctSpace.add(CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, terms[0]));
                VectorUtils.orthogonalizeVectors(disjunctSpace);
                return disjunctSpace.get(disjunctSpace.size() - 1);
            }
            if (term.startsWith("E(") && term.endsWith(")")) {
                return elementalVectors.getVector(term.substring(2, term.length() - 1)).copy();
            }
            if (term.startsWith("S(") && term.endsWith(")")) {
                return semanticVectors.getVector(term.substring(2, term.length() - 1)).copy();
            }
            if (term.startsWith("P(") && term.endsWith(")")) {
                return predicateVectors.getVector(term.substring(2, term.length() - 1)).copy();
            }
            return VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        }
        catch (NullPointerException npe) {
            return VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        }
    }

    public static Vector getBoundProductQueryVectorFromString(FlagConfig flagConfig, VectorStore elementalVectors, VectorStore semanticVectors, VectorStore predicateVectors, LuceneUtils lUtils, String queryString) {
        if (queryString.contains("|")) {
            return CompoundVectorBuilder.getBalancedBoundProductQueryVectorFromString(flagConfig, elementalVectors, semanticVectors, predicateVectors, lUtils, queryString);
        }
        StringTokenizer bundlingTokenizer = new StringTokenizer(queryString, "+");
        Vector bundled_queryvector = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        while (bundlingTokenizer.hasMoreTokens()) {
            StringTokenizer bindingTokenizer = new StringTokenizer(bundlingTokenizer.nextToken(), "*");
            String nextToken = bindingTokenizer.nextToken();
            Vector boundQueryvector = null;
            boundQueryvector = CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, nextToken).copy();
            float weight = 1.0f;
            if (lUtils != null) {
                weight = lUtils.getGlobalTermWeightFromString(nextToken.substring(2, nextToken.length() - 1));
                logger.log(Level.FINE, "Term {0} weight {1}", new Object[]{nextToken.substring(2, nextToken.length() - 1), Float.valueOf(weight)});
            }
            while (bindingTokenizer.hasMoreTokens()) {
                nextToken = bindingTokenizer.nextToken();
                if (lUtils != null) {
                    logger.log(Level.FINE, "Term {0} weight {1}", new Object[]{nextToken.substring(2, nextToken.length() - 1), Float.valueOf(weight += lUtils.getGlobalTermWeightFromString(nextToken.substring(2, nextToken.length() - 1)))});
                }
                Vector bound_queryvector2 = null;
                bound_queryvector2 = CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, nextToken).copy();
                if (flagConfig.bindnotreleasehack()) {
                    bound_queryvector2.bind(boundQueryvector);
                } else {
                    bound_queryvector2.release(boundQueryvector);
                }
                boundQueryvector = bound_queryvector2;
            }
            bundled_queryvector.superpose(boundQueryvector, weight, null);
        }
        bundled_queryvector.normalize();
        return bundled_queryvector;
    }

    public static Vector getBalancedBoundProductQueryVectorFromString(FlagConfig flagConfig, VectorStore elementalVectors, VectorStore semanticVectors, VectorStore predicateVectors, LuceneUtils lUtils2, String queryString) {
        String[] strings = queryString.split("\\|");
        Vector vector1 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVectors, semanticVectors, predicateVectors, lUtils2, strings[0]);
        Vector vector2 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVectors, semanticVectors, predicateVectors, lUtils2, strings[1]);
        vector1.superpose(vector2, 1.0, null);
        vector1.normalize();
        return vector1;
    }

    public static Vector getBoundProductQueryVectorFromString(FlagConfig flagConfig, VectorStore vecReader, String queryString) {
        StringTokenizer bundlingTokenizer = new StringTokenizer(queryString, "+");
        Vector bundledQueryvector = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        while (bundlingTokenizer.hasMoreTokens()) {
            StringTokenizer bindingTokenizer = new StringTokenizer(bundlingTokenizer.nextToken(), "*");
            Vector boundQueryvector = vecReader.getVector(bindingTokenizer.nextToken()).copy();
            while (bindingTokenizer.hasMoreTokens()) {
                if (flagConfig.bindnotreleasehack()) {
                    boundQueryvector.bind(vecReader.getVector(bindingTokenizer.nextToken()));
                    continue;
                }
                boundQueryvector.release(vecReader.getVector(bindingTokenizer.nextToken()));
            }
            bundledQueryvector.superpose(boundQueryvector, 1.0, null);
        }
        bundledQueryvector.normalize();
        return bundledQueryvector;
    }

    public static Vector getBoundProductQueryIntersectionFromString(FlagConfig flagConfig, VectorStore elementalVectors, VectorStore semanticVectors, VectorStore predicateVectors, LuceneUtils lUtils, String queryString) {
        if (!flagConfig.vectortype().equals((Object)VectorType.BINARY)) {
            throw new IncompatibleVectorsException("Intersection construction is currently implemented for binary vectors only");
        }
        StringTokenizer bundlingTokenizer = new StringTokenizer(queryString, "+");
        Vector bundled_queryvector = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        while (bundlingTokenizer.hasMoreTokens()) {
            StringTokenizer bindingTokenizer = new StringTokenizer(bundlingTokenizer.nextToken(), "*");
            String nextToken = bindingTokenizer.nextToken();
            Vector boundQueryvector = null;
            boundQueryvector = CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, nextToken).copy();
            float weight = 1.0f;
            if (lUtils != null) {
                weight = lUtils.getGlobalTermWeightFromString(nextToken.substring(2, nextToken.length() - 1));
                logger.log(Level.FINE, "Term {0} weight {1}", new Object[]{nextToken.substring(2, nextToken.length() - 1), Float.valueOf(weight)});
            }
            while (bindingTokenizer.hasMoreTokens()) {
                nextToken = bindingTokenizer.nextToken();
                if (lUtils != null) {
                    logger.log(Level.FINE, "Term {0} weight {1}", new Object[]{nextToken.substring(2, nextToken.length() - 1), Float.valueOf(weight += lUtils.getGlobalTermWeightFromString(nextToken.substring(2, nextToken.length() - 1)))});
                }
                Vector bound_queryvector2 = null;
                bound_queryvector2 = CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, nextToken).copy();
                if (flagConfig.bindnotreleasehack()) {
                    bound_queryvector2.bind(boundQueryvector);
                } else {
                    bound_queryvector2.release(boundQueryvector);
                }
                boundQueryvector = bound_queryvector2;
            }
            if (bundled_queryvector.isZeroVector()) {
                bundled_queryvector = boundQueryvector.copy();
                continue;
            }
            bundled_queryvector = BinaryVectorUtils.intersection((BinaryVector)bundled_queryvector, (BinaryVector)boundQueryvector);
        }
        return bundled_queryvector;
    }

    public static ArrayList<Vector> getBoundProductQuerySubSpaceFromString(FlagConfig flagConfig, VectorStore vecReader, Vector conceptVector, String queryString) {
        ArrayList<Vector> disjunctSpace = new ArrayList<Vector>();
        StringTokenizer subspaceTokenizer = new StringTokenizer(queryString, "+");
        while (subspaceTokenizer.hasMoreTokens()) {
            StringTokenizer bindingTokenizer = new StringTokenizer(subspaceTokenizer.nextToken(), "*");
            Vector boundQueryvector = vecReader.getVector(bindingTokenizer.nextToken()).copy();
            while (bindingTokenizer.hasMoreTokens()) {
                if (flagConfig.bindnotreleasehack()) {
                    boundQueryvector.bind(vecReader.getVector(bindingTokenizer.nextToken()));
                    continue;
                }
                boundQueryvector.release(vecReader.getVector(bindingTokenizer.nextToken()));
            }
            Vector copyConceptVector = conceptVector.copy();
            if (flagConfig.bindnotreleasehack()) {
                copyConceptVector.bind(boundQueryvector);
            } else {
                copyConceptVector.release(boundQueryvector);
            }
            disjunctSpace.add(copyConceptVector);
        }
        if (flagConfig.searchtype() != Search.SearchType.BOUNDMINIMUM) {
            VectorUtils.orthogonalizeVectors(disjunctSpace);
        }
        return disjunctSpace;
    }

    public static ArrayList<Vector> getBoundProductQuerySubspaceFromString(FlagConfig flagConfig, VectorStore elementalVectors, VectorStore semanticVectors, VectorStore predicateVectors, String queryString) {
        ArrayList<Vector> disjunctSpace = new ArrayList<Vector>();
        StringTokenizer bundlingTokenizer = new StringTokenizer(queryString, "+");
        while (bundlingTokenizer.hasMoreTokens()) {
            StringTokenizer bindingTokenizer = new StringTokenizer(bundlingTokenizer.nextToken(), "*");
            String nextToken = bindingTokenizer.nextToken();
            Vector boundQeryvector = null;
            boundQeryvector = CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, nextToken).copy();
            while (bindingTokenizer.hasMoreTokens()) {
                nextToken = bindingTokenizer.nextToken();
                Vector boundQueryvector2 = null;
                boundQueryvector2 = CompoundVectorBuilder.getVector(flagConfig, elementalVectors, semanticVectors, predicateVectors, nextToken).copy();
                if (flagConfig.bindnotreleasehack()) {
                    boundQueryvector2.bind(boundQeryvector);
                } else {
                    boundQueryvector2.release(boundQeryvector);
                }
                boundQeryvector = boundQueryvector2;
            }
            disjunctSpace.add(boundQeryvector);
        }
        if (flagConfig.searchtype() != Search.SearchType.BOUNDMINIMUM) {
            VectorUtils.orthogonalizeVectors(disjunctSpace);
        }
        return disjunctSpace;
    }

    public static Vector getQueryVectorFromString(VectorStore vecReader, LuceneUtils lUtils, FlagConfig flagConfig, String queryString) {
        String[] queryTerms = queryString.split("\\s");
        return CompoundVectorBuilder.getQueryVector(vecReader, lUtils, flagConfig, queryTerms);
    }

    public static Vector getQueryVector(VectorStore vecReader, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms) {
        return CompoundVectorBuilder.getQueryVector(vecReader, luceneUtils, flagConfig, queryTerms, null);
    }

    public static Vector getQueryVector(VectorStore vecReader, LuceneUtils luceneUtils, FlagConfig flagConfig, String[] queryTerms, Function<String, Float> weightFunction) {
        CompoundVectorBuilder builder = new CompoundVectorBuilder(vecReader, luceneUtils);
        Vector returnVector = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        if (!flagConfig.suppressnegatedqueries()) {
            for (int i = 0; i < queryTerms.length; ++i) {
                if (!queryTerms[i].equalsIgnoreCase(NEGATION_TOKEN)) continue;
                return builder.getNegatedQueryVector(flagConfig, queryTerms, i);
            }
        }
        returnVector = flagConfig.vectorlookupsyntax() == VectorLookupSyntax.REGEX ? builder.getAdditiveQueryVectorRegex(flagConfig, queryTerms, weightFunction) : builder.getAdditiveQueryVector(flagConfig, queryTerms, weightFunction);
        return returnVector;
    }

    protected Vector getAdditiveQueryVector(FlagConfig flagConfig, String[] queryTerms) {
        return this.getAdditiveQueryVector(flagConfig, queryTerms, null);
    }

    protected Vector getAdditiveQueryVector(FlagConfig flagConfig, String[] queryTerms, Function<String, Float> weightFunction) {
        Vector queryVec = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        float weight = 1.0f;
        for (int j = 0; j < queryTerms.length; ++j) {
            Vector tmpVec = this.vecReader.getVector(queryTerms[j]);
            if (tmpVec != null) {
                if (this.luceneUtils != null) {
                    try {
                        weight = this.luceneUtils.getGlobalTermWeightFromString(queryTerms[j]);
                    }
                    catch (Exception e) {
                        VerbatimLogger.warning("No global weight could be evaluated for '" + queryTerms[j] + "'\n");
                        weight = 1.0f;
                    }
                } else {
                    weight = 1.0f;
                }
                if (weightFunction != null) {
                    weight *= weightFunction.apply(queryTerms[j]).floatValue();
                }
                queryVec.superpose(tmpVec, weight, null);
                continue;
            }
            VerbatimLogger.warning("No vector for '" + queryTerms[j] + "'\n");
        }
        queryVec.normalize();
        return queryVec;
    }

    protected Vector getAdditiveQueryVectorRegex(FlagConfig flagConfig, String[] queryTerms) {
        return this.getAdditiveQueryVectorRegex(flagConfig, queryTerms, null);
    }

    protected Vector getAdditiveQueryVectorRegex(FlagConfig flagConfig, String[] queryTerms, Function<String, Float> weightFunction) {
        Vector queryVec = VectorFactory.createZeroVector(flagConfig.vectortype(), flagConfig.dimension());
        float weight = 1.0f;
        for (int j = 0; j < queryTerms.length; ++j) {
            Pattern pattern = Pattern.compile(queryTerms[j]);
            logger.log(Level.FINER, "Query term pattern: {0}", pattern.pattern());
            Enumeration<ObjectVector> vecEnum = this.vecReader.getAllVectors();
            while (vecEnum.hasMoreElements()) {
                ObjectVector testElement = vecEnum.nextElement();
                Matcher matcher = pattern.matcher(testElement.getObject().toString());
                if (!matcher.find()) continue;
                Vector tmpVec = testElement.getVector();
                weight = this.luceneUtils != null ? this.luceneUtils.getGlobalTermWeightFromString(testElement.getObject().toString()) : 1.0f;
                if (weightFunction != null) {
                    weight *= weightFunction.apply(testElement.getObject().toString()).floatValue();
                }
                queryVec.superpose(tmpVec, weight, null);
            }
        }
        queryVec.normalize();
        return queryVec;
    }

    protected Vector getNegatedQueryVector(FlagConfig flagConfig, String[] queryTerms, int split) {
        int numNegativeTerms = queryTerms.length - split - 1;
        int numPositiveTerms = split;
        logger.log(Level.FINER, "Number of negative terms: {0}", numNegativeTerms);
        logger.log(Level.FINER, "Number of positive terms: {0}", numPositiveTerms);
        ArrayList<Vector> vectorList = new ArrayList<Vector>();
        for (int i = 1; i <= numNegativeTerms; ++i) {
            Vector tmpVector = this.vecReader.getVector(queryTerms[split + i]);
            if (tmpVector == null) continue;
            vectorList.add(tmpVector);
        }
        String[] positiveTerms = new String[numPositiveTerms];
        for (int i = 0; i < numPositiveTerms; ++i) {
            positiveTerms[i] = queryTerms[i];
        }
        vectorList.add(this.getAdditiveQueryVector(flagConfig, positiveTerms));
        VectorUtils.orthogonalizeVectors(vectorList);
        return vectorList.get(vectorList.size() - 1);
    }

    public static enum VectorLookupSyntax {
        EXACTMATCH,
        REGEX;

    }
}

