/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import pitt.search.semanticvectors.CloseableVectorStore;
import pitt.search.semanticvectors.CompoundVectorBuilder;
import pitt.search.semanticvectors.ElementalVectorStore;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.Search;
import pitt.search.semanticvectors.VectorStoreOrthographical;
import pitt.search.semanticvectors.VectorStoreReader;
import pitt.search.semanticvectors.VectorStoreUtils;
import pitt.search.semanticvectors.utils.VerbatimLogger;
import pitt.search.semanticvectors.vectors.Vector;
import pitt.search.semanticvectors.vectors.VectorUtils;

public class CompareTerms {
    private static final Logger logger = Logger.getLogger(CompareTerms.class.getCanonicalName());
    public static final String usageMessage = "CompareTerms class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.CompareTerms\n                                        \"<QUERYTERMS1>\" \"<QUERYTERMS2>\"\n<QUERYTERMS1,2> should be lists of words, separated by spaces.\nThe quotes are mandatory unless you are comparing two single words.\nIf the term NOT is used in one of the lists, subsequent terms in \nthat list will be negated (as in Search class).\nUse \"-elementalmethod orthographic\" to compare strings based on orthography.\n";

    public static void usage() {
        System.out.println(usageMessage);
    }

    public static void main(String[] args) throws IllegalArgumentException, IOException {
        FlagConfig flagConfig = FlagConfig.getFlagConfig(args);
        if (flagConfig.remainingArgs.length != 2) {
            System.out.println("After parsing command line flags, there must be exactly two arguments.");
            CompareTerms.usage();
        }
        VerbatimLogger.info(String.format("Outputting similarity of '%s' with '%s':\n", flagConfig.remainingArgs[0], flagConfig.remainingArgs[1]));
        System.out.println(CompareTerms.runCompareTerms(flagConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double runCompareTerms(FlagConfig flagConfig) throws IOException {
        Vector vec2;
        Vector vec1;
        CloseableVectorStore predicateVecReader;
        CloseableVectorStore semanticVecReader;
        CloseableVectorStore elementalVecReader;
        CloseableVectorStore vecReader;
        LuceneUtils luceneUtils;
        block18: {
            String[] args;
            block20: {
                block19: {
                    double d;
                    args = flagConfig.remainingArgs;
                    luceneUtils = null;
                    if (args.length != 2) {
                        logger.warning("After parsing command line options there must be exactly two queryterm expressions to compare.");
                        CompareTerms.usage();
                        throw new IllegalArgumentException();
                    }
                    vecReader = null;
                    elementalVecReader = null;
                    semanticVecReader = null;
                    predicateVecReader = null;
                    vec1 = null;
                    vec2 = null;
                    try {
                        if (flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCT) || flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDMINIMUM) || flagConfig.searchtype().equals((Object)Search.SearchType.INTERSECTION) || flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCTSUBSPACE)) {
                            elementalVecReader = VectorStoreReader.openVectorStore(flagConfig.elementalvectorfile(), flagConfig);
                            semanticVecReader = VectorStoreReader.openVectorStore(flagConfig.semanticvectorfile(), flagConfig);
                            predicateVecReader = VectorStoreReader.openVectorStore(flagConfig.elementalpredicatevectorfile(), flagConfig);
                        } else if (flagConfig.elementalmethod() == ElementalVectorStore.ElementalGenerationMethod.ORTHOGRAPHIC) {
                            vecReader = new VectorStoreOrthographical(flagConfig);
                        } else {
                            vecReader = VectorStoreReader.openVectorStore(flagConfig.queryvectorfile(), flagConfig);
                            VerbatimLogger.info("Opened query vector store from file: " + flagConfig.queryvectorfile() + "\n");
                            if (!flagConfig.luceneindexpath().isEmpty()) {
                                try {
                                    luceneUtils = new LuceneUtils(flagConfig);
                                }
                                catch (IOException e) {
                                    VerbatimLogger.info("Couldn't open Lucene index at " + flagConfig.luceneindexpath());
                                }
                            }
                            if (luceneUtils == null) {
                                VerbatimLogger.info("No Lucene index for query term weighting, so all query terms will have same weight.\n");
                            }
                        }
                        if (flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCT)) {
                            vec1 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, args[0]);
                            vec2 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, args[1]);
                            break block18;
                        }
                        if (!flagConfig.searchtype().equals((Object)Search.SearchType.BOUNDPRODUCTSUBSPACE)) break block19;
                        ArrayList<Vector> vecs1 = CompoundVectorBuilder.getBoundProductQuerySubspaceFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, args[0]);
                        vec2 = CompoundVectorBuilder.getBoundProductQueryVectorFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, args[1]);
                        d = VectorUtils.compareWithProjection(vec2, vecs1);
                    }
                    catch (Throwable throwable) {
                        VectorStoreUtils.closeVectorStores(elementalVecReader, semanticVecReader, predicateVecReader, vecReader);
                        if (luceneUtils != null) {
                            luceneUtils.closeLuceneDir();
                        }
                        throw throwable;
                    }
                    VectorStoreUtils.closeVectorStores(elementalVecReader, semanticVecReader, predicateVecReader, vecReader);
                    if (luceneUtils != null) {
                        luceneUtils.closeLuceneDir();
                    }
                    return d;
                }
                if (!flagConfig.searchtype().equals((Object)Search.SearchType.INTERSECTION)) break block20;
                vec1 = CompoundVectorBuilder.getBoundProductQueryIntersectionFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, args[0]);
                vec2 = CompoundVectorBuilder.getBoundProductQueryIntersectionFromString(flagConfig, elementalVecReader, semanticVecReader, predicateVecReader, luceneUtils, args[1]);
                double d = vec1.measureOverlap(vec2);
                VectorStoreUtils.closeVectorStores(elementalVecReader, semanticVecReader, predicateVecReader, vecReader);
                if (luceneUtils != null) {
                    luceneUtils.closeLuceneDir();
                }
                return d;
            }
            vec1 = CompoundVectorBuilder.getQueryVectorFromString(vecReader, luceneUtils, flagConfig, args[0]);
            vec2 = CompoundVectorBuilder.getQueryVectorFromString(vecReader, luceneUtils, flagConfig, args[1]);
        }
        VectorStoreUtils.closeVectorStores(elementalVecReader, semanticVecReader, predicateVecReader, vecReader);
        if (luceneUtils != null) {
            luceneUtils.closeLuceneDir();
        }
        return vec1.measureOverlap(vec2);
    }
}

