/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.logging.Logger;
import pitt.search.semanticvectors.DocVectors;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.IncrementalDocVectors;
import pitt.search.semanticvectors.LuceneUtils;
import pitt.search.semanticvectors.ObjectVector;
import pitt.search.semanticvectors.TermTermVectorsFromLucene;
import pitt.search.semanticvectors.VectorStore;
import pitt.search.semanticvectors.VectorStoreRAM;
import pitt.search.semanticvectors.VectorStoreWriter;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public class BuildPositionalIndex {
    public static final Logger logger = Logger.getLogger(BuildPositionalIndex.class.getCanonicalName());
    static VectorStore newElementalTermVectors = null;
    public static String usageMessage = "BuildPositionalIndex class in package pitt.search.semanticvectors\nUsage: java pitt.search.semanticvectors.BuildPositionalIndex -luceneindexpath PATH_TO_LUCENE_INDEX\nBuildPositionalIndex creates file termtermvectors.bin in local directory.\nOther parameters that can be changed include\n    windowlength (size of sliding context window),\n    dimension (number of dimensions), vectortype (real, complex, binary)\n    seedlength (number of non-zero entries in basic vectors),\n    minimum term frequency.\n\nTo change these use the command line arguments \n  -vectortype [real, complex, or binary]\n  -dimension [number of dimensions]\n  -seedlength [seed length]\n  -minfrequency [minimum term frequency]\n  -initialtermvectors [name of preexisting vectorstore for term vectors]\n  -windowradius [window size]\n  -positionalmethod [positional indexing method: basic (default), directional (HAL), permutation (Sahlgren 2008)";

    public static void main(String[] args) throws IllegalArgumentException {
        FlagConfig flagConfig;
        try {
            flagConfig = FlagConfig.getFlagConfig(args);
            args = flagConfig.remainingArgs;
        }
        catch (IllegalArgumentException e) {
            System.out.println(usageMessage);
            throw e;
        }
        if (flagConfig.luceneindexpath().isEmpty()) {
            throw new IllegalArgumentException("-luceneindexpath must be set.");
        }
        String luceneIndex = flagConfig.luceneindexpath();
        if (!flagConfig.initialtermvectors().isEmpty()) {
            try {
                VectorStoreRAM vsr = new VectorStoreRAM(flagConfig);
                vsr.initFromFile(flagConfig.initialtermvectors());
                newElementalTermVectors = vsr;
                VerbatimLogger.info("Using trained index vectors from vector store " + flagConfig.initialtermvectors());
            }
            catch (IOException e) {
                logger.info("Could not read from vector store " + flagConfig.initialtermvectors());
                System.out.println(usageMessage);
                throw new IllegalArgumentException();
            }
        }
        String termFile = "";
        switch (flagConfig.positionalmethod()) {
            case BASIC: {
                termFile = flagConfig.termtermvectorsfile();
                break;
            }
            case PROXIMITY: {
                termFile = flagConfig.proximityvectorfile();
                break;
            }
            case PERMUTATION: {
                termFile = flagConfig.permutedvectorfile();
                break;
            }
            case PERMUTATIONPLUSBASIC: {
                termFile = flagConfig.permplustermvectorfile();
                break;
            }
            case DIRECTIONAL: {
                termFile = flagConfig.directionalvectorfile();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized -positionalmethod: " + (Object)((Object)flagConfig.positionalmethod()));
            }
        }
        if (flagConfig.encodingmethod().equals((Object)TermTermVectorsFromLucene.EncodingMethod.EMBEDDINGS)) {
            termFile = flagConfig.embeddingvectorfile();
        }
        VerbatimLogger.info("Building positional index, Lucene index: " + luceneIndex + ", Seedlength: " + flagConfig.seedlength() + ", Vector length: " + flagConfig.dimension() + ", Vector type: " + (Object)((Object)flagConfig.vectortype()) + ", Minimum term frequency: " + flagConfig.minfrequency() + ", Maximum term frequency: " + flagConfig.maxfrequency() + ", Number non-alphabet characters: " + flagConfig.maxnonalphabetchars() + ", Window radius: " + flagConfig.windowradius() + ", Fields to index: " + Arrays.toString(flagConfig.contentsfields()) + "\n");
        try {
            TermTermVectorsFromLucene termTermIndexer = new TermTermVectorsFromLucene(flagConfig, newElementalTermVectors);
            if (!flagConfig.encodingmethod().equals((Object)TermTermVectorsFromLucene.EncodingMethod.EMBEDDINGS)) {
                for (int i = 1; i < flagConfig.trainingcycles(); ++i) {
                    newElementalTermVectors = termTermIndexer.getSemanticTermVectors();
                    VerbatimLogger.info("\nRetraining with learned term vectors ...");
                    termTermIndexer = new TermTermVectorsFromLucene(flagConfig, newElementalTermVectors);
                }
            }
            if (!flagConfig.encodingmethod().equals((Object)TermTermVectorsFromLucene.EncodingMethod.EMBEDDINGS) || flagConfig.docindexing().equals((Object)DocVectors.DocIndexingStrategy.NONE)) {
                Enumeration<ObjectVector> e = termTermIndexer.getSemanticTermVectors().getAllVectors();
                if (!flagConfig.notnormalized()) {
                    while (e.hasMoreElements()) {
                        e.nextElement().getVector().normalize();
                    }
                }
            }
            if (!(flagConfig.docindexing() == DocVectors.DocIndexingStrategy.NONE || flagConfig.encodingmethod().equals((Object)TermTermVectorsFromLucene.EncodingMethod.EMBEDDINGS) && flagConfig.docindexing().equals((Object)DocVectors.DocIndexingStrategy.INMEMORY))) {
                IncrementalDocVectors.createIncrementalDocVectors(termTermIndexer.getSemanticTermVectors(), flagConfig, new LuceneUtils(flagConfig));
                if (flagConfig.encodingmethod().equals((Object)TermTermVectorsFromLucene.EncodingMethod.EMBEDDINGS)) {
                    Enumeration<ObjectVector> e = termTermIndexer.getSemanticTermVectors().getAllVectors();
                    if (!flagConfig.notnormalized()) {
                        while (e.hasMoreElements()) {
                            e.nextElement().getVector().normalize();
                        }
                    }
                }
            }
            VectorStoreWriter.writeVectors(termFile, flagConfig, termTermIndexer.getSemanticTermVectors());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

