/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.semanticvectors;

import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class BlockingExecutor {
    private final ExecutorService executor;
    private final Semaphore semaphore;

    public BlockingExecutor(int blockingQueueSize, int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit unit) {
        LinkedBlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue<Runnable>();
        this.executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, unit, blockingQueue);
        this.semaphore = new Semaphore(blockingQueueSize + maxPoolSize);
    }

    private void execImpl(Runnable command) {
        this.semaphore.acquireUninterruptibly();
        try {
            this.executor.execute(() -> {
                try {
                    command.run();
                }
                finally {
                    this.semaphore.release();
                }
            });
        }
        catch (RejectedExecutionException e) {
            this.semaphore.release();
            throw e;
        }
    }

    public void execute(Runnable command) {
        this.execImpl(command);
    }

    public void shutdown() throws IOException {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(7L, TimeUnit.DAYS);
        }
        catch (InterruptedException e) {
            throw new IOException("Building index did not complete in 1 week");
        }
    }

    public void shutdownNow() throws InterruptedException {
        this.executor.shutdownNow();
        this.executor.awaitTermination(30L, TimeUnit.SECONDS);
    }
}

