/*
 * Decompiled with CFR 0.152.
 */
package pitt.search.lucene;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.store.FSDirectory;
import pitt.search.semanticvectors.FlagConfig;
import pitt.search.semanticvectors.utils.VerbatimLogger;

public class LuceneIndexFromTriples {
    static Path INDEX_DIR = FileSystems.getDefault().getPath("predication_index", new String[0]);

    private LuceneIndexFromTriples() {
    }

    public static void main(String[] args) {
        FlagConfig flagConfig;
        String usage = "java pitt.search.lucene.LuceneIndexFromTriples [triples text file] ";
        if (args.length == 0) {
            System.err.println("Usage: " + usage);
            System.exit(1);
        }
        if ((flagConfig = FlagConfig.getFlagConfig(args)).luceneindexpath().length() > 0) {
            INDEX_DIR = FileSystems.getDefault().getPath(flagConfig.luceneindexpath(), new String[0]);
        }
        if (Files.exists(INDEX_DIR, new LinkOption[0])) {
            throw new IllegalArgumentException("Cannot save index to '" + INDEX_DIR + "' directory, please delete it first");
        }
        try {
            IndexWriterConfig writerConfig = new IndexWriterConfig(new WhitespaceAnalyzer());
            IndexWriter writer = new IndexWriter(FSDirectory.open(INDEX_DIR), writerConfig);
            File triplesTextFile = new File(flagConfig.remainingArgs[0]);
            if (!triplesTextFile.exists() || !triplesTextFile.canRead()) {
                writer.close();
                throw new IOException("Document file '" + triplesTextFile.getAbsolutePath() + "' does not exist or is not readable, please check the path");
            }
            System.out.println("Indexing to directory '" + INDEX_DIR + "'...");
            LuceneIndexFromTriples.indexDoc(writer, triplesTextFile);
            writer.close();
        }
        catch (IOException e) {
            System.out.println(" caught a " + e.getClass() + "\n with message: " + e.getMessage());
        }
    }

    static void indexDoc(IndexWriter fsWriter, File triplesTextFile) throws IOException {
        String lineIn;
        BufferedReader theReader = new BufferedReader(new FileReader(triplesTextFile));
        int linecnt = 0;
        while ((lineIn = theReader.readLine()) != null) {
            StringTokenizer theTokenizer = new StringTokenizer(lineIn, "\t");
            if (++linecnt % 10000 == 0 || linecnt < 10000 && linecnt % 1000 == 0) {
                VerbatimLogger.info(linecnt + " ... ");
            }
            try {
                if (theTokenizer.countTokens() < 3) {
                    VerbatimLogger.warning("Line in predication file does not have three delimited fields: " + lineIn + "\n");
                    continue;
                }
                String subject = theTokenizer.nextToken().trim().toLowerCase().replaceAll(" ", "_");
                String predicate = theTokenizer.nextToken().trim().toUpperCase().replaceAll(" ", "_");
                String object = theTokenizer.nextToken().trim().toLowerCase().replaceAll(" ", "_");
                Document doc = new Document();
                doc.add(new TextField("subject", subject, Field.Store.YES));
                doc.add(new TextField("predicate", predicate, Field.Store.YES));
                doc.add(new TextField("object", object, Field.Store.YES));
                doc.add(new TextField("predication", subject + predicate + object, Field.Store.NO));
                fsWriter.addDocument(doc);
            }
            catch (Exception e) {
                System.out.println(lineIn);
                e.printStackTrace();
            }
        }
        VerbatimLogger.info("\n");
        theReader.close();
    }
}

