/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.sortedset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.LabelAndValue;
import org.apache.lucene.facet.TopOrdAndIntQueue;
import org.apache.lucene.facet.sortedset.SortedSetDocValuesReaderState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.PriorityQueue;

public class SortedSetDocValuesFacetCounts
extends Facets {
    final SortedSetDocValuesReaderState state;
    final SortedSetDocValues dv;
    final String field;
    final int[] counts;

    public SortedSetDocValuesFacetCounts(SortedSetDocValuesReaderState state, FacetsCollector hits) throws IOException {
        this.state = state;
        this.field = state.getField();
        this.dv = state.getDocValues();
        this.counts = new int[state.getSize()];
        this.count(hits.getMatchingDocs());
    }

    @Override
    public FacetResult getTopChildren(int topN, String dim, String ... path) throws IOException {
        if (topN <= 0) {
            throw new IllegalArgumentException("topN must be > 0 (got: " + topN + ")");
        }
        if (path.length > 0) {
            throw new IllegalArgumentException("path should be 0 length");
        }
        SortedSetDocValuesReaderState.OrdRange ordRange = this.state.getOrdRange(dim);
        if (ordRange == null) {
            throw new IllegalArgumentException("dimension \"" + dim + "\" was not indexed");
        }
        return this.getDim(dim, ordRange, topN);
    }

    private final FacetResult getDim(String dim, SortedSetDocValuesReaderState.OrdRange ordRange, int topN) {
        PriorityQueue q = null;
        int bottomCount = 0;
        int dimCount = 0;
        int childCount = 0;
        TopOrdAndIntQueue.OrdAndValue reuse = null;
        for (int ord = ordRange.start; ord <= ordRange.end; ++ord) {
            if (this.counts[ord] <= 0) continue;
            dimCount += this.counts[ord];
            ++childCount;
            if (this.counts[ord] <= bottomCount) continue;
            if (reuse == null) {
                reuse = new TopOrdAndIntQueue.OrdAndValue();
            }
            reuse.ord = ord;
            reuse.value = this.counts[ord];
            if (q == null) {
                q = new TopOrdAndIntQueue(topN);
            }
            reuse = q.insertWithOverflow(reuse);
            if (q.size() != topN) continue;
            bottomCount = ((TopOrdAndIntQueue.OrdAndValue)q.top()).value;
        }
        if (q == null) {
            return null;
        }
        LabelAndValue[] labelValues = new LabelAndValue[q.size()];
        for (int i = labelValues.length - 1; i >= 0; --i) {
            TopOrdAndIntQueue.OrdAndValue ordAndValue = (TopOrdAndIntQueue.OrdAndValue)q.pop();
            BytesRef term = this.dv.lookupOrd(ordAndValue.ord);
            String[] parts = FacetsConfig.stringToPath(term.utf8ToString());
            labelValues[i] = new LabelAndValue(parts[1], ordAndValue.value);
        }
        return new FacetResult(dim, new String[0], dimCount, labelValues, childCount);
    }

    private void countOneSegment(MultiDocValues.OrdinalMap ordinalMap, LeafReader reader, int segOrd, FacetsCollector.MatchingDocs hits) throws IOException {
        SortedSetDocValues segValues = reader.getSortedSetDocValues(this.field);
        if (segValues == null) {
            return;
        }
        DocIdSetIterator docs = hits.bits.iterator();
        if (ordinalMap != null) {
            LongValues ordMap = ordinalMap.getGlobalOrds(segOrd);
            int numSegOrds = (int)segValues.getValueCount();
            if (hits.totalHits < numSegOrds / 10) {
                int doc;
                while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                    segValues.setDocument(doc);
                    int term = (int)segValues.nextOrd();
                    while ((long)term != -1L) {
                        int n = (int)ordMap.get(term);
                        this.counts[n] = this.counts[n] + 1;
                        term = (int)segValues.nextOrd();
                    }
                }
            } else {
                int doc;
                int[] segCounts = new int[numSegOrds];
                while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                    segValues.setDocument(doc);
                    int term = (int)segValues.nextOrd();
                    while ((long)term != -1L) {
                        int n = term;
                        segCounts[n] = segCounts[n] + 1;
                        term = (int)segValues.nextOrd();
                    }
                }
                for (int ord = 0; ord < numSegOrds; ++ord) {
                    int count = segCounts[ord];
                    if (count == 0) continue;
                    int n = (int)ordMap.get(ord);
                    this.counts[n] = this.counts[n] + count;
                }
            }
        } else {
            int doc;
            while ((doc = docs.nextDoc()) != Integer.MAX_VALUE) {
                segValues.setDocument(doc);
                int term = (int)segValues.nextOrd();
                while ((long)term != -1L) {
                    int n = term;
                    this.counts[n] = this.counts[n] + 1;
                    term = (int)segValues.nextOrd();
                }
            }
        }
    }

    private final void count(List<FacetsCollector.MatchingDocs> matchingDocs) throws IOException {
        MultiDocValues.OrdinalMap ordinalMap = this.dv instanceof MultiDocValues.MultiSortedSetDocValues && matchingDocs.size() > 1 ? ((MultiDocValues.MultiSortedSetDocValues)this.dv).mapping : null;
        IndexReader reader = this.state.getReader();
        for (FacetsCollector.MatchingDocs hits : matchingDocs) {
            if (ReaderUtil.getTopLevelContext(hits.context).reader() != reader) {
                throw new IllegalStateException("the SortedSetDocValuesReaderState provided to this class does not match the reader being searched; you must create a new SortedSetDocValuesReaderState every time you open a new IndexReader");
            }
            this.countOneSegment(ordinalMap, hits.context.reader(), hits.context.ord, hits);
        }
    }

    @Override
    public Number getSpecificValue(String dim, String ... path) {
        if (path.length != 1) {
            throw new IllegalArgumentException("path must be length=1");
        }
        int ord = (int)this.dv.lookupTerm(new BytesRef(FacetsConfig.pathToString(dim, path)));
        if (ord < 0) {
            return -1;
        }
        return this.counts[ord];
    }

    @Override
    public List<FacetResult> getAllDims(int topN) throws IOException {
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        for (Map.Entry<String, SortedSetDocValuesReaderState.OrdRange> ent : this.state.getPrefixToOrdRange().entrySet()) {
            FacetResult fr = this.getDim(ent.getKey(), ent.getValue(), topN);
            if (fr == null) continue;
            results.add(fr);
        }
        Collections.sort(results, new Comparator<FacetResult>(){

            @Override
            public int compare(FacetResult a, FacetResult b) {
                if (a.value.intValue() > b.value.intValue()) {
                    return -1;
                }
                if (b.value.intValue() > a.value.intValue()) {
                    return 1;
                }
                return a.dim.compareTo(b.dim);
            }
        });
        return results;
    }
}

