/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.facet.range;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.facet.range.Range;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LongValues;
import org.apache.lucene.search.LongValuesSource;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;

public final class LongRange
extends Range {
    public final long min;
    public final long max;

    public LongRange(String label, long minIn, boolean minInclusive, long maxIn, boolean maxInclusive) {
        super(label);
        if (!minInclusive) {
            if (minIn != Long.MAX_VALUE) {
                ++minIn;
            } else {
                this.failNoMatch();
            }
        }
        if (!maxInclusive) {
            if (maxIn != Long.MIN_VALUE) {
                --maxIn;
            } else {
                this.failNoMatch();
            }
        }
        if (minIn > maxIn) {
            this.failNoMatch();
        }
        this.min = minIn;
        this.max = maxIn;
    }

    public boolean accept(long value) {
        return value >= this.min && value <= this.max;
    }

    public String toString() {
        return "LongRange(" + this.min + " to " + this.max + ")";
    }

    @Deprecated
    public Query getQuery(Query fastMatchQuery, ValueSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource.asLongValuesSource());
    }

    public Query getQuery(Query fastMatchQuery, LongValuesSource valueSource) {
        return new ValueSourceQuery(this, fastMatchQuery, valueSource);
    }

    private static class ValueSourceQuery
    extends Query {
        private final LongRange range;
        private final Query fastMatchQuery;
        private final LongValuesSource valueSource;

        ValueSourceQuery(LongRange range, Query fastMatchQuery, LongValuesSource valueSource) {
            this.range = range;
            this.fastMatchQuery = fastMatchQuery;
            this.valueSource = valueSource;
        }

        @Override
        public boolean equals(Object other) {
            return this.sameClassAs(other) && this.equalsTo((ValueSourceQuery)this.getClass().cast(other));
        }

        private boolean equalsTo(ValueSourceQuery other) {
            return this.range.equals(other.range) && Objects.equals(this.fastMatchQuery, other.fastMatchQuery) && this.valueSource.equals(other.valueSource);
        }

        @Override
        public int hashCode() {
            return this.classHash() + 31 * Objects.hash(this.range, this.fastMatchQuery, this.valueSource);
        }

        @Override
        public String toString(String field) {
            return "Filter(" + this.range.toString() + ")";
        }

        @Override
        public Query rewrite(IndexReader reader) throws IOException {
            Query fastMatchRewritten;
            if (this.fastMatchQuery != null && (fastMatchRewritten = this.fastMatchQuery.rewrite(reader)) != this.fastMatchQuery) {
                return new ValueSourceQuery(this.range, fastMatchRewritten, this.valueSource);
            }
            return super.rewrite(reader);
        }

        @Override
        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            final Weight fastMatchWeight = this.fastMatchQuery == null ? null : searcher.createWeight(this.fastMatchQuery, false);
            return new ConstantScoreWeight(this){

                @Override
                public Scorer scorer(LeafReaderContext context) throws IOException {
                    DocIdSetIterator approximation;
                    int maxDoc = context.reader().maxDoc();
                    if (fastMatchWeight == null) {
                        approximation = DocIdSetIterator.all(maxDoc);
                    } else {
                        Scorer s = fastMatchWeight.scorer(context);
                        if (s == null) {
                            return null;
                        }
                        approximation = s.iterator();
                    }
                    final LongValues values = valueSource.getValues(context, null);
                    TwoPhaseIterator twoPhase = new TwoPhaseIterator(approximation){

                        @Override
                        public boolean matches() throws IOException {
                            return values.advanceExact(this.approximation.docID()) && range.accept(values.longValue());
                        }

                        @Override
                        public float matchCost() {
                            return 100.0f;
                        }
                    };
                    return new ConstantScoreScorer((Weight)this, this.score(), twoPhase);
                }
            };
        }
    }
}

