/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.expressions;

import java.io.IOException;
import org.apache.lucene.expressions.Expression;
import org.apache.lucene.search.DoubleValues;

class ExpressionFunctionValues
extends DoubleValues {
    final Expression expression;
    final DoubleValues[] functionValues;

    ExpressionFunctionValues(Expression expression, DoubleValues[] functionValues) {
        if (expression == null) {
            throw new NullPointerException();
        }
        if (functionValues == null) {
            throw new NullPointerException();
        }
        this.expression = expression;
        this.functionValues = functionValues;
    }

    @Override
    public boolean advanceExact(int doc) throws IOException {
        for (DoubleValues v : this.functionValues) {
            v.advanceExact(doc);
        }
        return true;
    }

    @Override
    public double doubleValue() {
        return this.expression.evaluate(this.functionValues);
    }
}

