/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.demo.facet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.facet.DrillDownQuery;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.FloatAssociationFacetField;
import org.apache.lucene.facet.taxonomy.IntAssociationFacetField;
import org.apache.lucene.facet.taxonomy.TaxonomyFacetSumFloatAssociations;
import org.apache.lucene.facet.taxonomy.TaxonomyFacetSumIntAssociations;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyReader;
import org.apache.lucene.facet.taxonomy.directory.DirectoryTaxonomyWriter;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class AssociationsFacetsExample {
    private final Directory indexDir = new RAMDirectory();
    private final Directory taxoDir = new RAMDirectory();
    private final FacetsConfig config = new FacetsConfig();

    public AssociationsFacetsExample() {
        this.config.setMultiValued("tags", true);
        this.config.setIndexFieldName("tags", "$tags");
        this.config.setMultiValued("genre", true);
        this.config.setIndexFieldName("genre", "$genre");
    }

    private void index() throws IOException {
        IndexWriterConfig iwc = new IndexWriterConfig(new WhitespaceAnalyzer()).setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        IndexWriter indexWriter = new IndexWriter(this.indexDir, iwc);
        DirectoryTaxonomyWriter taxoWriter = new DirectoryTaxonomyWriter(this.taxoDir);
        Document doc = new Document();
        doc.add(new IntAssociationFacetField(3, "tags", "lucene"));
        doc.add(new FloatAssociationFacetField(0.87f, "genre", "computing"));
        indexWriter.addDocument(this.config.build(taxoWriter, doc));
        doc = new Document();
        doc.add(new IntAssociationFacetField(1, "tags", "lucene"));
        doc.add(new IntAssociationFacetField(2, "tags", "solr"));
        doc.add(new FloatAssociationFacetField(0.75f, "genre", "computing"));
        doc.add(new FloatAssociationFacetField(0.34f, "genre", "software"));
        indexWriter.addDocument(this.config.build(taxoWriter, doc));
        indexWriter.close();
        taxoWriter.close();
    }

    private List<FacetResult> sumAssociations() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open(this.indexDir);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search(searcher, new MatchAllDocsQuery(), 10, fc);
        TaxonomyFacetSumIntAssociations tags = new TaxonomyFacetSumIntAssociations("$tags", taxoReader, this.config, fc);
        TaxonomyFacetSumFloatAssociations genre = new TaxonomyFacetSumFloatAssociations("$genre", taxoReader, this.config, fc);
        ArrayList<FacetResult> results = new ArrayList<FacetResult>();
        results.add(((Facets)tags).getTopChildren(10, "tags", new String[0]));
        results.add(((Facets)genre).getTopChildren(10, "genre", new String[0]));
        indexReader.close();
        taxoReader.close();
        return results;
    }

    private FacetResult drillDown() throws IOException {
        DirectoryReader indexReader = DirectoryReader.open(this.indexDir);
        IndexSearcher searcher = new IndexSearcher(indexReader);
        DirectoryTaxonomyReader taxoReader = new DirectoryTaxonomyReader(this.taxoDir);
        DrillDownQuery q = new DrillDownQuery(this.config);
        q.add("tags", "solr");
        FacetsCollector fc = new FacetsCollector();
        FacetsCollector.search(searcher, q, 10, fc);
        TaxonomyFacetSumFloatAssociations facets = new TaxonomyFacetSumFloatAssociations("$genre", taxoReader, this.config, fc);
        FacetResult result = ((Facets)facets).getTopChildren(10, "genre", new String[0]);
        indexReader.close();
        taxoReader.close();
        return result;
    }

    public List<FacetResult> runSumAssociations() throws IOException {
        this.index();
        return this.sumAssociations();
    }

    public FacetResult runDrillDown() throws IOException {
        this.index();
        return this.drillDown();
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Sum associations example:");
        System.out.println("-------------------------");
        List<FacetResult> results = new AssociationsFacetsExample().runSumAssociations();
        System.out.println("tags: " + results.get(0));
        System.out.println("genre: " + results.get(1));
    }
}

