/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktreeords;

import java.io.IOException;
import org.apache.lucene.codecs.FieldsConsumer;
import org.apache.lucene.codecs.FieldsProducer;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsReader;
import org.apache.lucene.codecs.blocktreeords.OrdsBlockTreeTermsWriter;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsReader;
import org.apache.lucene.codecs.lucene50.Lucene50PostingsWriter;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.IOUtils;

public class BlockTreeOrdsPostingsFormat
extends PostingsFormat {
    private final int minTermBlockSize;
    private final int maxTermBlockSize;
    public static final int BLOCK_SIZE = 128;

    public BlockTreeOrdsPostingsFormat() {
        this(25, 48);
    }

    public BlockTreeOrdsPostingsFormat(int minTermBlockSize, int maxTermBlockSize) {
        super("BlockTreeOrds");
        this.minTermBlockSize = minTermBlockSize;
        this.maxTermBlockSize = maxTermBlockSize;
        BlockTreeTermsWriter.validateSettings(minTermBlockSize, maxTermBlockSize);
    }

    @Override
    public String toString() {
        return this.getName() + "(blocksize=" + 128 + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsConsumer fieldsConsumer(SegmentWriteState state) throws IOException {
        OrdsBlockTreeTermsWriter ordsBlockTreeTermsWriter;
        block3: {
            Lucene50PostingsWriter postingsWriter = new Lucene50PostingsWriter(state);
            boolean success = false;
            try {
                OrdsBlockTreeTermsWriter ret = new OrdsBlockTreeTermsWriter(state, postingsWriter, this.minTermBlockSize, this.maxTermBlockSize);
                success = true;
                ordsBlockTreeTermsWriter = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsWriter);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsWriter);
        }
        return ordsBlockTreeTermsWriter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FieldsProducer fieldsProducer(SegmentReadState state) throws IOException {
        OrdsBlockTreeTermsReader ordsBlockTreeTermsReader;
        block3: {
            Lucene50PostingsReader postingsReader = new Lucene50PostingsReader(state);
            boolean success = false;
            try {
                OrdsBlockTreeTermsReader ret = new OrdsBlockTreeTermsReader(postingsReader, state);
                success = true;
                ordsBlockTreeTermsReader = ret;
                if (success) break block3;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(postingsReader);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(postingsReader);
        }
        return ordsBlockTreeTermsReader;
    }
}

