/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tfloat.ref;

import hep.aida.tfloat.FloatIAxis;
import hep.aida.tfloat.FloatIHistogram1D;
import hep.aida.tfloat.FloatIHistogram2D;
import hep.aida.tfloat.ref.FloatAbstractHistogram2D;
import hep.aida.tfloat.ref.FloatFixedAxis;
import hep.aida.tfloat.ref.FloatHistogram1D;
import hep.aida.tfloat.ref.FloatVariableAxis;

public class FloatHistogram2D
extends FloatAbstractHistogram2D
implements FloatIHistogram2D {
    private static final long serialVersionUID = 1L;
    private float[][] heights;
    private float[][] errors;
    private int[][] entries;
    private int nEntry;
    private float sumWeight;
    private float sumWeightSquared;
    private float meanX;
    private float rmsX;
    private float meanY;
    private float rmsY;

    public FloatHistogram2D(String title, float[] xEdges, float[] yEdges) {
        this(title, new FloatVariableAxis(xEdges), new FloatVariableAxis(yEdges));
    }

    public FloatHistogram2D(String title, int xBins, float xMin, float xMax, int yBins, float yMin, float yMax) {
        this(title, new FloatFixedAxis(xBins, xMin, xMax), new FloatFixedAxis(yBins, yMin, yMax));
    }

    public FloatHistogram2D(String title, FloatIAxis xAxis, FloatIAxis yAxis) {
        super(title);
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        int xBins = xAxis.bins();
        int yBins = yAxis.bins();
        this.entries = new int[xBins + 2][yBins + 2];
        this.heights = new float[xBins + 2][yBins + 2];
        this.errors = new float[xBins + 2][yBins + 2];
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int indexX, int indexY) {
        return this.entries[this.mapX(indexX)][this.mapY(indexY)];
    }

    public float binError(int indexX, int indexY) {
        return (float)Math.sqrt(this.errors[this.mapX(indexX)][this.mapY(indexY)]);
    }

    public float binHeight(int indexX, int indexY) {
        return this.heights[this.mapX(indexX)][this.mapY(indexY)];
    }

    public float equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(float x, float y) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        float[] fArray = this.heights[xBin];
        int n2 = yBin;
        fArray[n2] = fArray[n2] + 1.0f;
        float[] fArray2 = this.errors[xBin];
        int n3 = yBin;
        fArray2[n3] = fArray2[n3] + 1.0f;
        ++this.nEntry;
        this.sumWeight += 1.0f;
        this.sumWeightSquared += 1.0f;
        this.meanX += x;
        this.rmsX += x;
        this.meanY += y;
        this.rmsY += y;
    }

    public void fill(float x, float y, float weight) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        float[] fArray = this.heights[xBin];
        int n2 = yBin;
        fArray[n2] = fArray[n2] + weight;
        float[] fArray2 = this.errors[xBin];
        int n3 = yBin;
        fArray2[n3] = fArray2[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.meanX += x * weight;
        this.rmsX += x * weight * weight;
        this.meanY += y * weight;
        this.rmsY += y * weight * weight;
    }

    protected FloatIHistogram1D internalSliceX(String title, int indexY1, int indexY2) {
        if (indexY2 < indexY1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int sliceBins = this.xAxis.bins() + 2;
        int[] sliceEntries = new int[sliceBins];
        float[] sliceHeights = new float[sliceBins];
        float[] sliceErrors = new float[sliceBins];
        for (int i = 0; i < sliceBins; ++i) {
            for (int j = indexY1; j <= indexY2; ++j) {
                int n = i;
                sliceEntries[n] = sliceEntries[n] + this.entries[i][j];
                int n2 = i;
                sliceHeights[n2] = sliceHeights[n2] + this.heights[i][j];
                int n3 = i;
                sliceErrors[n3] = sliceErrors[n3] + this.errors[i][j];
            }
        }
        FloatHistogram1D result = new FloatHistogram1D(title, this.xAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    protected FloatIHistogram1D internalSliceY(String title, int indexX1, int indexX2) {
        if (indexX2 < indexX1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int sliceBins = this.yAxis.bins() + 2;
        int[] sliceEntries = new int[sliceBins];
        float[] sliceHeights = new float[sliceBins];
        float[] sliceErrors = new float[sliceBins];
        for (int i = indexX1; i <= indexX2; ++i) {
            for (int j = 0; j < sliceBins; ++j) {
                int n = j;
                sliceEntries[n] = sliceEntries[n] + this.entries[i][j];
                int n2 = j;
                sliceHeights[n2] = sliceHeights[n2] + this.heights[i][j];
                int n3 = j;
                sliceErrors[n3] = sliceErrors[n3] + this.errors[i][j];
            }
        }
        FloatHistogram1D result = new FloatHistogram1D(title, this.yAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    public float meanX() {
        return this.meanX / this.sumWeight;
    }

    public float meanY() {
        return this.meanY / this.sumWeight;
    }

    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                this.entries[i][j] = 0;
                this.heights[i][j] = 0.0f;
                this.errors[i][j] = 0.0f;
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0f;
        this.sumWeightSquared = 0.0f;
        this.meanX = 0.0f;
        this.rmsX = 0.0f;
        this.meanY = 0.0f;
        this.rmsY = 0.0f;
    }

    public float rmsX() {
        return (float)Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    public float rmsY() {
        return (float)Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    void setContents(int[][] entries, float[][] heights, float[][] errors) {
        this.entries = entries;
        this.heights = heights;
        this.errors = errors;
        for (int i = 0; i < entries.length; ++i) {
            for (int j = 0; j < entries[0].length; ++j) {
                this.nEntry += entries[i][j];
                this.sumWeight += heights[i][j];
            }
        }
        this.sumWeightSquared = Float.NaN;
        this.meanX = Float.NaN;
        this.rmsX = Float.NaN;
        this.meanY = Float.NaN;
        this.rmsY = Float.NaN;
    }

    public float sumAllBinHeights() {
        return this.sumWeight;
    }
}

