/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram1D;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.ref.DoubleAbstractHistogram2D;
import hep.aida.tdouble.ref.DoubleFixedAxis;
import hep.aida.tdouble.ref.DoubleHistogram1D;
import hep.aida.tdouble.ref.DoubleVariableAxis;

public class DoubleHistogram2D
extends DoubleAbstractHistogram2D
implements DoubleIHistogram2D {
    private static final long serialVersionUID = 1L;
    private double[][] heights;
    private double[][] errors;
    private int[][] entries;
    private int nEntry;
    private double sumWeight;
    private double sumWeightSquared;
    private double meanX;
    private double rmsX;
    private double meanY;
    private double rmsY;

    public DoubleHistogram2D(String title, double[] xEdges, double[] yEdges) {
        this(title, new DoubleVariableAxis(xEdges), new DoubleVariableAxis(yEdges));
    }

    public DoubleHistogram2D(String title, int xBins, double xMin, double xMax, int yBins, double yMin, double yMax) {
        this(title, new DoubleFixedAxis(xBins, xMin, xMax), new DoubleFixedAxis(yBins, yMin, yMax));
    }

    public DoubleHistogram2D(String title, DoubleIAxis xAxis, DoubleIAxis yAxis) {
        super(title);
        this.xAxis = xAxis;
        this.yAxis = yAxis;
        int xBins = xAxis.bins();
        int yBins = yAxis.bins();
        this.entries = new int[xBins + 2][yBins + 2];
        this.heights = new double[xBins + 2][yBins + 2];
        this.errors = new double[xBins + 2][yBins + 2];
    }

    public int allEntries() {
        return this.nEntry;
    }

    public int binEntries(int indexX, int indexY) {
        return this.entries[this.mapX(indexX)][this.mapY(indexY)];
    }

    public double binError(int indexX, int indexY) {
        return Math.sqrt(this.errors[this.mapX(indexX)][this.mapY(indexY)]);
    }

    public double binHeight(int indexX, int indexY) {
        return this.heights[this.mapX(indexX)][this.mapY(indexY)];
    }

    public double equivalentBinEntries() {
        return this.sumWeight * this.sumWeight / this.sumWeightSquared;
    }

    public void fill(double x, double y) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin];
        int n2 = yBin;
        dArray[n2] = dArray[n2] + 1.0;
        double[] dArray2 = this.errors[xBin];
        int n3 = yBin;
        dArray2[n3] = dArray2[n3] + 1.0;
        ++this.nEntry;
        this.sumWeight += 1.0;
        this.sumWeightSquared += 1.0;
        this.meanX += x;
        this.rmsX += x;
        this.meanY += y;
        this.rmsY += y;
    }

    public void fill(double x, double y, double weight) {
        int xBin = this.mapX(this.xAxis.coordToIndex(x));
        int yBin = this.mapY(this.yAxis.coordToIndex(y));
        int[] nArray = this.entries[xBin];
        int n = yBin;
        nArray[n] = nArray[n] + 1;
        double[] dArray = this.heights[xBin];
        int n2 = yBin;
        dArray[n2] = dArray[n2] + weight;
        double[] dArray2 = this.errors[xBin];
        int n3 = yBin;
        dArray2[n3] = dArray2[n3] + weight * weight;
        ++this.nEntry;
        this.sumWeight += weight;
        this.sumWeightSquared += weight * weight;
        this.meanX += x * weight;
        this.rmsX += x * weight * weight;
        this.meanY += y * weight;
        this.rmsY += y * weight * weight;
    }

    protected DoubleIHistogram1D internalSliceX(String title, int indexY1, int indexY2) {
        if (indexY2 < indexY1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int sliceBins = this.xAxis.bins() + 2;
        int[] sliceEntries = new int[sliceBins];
        double[] sliceHeights = new double[sliceBins];
        double[] sliceErrors = new double[sliceBins];
        for (int i = 0; i < sliceBins; ++i) {
            for (int j = indexY1; j <= indexY2; ++j) {
                int n = i;
                sliceEntries[n] = sliceEntries[n] + this.entries[i][j];
                int n2 = i;
                sliceHeights[n2] = sliceHeights[n2] + this.heights[i][j];
                int n3 = i;
                sliceErrors[n3] = sliceErrors[n3] + this.errors[i][j];
            }
        }
        DoubleHistogram1D result = new DoubleHistogram1D(title, this.xAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    protected DoubleIHistogram1D internalSliceY(String title, int indexX1, int indexX2) {
        if (indexX2 < indexX1) {
            throw new IllegalArgumentException("Invalid bin range");
        }
        int sliceBins = this.yAxis.bins() + 2;
        int[] sliceEntries = new int[sliceBins];
        double[] sliceHeights = new double[sliceBins];
        double[] sliceErrors = new double[sliceBins];
        for (int i = indexX1; i <= indexX2; ++i) {
            for (int j = 0; j < sliceBins; ++j) {
                int n = j;
                sliceEntries[n] = sliceEntries[n] + this.entries[i][j];
                int n2 = j;
                sliceHeights[n2] = sliceHeights[n2] + this.heights[i][j];
                int n3 = j;
                sliceErrors[n3] = sliceErrors[n3] + this.errors[i][j];
            }
        }
        DoubleHistogram1D result = new DoubleHistogram1D(title, this.yAxis);
        result.setContents(sliceEntries, sliceHeights, sliceErrors);
        return result;
    }

    public double meanX() {
        return this.meanX / this.sumWeight;
    }

    public double meanY() {
        return this.meanY / this.sumWeight;
    }

    public void reset() {
        for (int i = 0; i < this.entries.length; ++i) {
            for (int j = 0; j < this.entries[0].length; ++j) {
                this.entries[i][j] = 0;
                this.heights[i][j] = 0.0;
                this.errors[i][j] = 0.0;
            }
        }
        this.nEntry = 0;
        this.sumWeight = 0.0;
        this.sumWeightSquared = 0.0;
        this.meanX = 0.0;
        this.rmsX = 0.0;
        this.meanY = 0.0;
        this.rmsY = 0.0;
    }

    public double rmsX() {
        return Math.sqrt(this.rmsX / this.sumWeight - this.meanX * this.meanX / this.sumWeight / this.sumWeight);
    }

    public double rmsY() {
        return Math.sqrt(this.rmsY / this.sumWeight - this.meanY * this.meanY / this.sumWeight / this.sumWeight);
    }

    void setContents(int[][] entries, double[][] heights, double[][] errors) {
        this.entries = entries;
        this.heights = heights;
        this.errors = errors;
        for (int i = 0; i < entries.length; ++i) {
            for (int j = 0; j < entries[0].length; ++j) {
                this.nEntry += entries[i][j];
                this.sumWeight += heights[i][j];
            }
        }
        this.sumWeightSquared = Double.NaN;
        this.meanX = Double.NaN;
        this.rmsX = Double.NaN;
        this.meanY = Double.NaN;
        this.rmsY = Double.NaN;
    }

    public double sumAllBinHeights() {
        return this.sumWeight;
    }
}

