/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.ref;

import hep.aida.tdouble.DoubleIAxis;
import hep.aida.tdouble.DoubleIHistogram2D;
import hep.aida.tdouble.DoubleIHistogram3D;
import hep.aida.tdouble.ref.DoubleHistogram;

abstract class DoubleAbstractHistogram3D
extends DoubleHistogram
implements DoubleIHistogram3D {
    private static final long serialVersionUID = 1L;
    protected DoubleIAxis xAxis;
    protected DoubleIAxis yAxis;
    protected DoubleIAxis zAxis;

    DoubleAbstractHistogram3D(String title) {
        super(title);
    }

    public int allEntries() {
        int n = 0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public int dimensions() {
        return 3;
    }

    public int entries() {
        int n = 0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binEntries(i, j, k);
                }
            }
        }
        return n;
    }

    public int extraEntries() {
        return this.allEntries() - this.entries();
    }

    public void fill(double x, double y, double z) {
        this.fill(x, y, z, 1.0);
    }

    protected abstract DoubleIHistogram2D internalSliceXY(String var1, int var2, int var3);

    protected abstract DoubleIHistogram2D internalSliceXZ(String var1, int var2, int var3);

    protected abstract DoubleIHistogram2D internalSliceYZ(String var1, int var2, int var3);

    int mapX(int index) {
        int bins = this.xAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapY(int index) {
        int bins = this.yAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    int mapZ(int index) {
        int bins = this.zAxis.bins() + 2;
        if (index >= bins) {
            throw new IllegalArgumentException("bin=" + index);
        }
        if (index >= 0) {
            return index + 1;
        }
        if (index == -2) {
            return 0;
        }
        if (index == -1) {
            return bins - 1;
        }
        throw new IllegalArgumentException("bin=" + index);
    }

    public int[] minMaxBins() {
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        int minBinX = -1;
        int minBinY = -1;
        int minBinZ = -1;
        int maxBinX = -1;
        int maxBinY = -1;
        int maxBinZ = -1;
        int i = this.xAxis.bins();
        while (--i >= 0) {
            int j = this.yAxis.bins();
            while (--j >= 0) {
                int k = this.zAxis.bins();
                while (--k >= 0) {
                    double value = this.binHeight(i, j, k);
                    if (value < minValue) {
                        minValue = value;
                        minBinX = i;
                        minBinY = j;
                        minBinZ = k;
                    }
                    if (!(value > maxValue)) continue;
                    maxValue = value;
                    maxBinX = i;
                    maxBinY = j;
                    maxBinZ = k;
                }
            }
        }
        int[] result = new int[]{minBinX, minBinY, minBinZ, maxBinX, maxBinY, maxBinZ};
        return result;
    }

    public DoubleIHistogram2D projectionXY() {
        String newTitle = this.title() + " (projectionXY)";
        return this.internalSliceXY(newTitle, this.mapZ(-2), this.mapZ(-1));
    }

    public DoubleIHistogram2D projectionXZ() {
        String newTitle = this.title() + " (projectionXZ)";
        return this.internalSliceXZ(newTitle, this.mapY(-2), this.mapY(-1));
    }

    public DoubleIHistogram2D projectionYZ() {
        String newTitle = this.title() + " (projectionYZ)";
        return this.internalSliceYZ(newTitle, this.mapX(-2), this.mapX(-1));
    }

    public DoubleIHistogram2D sliceXY(int indexZ) {
        return this.sliceXY(indexZ, indexZ);
    }

    public DoubleIHistogram2D sliceXY(int indexZ1, int indexZ2) {
        int start = this.mapZ(indexZ1);
        int stop = this.mapZ(indexZ2);
        String newTitle = this.title() + " (sliceXY [" + indexZ1 + ":" + indexZ2 + "])";
        return this.internalSliceXY(newTitle, start, stop);
    }

    public DoubleIHistogram2D sliceXZ(int indexY) {
        return this.sliceXZ(indexY, indexY);
    }

    public DoubleIHistogram2D sliceXZ(int indexY1, int indexY2) {
        int start = this.mapY(indexY1);
        int stop = this.mapY(indexY2);
        String newTitle = this.title() + " (sliceXZ [" + indexY1 + ":" + indexY2 + "])";
        return this.internalSliceXY(newTitle, start, stop);
    }

    public DoubleIHistogram2D sliceYZ(int indexX) {
        return this.sliceYZ(indexX, indexX);
    }

    public DoubleIHistogram2D sliceYZ(int indexX1, int indexX2) {
        int start = this.mapX(indexX1);
        int stop = this.mapX(indexX2);
        String newTitle = this.title() + " (sliceYZ [" + indexX1 + ":" + indexX2 + "])";
        return this.internalSliceYZ(newTitle, start, stop);
    }

    public double sumAllBinHeights() {
        double n = 0.0;
        int i = this.xAxis.bins();
        while (--i >= -2) {
            int j = this.yAxis.bins();
            while (--j >= -2) {
                int k = this.zAxis.bins();
                while (--k >= -2) {
                    n += this.binHeight(i, j, k);
                }
            }
        }
        return n;
    }

    public double sumBinHeights() {
        double n = 0.0;
        for (int i = 0; i < this.xAxis.bins(); ++i) {
            for (int j = 0; j < this.yAxis.bins(); ++j) {
                for (int k = 0; k < this.zAxis.bins(); ++k) {
                    n += this.binHeight(i, j, k);
                }
            }
        }
        return n;
    }

    public double sumExtraBinHeights() {
        return this.sumAllBinHeights() - this.sumBinHeights();
    }

    public DoubleIAxis xAxis() {
        return this.xAxis;
    }

    public DoubleIAxis yAxis() {
        return this.yAxis;
    }

    public DoubleIAxis zAxis() {
        return this.zAxis;
    }
}

