/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.tdouble.bin;

import cern.colt.list.tdouble.DoubleArrayList;
import cern.jet.stat.tdouble.DoubleDescriptive;
import hep.aida.tdouble.bin.AbstractDoubleBin1D;
import hep.aida.tdouble.bin.StaticDoubleBin1D;

public class MightyStaticDoubleBin1D
extends StaticDoubleBin1D {
    private static final long serialVersionUID = 1L;
    protected boolean hasSumOfLogarithms = false;
    protected double sumOfLogarithms = 0.0;
    protected boolean hasSumOfInversions = false;
    protected double sumOfInversions = 0.0;
    protected double[] sumOfPowers = null;

    public MightyStaticDoubleBin1D() {
        this(false, false, 4);
    }

    public MightyStaticDoubleBin1D(boolean hasSumOfLogarithms, boolean hasSumOfInversions, int maxOrderForSumOfPowers) {
        this.setMaxOrderForSumOfPowers(maxOrderForSumOfPowers);
        this.hasSumOfLogarithms = hasSumOfLogarithms;
        this.hasSumOfInversions = hasSumOfInversions;
        this.clear();
    }

    public synchronized void addAllOfFromTo(DoubleArrayList list, int from, int to) {
        super.addAllOfFromTo(list, from, to);
        if (this.sumOfPowers != null) {
            DoubleDescriptive.incrementalUpdateSumsOfPowers(list, from, to, 3, this.getMaxOrderForSumOfPowers(), this.sumOfPowers);
        }
        if (this.hasSumOfInversions) {
            this.sumOfInversions += DoubleDescriptive.sumOfInversions(list, from, to);
        }
        if (this.hasSumOfLogarithms) {
            this.sumOfLogarithms += DoubleDescriptive.sumOfLogarithms(list, from, to);
        }
    }

    protected void clearAllMeasures() {
        super.clearAllMeasures();
        this.sumOfLogarithms = 0.0;
        this.sumOfInversions = 0.0;
        if (this.sumOfPowers != null) {
            int i = this.sumOfPowers.length;
            while (--i >= 0) {
                this.sumOfPowers[i] = 0.0;
            }
        }
    }

    public synchronized Object clone() {
        MightyStaticDoubleBin1D clone = (MightyStaticDoubleBin1D)super.clone();
        if (this.sumOfPowers != null) {
            clone.sumOfPowers = (double[])clone.sumOfPowers.clone();
        }
        return clone;
    }

    public String compareWith(AbstractDoubleBin1D other) {
        StringBuffer buf = new StringBuffer(super.compareWith(other));
        if (other instanceof MightyStaticDoubleBin1D) {
            MightyStaticDoubleBin1D m = (MightyStaticDoubleBin1D)other;
            if (this.hasSumOfLogarithms() && m.hasSumOfLogarithms()) {
                buf.append("geometric mean: " + this.relError(this.geometricMean(), m.geometricMean()) + " %\n");
            }
            if (this.hasSumOfInversions() && m.hasSumOfInversions()) {
                buf.append("harmonic mean: " + this.relError(this.harmonicMean(), m.harmonicMean()) + " %\n");
            }
            if (this.hasSumOfPowers(3) && m.hasSumOfPowers(3)) {
                buf.append("skew: " + this.relError(this.skew(), m.skew()) + " %\n");
            }
            if (this.hasSumOfPowers(4) && m.hasSumOfPowers(4)) {
                buf.append("kurtosis: " + this.relError(this.kurtosis(), m.kurtosis()) + " %\n");
            }
            buf.append("\n");
        }
        return buf.toString();
    }

    public synchronized double geometricMean() {
        return DoubleDescriptive.geometricMean(this.size(), this.sumOfLogarithms());
    }

    public synchronized int getMaxOrderForSumOfPowers() {
        if (this.sumOfPowers == null) {
            return 2;
        }
        return 2 + this.sumOfPowers.length;
    }

    public synchronized int getMinOrderForSumOfPowers() {
        int minOrder = 0;
        if (this.hasSumOfInversions()) {
            minOrder = -1;
        }
        return minOrder;
    }

    public synchronized double harmonicMean() {
        return DoubleDescriptive.harmonicMean(this.size(), this.sumOfInversions());
    }

    public boolean hasSumOfInversions() {
        return this.hasSumOfInversions;
    }

    public boolean hasSumOfLogarithms() {
        return this.hasSumOfLogarithms;
    }

    public boolean hasSumOfPowers(int k) {
        return this.getMinOrderForSumOfPowers() <= k && k <= this.getMaxOrderForSumOfPowers();
    }

    public synchronized double kurtosis() {
        return DoubleDescriptive.kurtosis(this.moment(4, this.mean()), this.standardDeviation());
    }

    public synchronized double moment(int k, double c) {
        if (k < 0) {
            throw new IllegalArgumentException("k must be >= 0");
        }
        if (!this.hasSumOfPowers(k)) {
            return Double.NaN;
        }
        int maxOrder = Math.min(k, this.getMaxOrderForSumOfPowers());
        DoubleArrayList sumOfPows = new DoubleArrayList(maxOrder + 1);
        sumOfPows.add(this.size());
        sumOfPows.add(this.sum());
        sumOfPows.add(this.sumOfSquares());
        for (int i = 3; i <= maxOrder; ++i) {
            sumOfPows.add(this.sumOfPowers(i));
        }
        return DoubleDescriptive.moment(k, c, this.size(), sumOfPows.elements());
    }

    public double product() {
        return DoubleDescriptive.product(this.size(), this.sumOfLogarithms());
    }

    protected void setMaxOrderForSumOfPowers(int max_k) {
        this.sumOfPowers = (double[])(max_k <= 2 ? null : new double[max_k - 2]);
    }

    public synchronized double skew() {
        return DoubleDescriptive.skew(this.moment(3, this.mean()), this.standardDeviation());
    }

    public double sumOfInversions() {
        if (!this.hasSumOfInversions) {
            return Double.NaN;
        }
        return this.sumOfInversions;
    }

    public synchronized double sumOfLogarithms() {
        if (!this.hasSumOfLogarithms) {
            return Double.NaN;
        }
        return this.sumOfLogarithms;
    }

    public synchronized double sumOfPowers(int k) {
        if (!this.hasSumOfPowers(k)) {
            return Double.NaN;
        }
        if (k == -1) {
            return this.sumOfInversions();
        }
        if (k == 0) {
            return this.size();
        }
        if (k == 1) {
            return this.sum();
        }
        if (k == 2) {
            return this.sumOfSquares();
        }
        return this.sumOfPowers[k - 3];
    }

    public synchronized String toString() {
        StringBuffer buf = new StringBuffer(super.toString());
        if (this.hasSumOfLogarithms()) {
            buf.append("Geometric mean: " + this.geometricMean());
            buf.append("\nProduct: " + this.product() + "\n");
        }
        if (this.hasSumOfInversions()) {
            buf.append("Harmonic mean: " + this.harmonicMean());
            buf.append("\nSum of inversions: " + this.sumOfInversions() + "\n");
        }
        int maxOrder = this.getMaxOrderForSumOfPowers();
        int maxPrintOrder = Math.min(6, maxOrder);
        if (maxOrder > 2) {
            int k;
            if (maxOrder >= 3) {
                buf.append("Skew: " + this.skew() + "\n");
            }
            if (maxOrder >= 4) {
                buf.append("Kurtosis: " + this.kurtosis() + "\n");
            }
            for (int i = 3; i <= maxPrintOrder; ++i) {
                buf.append("Sum of powers(" + i + "): " + this.sumOfPowers(i) + "\n");
            }
            for (k = 0; k <= maxPrintOrder; ++k) {
                buf.append("Moment(" + k + ",0): " + this.moment(k, 0.0) + "\n");
            }
            for (k = 0; k <= maxPrintOrder; ++k) {
                buf.append("Moment(" + k + ",mean()): " + this.moment(k, this.mean()) + "\n");
            }
        }
        return buf.toString();
    }

    protected void xcheckOrder(int k) {
    }

    protected boolean xequals(Object object) {
        if (!(object instanceof MightyStaticDoubleBin1D)) {
            return false;
        }
        MightyStaticDoubleBin1D other = (MightyStaticDoubleBin1D)object;
        return super.equals(other) && this.sumOfInversions() == other.sumOfInversions() && this.sumOfLogarithms() == other.sumOfLogarithms();
    }

    protected boolean xhasSumOfPowers(int fromK, int toK) {
        if (fromK > toK) {
            throw new IllegalArgumentException("fromK must be less or equal to toK");
        }
        return this.getMinOrderForSumOfPowers() <= fromK && toK <= this.getMaxOrderForSumOfPowers();
    }

    protected synchronized boolean xisLegalOrder(int k) {
        return this.getMinOrderForSumOfPowers() <= k && k <= this.getMaxOrderForSumOfPowers();
    }
}

