/*
 * Decompiled with CFR 0.152.
 */
package edu.ufl.cise.klu.tdouble;

import edu.ufl.cise.klu.common.KLU_common;
import edu.ufl.cise.klu.common.KLU_numeric;
import edu.ufl.cise.klu.common.KLU_symbolic;
import edu.ufl.cise.klu.tdouble.Dklu_internal;

public class Dklu_extract
extends Dklu_internal {
    public static int klu_extract(KLU_numeric Numeric, KLU_symbolic Symbolic, int[] Lp, int[] Li, double[] Lx, int[] Up, int[] Ui, double[] Ux, int[] Fp, int[] Fi, double[] Fx, int[] P, int[] Q, double[] Rs, int[] R, KLU_common Common) {
        int p;
        int kk;
        double[] LU;
        int nk;
        int k1;
        int k2;
        int nz;
        int k;
        int block;
        int[] len = new int[1];
        int[] Li2_offset = new int[1];
        int[] Lx2_offset = new int[1];
        int[] Ui2_offset = new int[1];
        int[] Ux2_offset = new int[1];
        if (Common == null) {
            return 0;
        }
        if (Symbolic == null || Numeric == null) {
            Common.status = -3;
            return 0;
        }
        Common.status = 0;
        int n = Symbolic.n;
        int nblocks = Symbolic.nblocks;
        if (Rs != null) {
            int i;
            if (Numeric.Rs != null) {
                for (i = 0; i < n; ++i) {
                    Rs[i] = Numeric.Rs[i];
                }
            } else {
                for (i = 0; i < n; ++i) {
                    Rs[i] = 1.0;
                }
            }
        }
        if (R != null) {
            for (block = 0; block <= nblocks; ++block) {
                R[block] = Symbolic.R[block];
            }
        }
        if (P != null) {
            for (k = 0; k < n; ++k) {
                P[k] = Numeric.Pnum[k];
            }
        }
        if (Q != null) {
            for (k = 0; k < n; ++k) {
                Q[k] = Symbolic.Q[k];
            }
        }
        if (Lp != null && Li != null && Lx != null) {
            nz = 0;
            for (block = 0; block < nblocks; ++block) {
                k2 = Symbolic.R[block + 1];
                k1 = Symbolic.R[block];
                nk = k2 - k1;
                if (nk == 1) {
                    Lp[k1] = nz;
                    Li[nz] = k1;
                    Lx[nz] = 1.0;
                    ++nz;
                    continue;
                }
                LU = Numeric.LUbx[block];
                int[] Lip = Numeric.Lip;
                int Lip_offset = k1;
                int[] Llen = Numeric.Llen;
                int Llen_offset = k1;
                for (kk = 0; kk < nk; ++kk) {
                    double[] Lx2;
                    Lp[k1 + kk] = nz;
                    Li[nz] = k1 + kk;
                    Lx[nz] = 1.0;
                    ++nz;
                    double[] Li2 = Lx2 = Dklu_extract.GET_POINTER(LU, Lip, Lip_offset, Llen, Llen_offset, Li2_offset, Lx2_offset, kk, len);
                    for (p = 0; p < len[0]; ++p) {
                        Li[nz] = k1 + (int)Li2[Li2_offset[0] + p];
                        Lx[nz] = Lx2[Lx2_offset[0] + p];
                        ++nz;
                    }
                }
            }
            Lp[n] = nz;
            Dklu_extract.ASSERT(nz == Numeric.lnz);
        }
        if (Up != null && Ui != null && Ux != null) {
            nz = 0;
            for (block = 0; block < nblocks; ++block) {
                k1 = Symbolic.R[block];
                k2 = Symbolic.R[block + 1];
                nk = k2 - k1;
                double[] Ukk = Numeric.Udiag;
                int Ukk_offset = k1;
                if (nk == 1) {
                    Up[k1] = nz;
                    Ui[nz] = k1;
                    Ux[nz] = Ukk[Ukk_offset + 0];
                    ++nz;
                    continue;
                }
                LU = Numeric.LUbx[block];
                int[] Uip = Numeric.Uip;
                int Uip_offset = k1;
                int[] Ulen = Numeric.Ulen;
                int Ulen_offset = k1;
                for (kk = 0; kk < nk; ++kk) {
                    double[] Ux2;
                    Up[k1 + kk] = nz;
                    double[] Ui2 = Ux2 = Dklu_extract.GET_POINTER(LU, Uip, Uip_offset, Ulen, Ulen_offset, Ui2_offset, Ux2_offset, kk, len);
                    for (p = 0; p < len[0]; ++p) {
                        Ui[nz] = k1 + (int)Ui2[Ui2_offset[0] + p];
                        Ux[nz] = Ux2[Ux2_offset[0] + p];
                        ++nz;
                    }
                    Ui[nz] = k1 + kk;
                    Ux[nz] = Ukk[Ukk_offset + kk];
                    ++nz;
                }
            }
            Up[n] = nz;
            Dklu_extract.ASSERT(nz == Numeric.unz);
        }
        if (Fp != null && Fi != null && Fx != null) {
            for (k = 0; k <= n; ++k) {
                Fp[k] = Numeric.Offp[k];
            }
            nz = Fp[n];
            for (k = 0; k < nz; ++k) {
                Fi[k] = Numeric.Offi[k];
            }
            for (k = 0; k < nz; ++k) {
                Fx[k] = Numeric.Offx[k];
            }
        }
        return 1;
    }
}

