/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.test;

import edu.emory.mathcs.jplasma.tdouble.Dplasma;
import org.netlib.blas.Dgemm;
import org.netlib.lapack.Dlange;

public class DgesvTest {
    public static void main(String[] args) {
        int n = 10;
        int i = 0;
        while (i < n) {
            DgesvTest.dgesvTest(args);
            ++i;
        }
    }

    public static void dgesvTest(String[] args) {
        int j;
        if (args.length != 4) {
            System.out.print(" Proper Usage is : java edu.emory.mathcs.jplasma.test.DgesvTest N LDA NRHS LDB with \n - N : the size of the matrix \n - LDA : leading dimension of the matrix A \n - NRHS : number of RHS \n - LDB : leading dimension of the matrix B \n");
            System.exit(1);
        }
        int N = Integer.parseInt(args[0]);
        int LDA = Integer.parseInt(args[1]);
        int NRHS = Integer.parseInt(args[2]);
        int LDB = Integer.parseInt(args[3]);
        double[] A1 = new double[LDA * N];
        double[] A2 = new double[LDA * N];
        double[] B1 = new double[LDB * NRHS];
        double[] B2 = new double[LDB * NRHS];
        Dplasma.plasma_Init(N, N, NRHS);
        int i = 0;
        while (i < N) {
            j = 0;
            while (j < N) {
                double d = 0.5 - Math.random();
                A2[LDA * j + i] = d;
                A1[LDA * j + i] = d;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            j = 0;
            while (j < NRHS) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
                ++j;
            }
            ++i;
        }
        double[] L = Dplasma.plasma_Allocate_L(N, N);
        int[] IPIV = Dplasma.plasma_Allocate_IPIV(N, N);
        Dplasma.plasma_DGESV(N, NRHS, A2, 0, LDA, L, 0, IPIV, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        double eps = 1.0E-10;
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGESV ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", N, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        int info_solution = DgesvTest.check_solution(N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGESV ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGESV ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        i = 0;
        while (i < N) {
            j = 0;
            while (j < N) {
                double d = 0.5 - Math.random();
                A2[LDA * i + j] = d;
                A1[LDA * i + j] = d;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            j = 0;
            while (j < NRHS) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
                ++j;
            }
            ++i;
        }
        Dplasma.plasma_Init(N, N, NRHS);
        L = Dplasma.plasma_Allocate_L(N, N);
        IPIV = Dplasma.plasma_Allocate_IPIV(N, N);
        Dplasma.plasma_DGETRF(N, N, A2, 0, LDA, L, 0, IPIV, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DGETRS(N, NRHS, N, A2, 0, LDA, L, 0, IPIV, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGETRF + DGETRS ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", N, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        info_solution = DgesvTest.check_solution(N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DGETRS ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DGETRS ... FAILED !\n");
            System.out.print("************************************************\n");
        }
        i = 0;
        while (i < N) {
            j = 0;
            while (j < N) {
                double d = 0.5 - Math.random();
                A2[LDA * i + j] = d;
                A1[LDA * i + j] = d;
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < N) {
            j = 0;
            while (j < NRHS) {
                double d = 0.5 - Math.random();
                B2[LDB * j + i] = d;
                B1[LDB * j + i] = d;
                ++j;
            }
            ++i;
        }
        Dplasma.plasma_Init(N, N, NRHS);
        L = Dplasma.plasma_Allocate_L(N, N);
        IPIV = Dplasma.plasma_Allocate_IPIV(N, N);
        Dplasma.plasma_DGETRF(N, N, A2, 0, LDA, L, 0, IPIV, 0);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DTRSMPL(N, NRHS, N, A2, 0, LDA, L, 0, IPIV, 0, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        Dplasma.plasma_Init(N, N, NRHS);
        Dplasma.plasma_DTRSM(141, 121, 111, 131, N, NRHS, A2, 0, LDA, B2, 0, LDB);
        Dplasma.plasma_Finalize();
        System.out.print("\n");
        System.out.print("------ TESTS FOR PLASMA DGETRF + DTRSMPL + DTRSM  ROUTINE -------  \n");
        System.out.print(String.format("            Size of the Matrix %d by %d\n", N, N));
        System.out.print("\n");
        System.out.print(" The matrix A is randomly generated for each test.\n");
        System.out.print("============\n");
        System.out.print(String.format(" The relative machine precision (eps) is to be %e \n", eps));
        System.out.print(" Computational tests pass if scaled residuals are less than 10.\n");
        info_solution = DgesvTest.check_solution(N, NRHS, A1, LDA, B1, B2, LDB, eps);
        if (info_solution == 0) {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DTRSMPL + DTRSM ... PASSED !\n");
            System.out.print("************************************************\n");
        } else {
            System.out.print("************************************************\n");
            System.out.print(" ---- TESTING DGETRF + DTRSMPL + DTRSM ... FAILED !\n");
            System.out.print("************************************************\n");
        }
    }

    private static int check_solution(int N, int NRHS, double[] A1, int LDA, double[] B1, double[] B2, int LDB, double eps) {
        int info_solution;
        String norm = "I";
        double[] work = new double[N];
        double alpha = 1.0;
        double beta = -1.0;
        double Xnorm = Dlange.dlange(norm, N, NRHS, B2, 0, LDB, work, 0);
        double Anorm = Dlange.dlange(norm, N, N, A1, 0, LDA, work, 0);
        double Bnorm = Dlange.dlange(norm, N, NRHS, B1, 0, LDB, work, 0);
        Dgemm.dgemm("N", "N", N, NRHS, N, alpha, A1, 0, LDA, B2, 0, LDB, beta, B1, 0, LDB);
        double Rnorm = Dlange.dlange(norm, N, NRHS, B1, 0, LDB, work, 0);
        System.out.print("============\n");
        System.out.print("Checking the Residual of the solution \n");
        System.out.print(String.format("-- ||Ax-B||_oo/((||A||_oo||x||_oo+||B||_oo).N.eps) = %e \n", Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps)));
        if (Rnorm / ((Anorm * Xnorm + Bnorm) * (double)N * eps) > 10.0) {
            System.out.print("-- The solution is suspicious ! \n");
            info_solution = 1;
        } else {
            System.out.print("-- The solution is CORRECT ! \n");
            info_solution = 0;
        }
        return info_solution;
    }
}

