/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.jplasma.tdouble;

class DbdlConvert {
    private DbdlConvert() {
    }

    protected static void plasma_lapack_to_bdl(double[] Af77, int Af77_offset, double[] Abdl, int Abdl_offset, int M, int N, int LDA, int NB, int MT, int NT, int NBNBSIZE, int cores_num, int my_core_id) {
        int n = 0;
        int m = my_core_id;
        while (m >= MT && n < NT) {
            ++n;
            m -= MT;
        }
        while (n < NT) {
            int next_m = m;
            int next_n = n;
            next_m += cores_num;
            while (next_m >= MT && next_n < NT) {
                ++next_n;
                next_m -= MT;
            }
            int X = n == NT - 1 ? N - NB * n : NB;
            int Y = m == MT - 1 ? M - NB * m : NB;
            int F77_offset = Af77_offset + NB * (LDA * n + m);
            int BDL_offset = Abdl_offset + NBNBSIZE * (MT * n + m);
            int x = 0;
            while (x < X) {
                int y = 0;
                while (y < Y) {
                    Abdl[BDL_offset + NB * x + y] = Af77[F77_offset + LDA * x + y];
                    ++y;
                }
                ++x;
            }
            m = next_m;
            n = next_n;
        }
    }

    protected static void plasma_bdl_to_lapack(double[] Abdl, int Abdl_offset, double[] Af77, int Af77_offset, int M, int N, int LDA, int NB, int MT, int NT, int NBNBSIZE, int cores_num, int my_core_id) {
        int n = 0;
        int m = my_core_id;
        while (m >= MT && n < NT) {
            ++n;
            m -= MT;
        }
        while (n < NT) {
            int next_m = m;
            int next_n = n;
            next_m += cores_num;
            while (next_m >= MT && next_n < NT) {
                ++next_n;
                next_m -= MT;
            }
            int X = n == NT - 1 ? N - NB * n : NB;
            int Y = m == MT - 1 ? M - NB * m : NB;
            int F77_offset = Af77_offset + NB * (LDA * n + m);
            int BDL_offset = Abdl_offset + NBNBSIZE * (MT * n + m);
            int x = 0;
            while (x < X) {
                int y = 0;
                while (y < Y) {
                    Af77[F77_offset + LDA * x + y] = Abdl[BDL_offset + NB * x + y];
                    ++y;
                }
                ++x;
            }
            m = next_m;
            n = next_n;
        }
    }
}

