/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.csparsej.tdcomplex;

import edu.emory.mathcs.csparsej.tdcomplex.DZcs_add;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_common;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_complex;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_fkeep;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_ifkeep;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_multiply;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_tdfs;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_transpose;
import edu.emory.mathcs.csparsej.tdcomplex.DZcs_util;

public class DZcs_amd {
    private static int cs_wclear(int mark, int lemax, int[] w, int w_offset, int n) {
        if (mark < 2 || mark + lemax < 0) {
            for (int k = 0; k < n; ++k) {
                if (w[w_offset + k] == 0) continue;
                w[w_offset + k] = 1;
            }
            mark = 2;
        }
        return mark;
    }

    public static int[] cs_amd(int order, DZcs_common.DZcs A) {
        int e;
        int d;
        int i;
        int k;
        int p;
        int j;
        int p2;
        DZcs_common.DZcs C;
        int lemax = 0;
        int mindeg = 0;
        int nel = 0;
        if (!DZcs_util.CS_CSC(A) || order <= 0 || order > 3) {
            return null;
        }
        DZcs_common.DZcs AT = DZcs_transpose.cs_transpose(A, false);
        if (AT == null) {
            return null;
        }
        int m = A.m;
        int n = A.n;
        int dense = Math.max(16, 10 * (int)Math.sqrt(n));
        dense = Math.min(n - 2, dense);
        if (order == 1 && n == m) {
            C = DZcs_add.cs_add(A, AT, DZcs_complex.cs_czero(), DZcs_complex.cs_czero());
        } else if (order == 2) {
            int[] ATp = AT.p;
            int[] ATi = AT.i;
            p2 = 0;
            for (j = 0; j < m; ++j) {
                ATp[j] = p2;
                if (ATp[j + 1] - p > dense) continue;
                for (p = ATp[j]; p < ATp[j + 1]; ++p) {
                    ATi[p2++] = ATi[p];
                }
            }
            ATp[m] = p2;
            DZcs_common.DZcs A2 = DZcs_transpose.cs_transpose(AT, false);
            C = A2 != null ? DZcs_multiply.cs_multiply(AT, A2) : null;
            A2 = null;
        } else {
            C = DZcs_multiply.cs_multiply(AT, A);
        }
        AT = null;
        if (C == null) {
            return null;
        }
        DZcs_fkeep.cs_fkeep(C, new Cs_diag(), null);
        int[] Cp = C.p;
        int cnz = Cp[n];
        int[] P = new int[n + 1];
        int[] W = new int[8 * (n + 1)];
        int t = cnz + cnz / 5 + 2 * n;
        if (P == null || W == null || !DZcs_util.cs_sprealloc(C, t)) {
            return DZcs_util.cs_idone(P, C, W, false);
        }
        int[] len = W;
        int[] nv = W;
        int nv_offset = n + 1;
        int[] next = W;
        int next_offset = 2 * (n + 1);
        int[] head = W;
        int head_offset = 3 * (n + 1);
        int[] elen = W;
        int elen_offset = 4 * (n + 1);
        int[] degree = W;
        int degree_offset = 5 * (n + 1);
        int[] w = W;
        int w_offset = 6 * (n + 1);
        int[] hhead = W;
        int hhead_offset = 7 * (n + 1);
        int[] last = P;
        for (k = 0; k < n; ++k) {
            len[k] = Cp[k + 1] - Cp[k];
        }
        len[n] = 0;
        int nzmax = C.nzmax;
        int[] Ci = C.i;
        for (i = 0; i <= n; ++i) {
            head[head_offset + i] = -1;
            last[i] = -1;
            next[next_offset + i] = -1;
            hhead[hhead_offset + i] = -1;
            nv[nv_offset + i] = 1;
            w[w_offset + i] = 1;
            elen[elen_offset + i] = 0;
            degree[degree_offset + i] = len[i];
        }
        int mark = DZcs_amd.cs_wclear(0, 0, w, w_offset, n);
        elen[elen_offset + n] = -2;
        Cp[n] = -1;
        w[w_offset + n] = 0;
        for (i = 0; i < n; ++i) {
            d = degree[degree_offset + i];
            if (d == 0) {
                elen[elen_offset + i] = -2;
                ++nel;
                Cp[i] = -1;
                w[w_offset + i] = 0;
                continue;
            }
            if (d > dense) {
                nv[nv_offset + i] = 0;
                elen[elen_offset + i] = -1;
                ++nel;
                Cp[i] = DZcs_util.CS_FLIP(n);
                int n2 = nv_offset + n;
                nv[n2] = nv[n2] + 1;
                continue;
            }
            if (head[head_offset + d] != -1) {
                last[head[head_offset + d]] = i;
            }
            next[next_offset + i] = head[head_offset + d];
            head[head_offset + d] = i;
        }
        while (nel < n) {
            int h;
            int eln;
            int pk;
            int nvi;
            int ln;
            int pk1;
            k = -1;
            while (mindeg < n && (k = head[head_offset + mindeg]) == -1) {
                ++mindeg;
            }
            if (next[next_offset + k] != -1) {
                last[next[next_offset + k]] = -1;
            }
            head[head_offset + mindeg] = next[next_offset + k];
            int elenk = elen[elen_offset + k];
            int nvk = nv[nv_offset + k];
            nel += nvk;
            if (elenk > 0 && cnz + mindeg >= nzmax) {
                for (j = 0; j < n; ++j) {
                    p = Cp[j];
                    if (p < 0) continue;
                    Cp[j] = Ci[p];
                    Ci[p] = DZcs_util.CS_FLIP(j);
                }
                int q = 0;
                p = 0;
                while (p < cnz) {
                    if ((j = DZcs_util.CS_FLIP(Ci[p++])) < 0) continue;
                    Ci[q] = Cp[j];
                    Cp[j] = q++;
                    for (int k3 = 0; k3 < len[j] - 1; ++k3) {
                        Ci[q++] = Ci[p++];
                    }
                }
                cnz = q;
            }
            int dk = 0;
            nv[nv_offset + k] = -nvk;
            p = Cp[k];
            int pk2 = pk1 = elenk == 0 ? p : cnz;
            for (int k1 = 1; k1 <= elenk + 1; ++k1) {
                int pj;
                if (k1 > elenk) {
                    e = k;
                    pj = p;
                    ln = len[k] - elenk;
                } else {
                    e = Ci[p++];
                    pj = Cp[e];
                    ln = len[e];
                }
                for (int k2 = 1; k2 <= ln; ++k2) {
                    if ((nvi = nv[nv_offset + (i = Ci[pj++])]) <= 0) continue;
                    dk += nvi;
                    nv[nv_offset + i] = -nvi;
                    Ci[pk2++] = i;
                    if (next[next_offset + i] != -1) {
                        last[next[next_offset + i]] = last[i];
                    }
                    if (last[i] != -1) {
                        next[next_offset + last[i]] = next[next_offset + i];
                        continue;
                    }
                    head[head_offset + degree[degree_offset + i]] = next[next_offset + i];
                }
                if (e == k) continue;
                Cp[e] = DZcs_util.CS_FLIP(k);
                w[w_offset + e] = 0;
            }
            if (elenk != 0) {
                cnz = pk2;
            }
            degree[degree_offset + k] = dk;
            Cp[k] = pk1;
            len[k] = pk2 - pk1;
            elen[elen_offset + k] = -2;
            mark = DZcs_amd.cs_wclear(mark, lemax, w, w_offset, n);
            for (pk = pk1; pk < pk2; ++pk) {
                i = Ci[pk];
                eln = elen[elen_offset + i];
                if (eln <= 0) continue;
                nvi = -nv[nv_offset + i];
                int wnvi = mark - nvi;
                for (p = Cp[i]; p <= Cp[i] + eln - 1; ++p) {
                    e = Ci[p];
                    if (w[w_offset + e] >= mark) {
                        int n3 = w_offset + e;
                        w[n3] = w[n3] - nvi;
                        continue;
                    }
                    if (w[w_offset + e] == 0) continue;
                    w[w_offset + e] = degree[degree_offset + e] + wnvi;
                }
            }
            for (pk = pk1; pk < pk2; ++pk) {
                i = Ci[pk];
                int p1 = Cp[i];
                p2 = p1 + elen[elen_offset + i] - 1;
                int pn = p1;
                h = 0;
                d = 0;
                for (p = p1; p <= p2; ++p) {
                    e = Ci[p];
                    if (w[w_offset + e] == 0) continue;
                    int dext = w[w_offset + e] - mark;
                    if (dext > 0) {
                        d += dext;
                        Ci[pn++] = e;
                        h += e;
                        continue;
                    }
                    Cp[e] = DZcs_util.CS_FLIP(k);
                    w[w_offset + e] = 0;
                }
                elen[elen_offset + i] = pn - p1 + 1;
                int p3 = pn;
                int p4 = p1 + len[i];
                for (p = p2 + 1; p < p4; ++p) {
                    j = Ci[p];
                    int nvj = nv[nv_offset + j];
                    if (nvj <= 0) continue;
                    d += nvj;
                    Ci[pn++] = j;
                    h += j;
                }
                if (d == 0) {
                    Cp[i] = DZcs_util.CS_FLIP(k);
                    nvi = -nv[nv_offset + i];
                    dk -= nvi;
                    nvk += nvi;
                    nel += nvi;
                    nv[nv_offset + i] = 0;
                    elen[elen_offset + i] = -1;
                    continue;
                }
                degree[degree_offset + i] = Math.min(degree[degree_offset + i], d);
                Ci[pn] = Ci[p3];
                Ci[p3] = Ci[p1];
                Ci[p1] = k;
                len[i] = pn - p1 + 1;
                next[next_offset + i] = hhead[hhead_offset + (h %= n)];
                hhead[hhead_offset + h] = i;
                last[i] = h;
            }
            degree[degree_offset + k] = dk;
            lemax = Math.max(lemax, dk);
            mark = DZcs_amd.cs_wclear(mark + lemax, lemax, w, w_offset, n);
            for (pk = pk1; pk < pk2; ++pk) {
                i = Ci[pk];
                if (nv[nv_offset + i] >= 0) continue;
                h = last[i];
                i = hhead[hhead_offset + h];
                hhead[hhead_offset + h] = -1;
                while (i != -1 && next[next_offset + i] != -1) {
                    ln = len[i];
                    eln = elen[elen_offset + i];
                    for (p = Cp[i] + 1; p <= Cp[i] + ln - 1; ++p) {
                        w[w_offset + Ci[p]] = mark;
                    }
                    int jlast = i;
                    j = next[next_offset + i];
                    while (j != -1) {
                        boolean ok = len[j] == ln && elen[elen_offset + j] == eln;
                        for (p = Cp[j] + 1; ok && p <= Cp[j] + ln - 1; ++p) {
                            if (w[w_offset + Ci[p]] == mark) continue;
                            ok = false;
                        }
                        if (ok) {
                            Cp[j] = DZcs_util.CS_FLIP(i);
                            int n4 = nv_offset + i;
                            nv[n4] = nv[n4] + nv[nv_offset + j];
                            nv[nv_offset + j] = 0;
                            elen[elen_offset + j] = -1;
                            next[next_offset + jlast] = j = next[next_offset + j];
                            continue;
                        }
                        jlast = j;
                        j = next[next_offset + j];
                    }
                    i = next[next_offset + i];
                    ++mark;
                }
            }
            p = pk1;
            for (pk = pk1; pk < pk2; ++pk) {
                i = Ci[pk];
                nvi = -nv[nv_offset + i];
                if (nvi <= 0) continue;
                nv[nv_offset + i] = nvi;
                d = degree[degree_offset + i] + dk - nvi;
                if (head[head_offset + (d = Math.min(d, n - nel - nvi))] != -1) {
                    last[head[head_offset + d]] = i;
                }
                next[next_offset + i] = head[head_offset + d];
                last[i] = -1;
                head[head_offset + d] = i;
                mindeg = Math.min(mindeg, d);
                degree[degree_offset + i] = d;
                Ci[p++] = i;
            }
            nv[nv_offset + k] = nvk;
            len[k] = p - pk1;
            if (len[k] == 0) {
                Cp[k] = -1;
                w[w_offset + k] = 0;
            }
            if (elenk == 0) continue;
            cnz = p;
        }
        for (i = 0; i < n; ++i) {
            Cp[i] = DZcs_util.CS_FLIP(Cp[i]);
        }
        for (j = 0; j <= n; ++j) {
            head[head_offset + j] = -1;
        }
        for (j = n; j >= 0; --j) {
            if (nv[nv_offset + j] > 0) continue;
            next[next_offset + j] = head[head_offset + Cp[j]];
            head[head_offset + Cp[j]] = j;
        }
        for (e = n; e >= 0; --e) {
            if (nv[nv_offset + e] <= 0 || Cp[e] == -1) continue;
            next[next_offset + e] = head[head_offset + Cp[e]];
            head[head_offset + Cp[e]] = e;
        }
        k = 0;
        for (i = 0; i <= n; ++i) {
            if (Cp[i] != -1) continue;
            k = DZcs_tdfs.cs_tdfs(i, k, head, head_offset, next, next_offset, P, 0, w, w_offset);
        }
        return DZcs_util.cs_idone(P, C, W, true);
    }

    private static class Cs_diag
    implements DZcs_ifkeep {
        private Cs_diag() {
        }

        public boolean fkeep(int i, int j, double[] aij, Object other) {
            return i != j;
        }
    }
}

