/*
 * Decompiled with CFR 0.152.
 */
package ch.akuhn.edu.mit.tedlab;

import ch.akuhn.edu.mit.tedlab.DMat;
import ch.akuhn.edu.mit.tedlab.SMat;
import ch.akuhn.edu.mit.tedlab.SVDRec;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Random;
import java.util.Scanner;

public class Svdlib {
    String SVDVersion = "1.34";
    long SVDVerbosity = 0L;
    static int MAXLL = 2;
    static String[] error_msg = new String[]{null, "", "ENDL MUST BE LESS THAN ENDR", "REQUESTED DIMENSIONS CANNOT EXCEED NUM ITERATIONS", "ONE OF YOUR DIMENSIONS IS LESS THAN OR EQUAL TO ZERO", "NUM ITERATIONS (NUMBER OF LANCZOS STEPS) IS INVALID", "REQUESTED DIMENSIONS (NUMBER OF EIGENPAIRS DESIRED) IS INVALID", "6*N+4*ITERATIONS+1 + ITERATIONS*ITERATIONS CANNOT EXCEED NW", "6*N+4*ITERATIONS+1 CANNOT EXCEED NW", null};
    double[][] LanStore;
    double[] OPBTemp;
    double eps;
    double eps1;
    double reps;
    double eps34;
    long ierr;

    static long[] svd_longArray(int size, boolean empty, String name) {
        return new long[size];
    }

    static double[] svd_doubleArray(int size, boolean empty, String name) {
        return new double[size];
    }

    static void svd_beep() {
        System.err.print('\n');
    }

    static void svd_debug(String fmt, Object ... args) {
        System.err.printf(fmt, args);
    }

    static void svd_error(String fmt, Object ... args) {
        Svdlib.svd_beep();
        System.err.print("ERROR: ");
        System.err.printf(fmt, args);
        System.err.println();
    }

    static void svd_fatalError(String fmt, Object ... args) {
        Svdlib.svd_error(fmt, args);
        System.exit(1);
    }

    static double svd_fsign(double a, double b) {
        if (a >= 0.0 && b >= 0.0 || a < 0.0 && b < 0.0) {
            return a;
        }
        return -a;
    }

    static double svd_dmax(double a, double b) {
        return Math.max(a, b);
    }

    static double svd_dmin(double a, double b) {
        return Math.min(a, b);
    }

    static int svd_imax(int a, int b) {
        return Math.max(a, b);
    }

    static int svd_imin(int a, int b) {
        return Math.min(a, b);
    }

    static void svd_dscal(int n, double da, double[] dx, int incx) {
        if (n <= 0 || incx == 0) {
            return;
        }
        int ix = incx < 0 ? n - 1 : 0;
        for (int i = 0; i < n; ++i) {
            int n2 = ix;
            dx[n2] = dx[n2] * da;
            ix += incx;
        }
    }

    static void svd_datx(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        assert (incx == 1 || incx == -1 || incx == 0);
        assert (incy == 1 || incy == -1 || incy == 0);
        if (n <= 0 || incx == 0 || incy == 0) {
            return;
        }
        int ix = incx == 1 ? 0 : n - 1;
        int iy = incy == 1 ? 0 : n - 1;
        for (int i = 0; i < n; ++i) {
            dy[iy] = da * dx[ix];
            iy += incy;
            ix += incx;
        }
    }

    static void svd_dcopy(int n, double[] dx, int incx, double[] dy, int incy) {
        Svdlib.svd_dcopy(n, dx, 0, incx, dy, 0, incy);
    }

    static void svd_dcopy(int n, double[] dx, int ix0, int incx, double[] dy, int iy0, int incy) {
        assert (incx == 1 || incx == -1 || incx == 0);
        assert (incy == 1 || incy == -1 || incy == 0);
        if (n <= 0 || incx == 0 || incy == 0) {
            return;
        }
        int ix = incx == 1 ? ix0 : n - 1 + ix0;
        int iy = incy == 1 ? iy0 : n - 1 + iy0;
        for (int i = 0; i < n; ++i) {
            dy[iy] = dx[ix];
            iy += incy;
            ix += incx;
        }
    }

    static double svd_ddot(int n, double[] dx, int incx, double[] dy, int incy) {
        double dot_product = 0.0;
        int ix0 = 0;
        int iy0 = 0;
        assert (incx == 1 || incx == -1 || incx == 0);
        assert (incy == 1 || incy == -1 || incy == 0);
        if (n <= 0 || incx == 0 || incy == 0) {
            return 0.0;
        }
        int ix = incx == 1 ? ix0 : n - 1 + ix0;
        int iy = incy == 1 ? iy0 : n - 1 + iy0;
        for (int i = 0; i < n; ++i) {
            dot_product += dy[iy] * dx[ix];
            iy += incy;
            ix += incx;
        }
        return dot_product;
    }

    static void svd_daxpy(int n, double da, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0 || incx == 0 || incy == 0) {
            return;
        }
        int ix = incx == 1 ? 0 : n - 1;
        int iy = incy == 1 ? 0 : n - 1;
        for (int i = 0; i < n; ++i) {
            int n2 = iy;
            dy[n2] = dy[n2] + da * dx[ix];
            iy += incy;
            ix += incx;
        }
    }

    static void svd_dsort2(int igap, int n, double[] array1, double[] array2) {
        if (0 == igap) {
            return;
        }
        for (int i = igap; i < n; ++i) {
            int j = i - igap;
            int index = i;
            while (j >= 0 && array1[j] > array1[index]) {
                double temp = array1[j];
                array1[j] = array1[index];
                array1[index] = temp;
                temp = array2[j];
                array2[j] = array2[index];
                array2[index] = temp;
                index = (j -= igap) + igap;
            }
        }
        Svdlib.svd_dsort2(igap / 2, n, array1, array2);
    }

    static void svd_dswap(int n, double[] dx, int incx, double[] dy, int incy) {
        if (n <= 0 || incx == 0 || incy == 0) {
            return;
        }
        int ix = incx == 1 ? 0 : n - 1;
        int iy = incy == 1 ? 0 : n - 1;
        for (int i = 0; i < n; ++i) {
            double swap = dy[iy];
            dy[iy] = dx[ix];
            dx[ix] = swap;
            iy += incy;
            ix += incx;
        }
    }

    static int svd_idamax(int n, double[] dx, int ix0, int incx) {
        int ix;
        if (n < 1) {
            return -1;
        }
        if (n == 1) {
            return 0;
        }
        if (incx == 0) {
            return -1;
        }
        int imax = ix = incx < 0 ? ix0 + (-n + 1) * incx : ix0;
        double dmax = Svdlib.fabs(dx[ix]);
        for (int i = 1; i < n; ++i) {
            double dtemp = Svdlib.fabs(dx[ix += incx]);
            if (!(dtemp > dmax)) continue;
            dmax = dtemp;
            imax = ix;
        }
        return imax;
    }

    static void svd_opb(SMat A, double[] x, double[] y, double[] temp) {
        int j;
        int end;
        int i;
        int[] pointr = A.pointr;
        int[] rowind = A.rowind;
        double[] value = A.value;
        int n = A.cols;
        for (i = 0; i < n; ++i) {
            y[i] = 0.0;
        }
        for (i = 0; i < A.rows; ++i) {
            temp[i] = 0.0;
        }
        for (i = 0; i < A.cols; ++i) {
            end = pointr[i + 1];
            for (j = pointr[i]; j < end; ++j) {
                int n2 = rowind[j];
                temp[n2] = temp[n2] + value[j] * x[i];
            }
        }
        for (i = 0; i < A.cols; ++i) {
            end = pointr[i + 1];
            for (j = pointr[i]; j < end; ++j) {
                int n3 = i;
                y[n3] = y[n3] + value[j] * temp[rowind[j]];
            }
        }
    }

    static void svd_opa(SMat A, double[] x, double[] y) {
        int i;
        int[] pointr = A.pointr;
        int[] rowind = A.rowind;
        double[] value = A.value;
        for (i = 0; i < A.rows; ++i) {
            y[i] = 0.0;
        }
        for (i = 0; i < A.cols; ++i) {
            int end = pointr[i + 1];
            for (int j = pointr[i]; j < end; ++j) {
                int n = rowind[j];
                y[n] = y[n] + value[j] * x[i];
            }
        }
    }

    static double svd_random2(long[] iy) {
        throw null;
    }

    static double svd_pythag(double a, double b) {
        double p = Svdlib.svd_dmax(Math.abs(a), Math.abs(b));
        if (p != 0.0) {
            double temp = Svdlib.svd_dmin(Math.abs(a), Math.abs(b)) / p;
            double r = temp * temp;
            double t = 4.0 + r;
            while (t != 4.0) {
                double s = r / t;
                double u = 1.0 + 2.0 * s;
                p *= u;
                temp = s / u;
                t = 4.0 + (r *= temp * temp);
            }
        }
        return p;
    }

    static void svdResetCounters() {
        throw null;
    }

    static DMat svdConvertStoD(SMat S) {
        throw null;
    }

    public static SMat svdConvertDtoS(DMat D) {
        int j;
        int i;
        int n = 0;
        for (i = 0; i < D.rows; ++i) {
            for (j = 0; j < D.cols; ++j) {
                if (D.value[i][j] == 0.0) continue;
                ++n;
            }
        }
        SMat S = new SMat(D.rows, D.cols, n);
        n = 0;
        for (j = 0; j < D.cols; ++j) {
            S.pointr[j] = n;
            for (i = 0; i < D.rows; ++i) {
                if (D.value[i][j] == 0.0) continue;
                S.rowind[n] = i;
                S.value[n] = D.value[i][j];
                ++n;
            }
        }
        S.pointr[S.cols] = S.vals;
        return S;
    }

    static DMat svdTransposeD(DMat D) {
        DMat N = new DMat(D.cols, D.rows);
        for (int r = 0; r < D.rows; ++r) {
            for (int c = 0; c < D.cols; ++c) {
                N.value[c][r] = D.value[r][c];
            }
        }
        return N;
    }

    static SMat svdTransposeS(SMat S) {
        int r;
        int i;
        SMat N = new SMat(S.cols, S.rows, S.vals);
        for (i = 0; i < S.vals; ++i) {
            int n = S.rowind[i];
            N.pointr[n] = N.pointr[n] + 1;
        }
        N.pointr[S.rows] = S.vals - N.pointr[S.rows - 1];
        for (r = S.rows - 1; r > 0; --r) {
            N.pointr[r] = N.pointr[r + 1] - N.pointr[r - 1];
        }
        N.pointr[0] = 0;
        i = 0;
        for (int c = 0; c < S.cols; ++c) {
            while (i < S.pointr[c + 1]) {
                r = S.rowind[i];
                int n = r + 1;
                N.pointr[n] = N.pointr[n] + 1;
                N.rowind[j] = c;
                N.value[j] = S.value[i];
                ++i;
            }
        }
        return N;
    }

    static int check_parameters(SMat A, long dimensions, long iterations, double endl, double endr, boolean b) {
        int error_index = 0;
        if (endl > endr) {
            error_index = 2;
        } else if (dimensions > iterations) {
            error_index = 3;
        } else if (A.cols <= 0 || A.rows <= 0) {
            error_index = 4;
        } else if (iterations <= 0L || iterations > (long)A.cols || iterations > (long)A.rows) {
            error_index = 5;
        } else if (dimensions <= 0L || dimensions > iterations) {
            error_index = 6;
        }
        if (0 != error_index) {
            Svdlib.svd_error("svdLAS2 parameter error: %s\n", error_msg[error_index]);
        }
        return error_index;
    }

    void write_header(long iterations, long dimensions, double endl, double endr, boolean b, double kappa, long nrow, long ncol, long vals) {
        Svdlib.printf("SOLVING THE [A^TA] EIGENPROBLEM\n", new Object[0]);
        Svdlib.printf("NO. OF ROWS               = %6d\n", nrow);
        Svdlib.printf("NO. OF COLUMNS            = %6d\n", ncol);
        Svdlib.printf("NO. OF NON-ZERO VALUES    = %6d\n", vals);
        Svdlib.printf("MATRIX DENSITY            = %6.2f%%\n", Float.valueOf((float)vals / (float)nrow * 100.0f / (float)ncol));
        Svdlib.printf("MAX. NO. OF LANCZOS STEPS = %6d\n", iterations);
        Svdlib.printf("MAX. NO. OF EIGENPAIRS    = %6d\n", dimensions);
        Svdlib.printf("LEFT  END OF THE INTERVAL = %9.2E\n", endl);
        Svdlib.printf("RIGHT END OF THE INTERVAL = %9.2E\n", endr);
        Svdlib.printf("KAPPA                     = %9.2E\n", kappa);
        Svdlib.printf("\n", new Object[0]);
    }

    static void printf(String fmt, Object ... args) {
        System.out.printf(fmt, args);
    }

    static void fake_memset_127(double[] a) {
        double d = Double.longBitsToDouble(0x7F7F7F7F7F7F7F7FL);
        for (int n = 0; n < a.length; ++n) {
            a[n] = d;
        }
    }

    public SVDRec svdLAS2A(SMat A, int dimensions) {
        double[] end = new double[]{-1.0E-30, 1.0E-30};
        double kappa = 1.0E-6;
        if (A == null) {
            Svdlib.svd_error("svdLAS2A called with NULL array\n", new Object[0]);
            return null;
        }
        return this.svdLAS2(A, dimensions, 0, end, kappa);
    }

    public SVDRec svdLAS2(SMat A, int dimensions, int iterations, double[] end, double kappa) {
        boolean transpose = false;
        double[][] wptr = new double[10][];
        SVDRec R = null;
        int m = Svdlib.svd_imin(A.rows, A.cols);
        if (dimensions <= 0 || dimensions > m) {
            dimensions = m;
        }
        if (iterations <= 0 || iterations > m) {
            iterations = m;
        }
        if (iterations < dimensions) {
            iterations = dimensions;
        }
        if (this.SVDVerbosity > 0L) {
            this.write_header(iterations, dimensions, end[0], end[1], true, kappa, A.rows, A.cols, A.vals);
        }
        if (0 != Svdlib.check_parameters(A, dimensions, iterations, end[0], end[1], true)) {
            if (A.rows == 0 || A.cols == 0) {
                R = new SVDRec();
                R.S = new double[0];
                R.Ut = new DMat(0, A.rows);
                R.Vt = new DMat(0, A.cols);
                return R;
            }
            return null;
        }
        if ((double)A.cols >= (double)A.rows * 1.2) {
            if (this.SVDVerbosity > 0L) {
                Svdlib.printf("TRANSPOSING THE MATRIX FOR SPEED\n", new Object[0]);
            }
            transpose = true;
            A = Svdlib.svdTransposeS(A);
        }
        int n = A.cols;
        this.machar();
        this.eps1 = this.eps * Math.sqrt(n);
        this.reps = Math.sqrt(this.eps);
        this.eps34 = this.reps * Math.sqrt(this.reps);
        wptr[0] = new double[n];
        wptr[1] = new double[n];
        wptr[2] = new double[n];
        wptr[3] = new double[n];
        wptr[4] = new double[n];
        wptr[5] = new double[n];
        wptr[6] = new double[iterations];
        wptr[7] = new double[iterations];
        wptr[8] = new double[iterations];
        wptr[9] = new double[iterations + 1];
        double[] ritz = new double[iterations + 1];
        double[] bnd = new double[iterations + 1];
        Svdlib.fake_memset_127(bnd);
        this.LanStore = new double[iterations + MAXLL][];
        this.OPBTemp = Svdlib.svd_doubleArray(A.rows, false, "las2: OPBTemp");
        int[] ref_neig = new int[]{0};
        int steps = this.lanso(A, iterations, dimensions, end[0], end[1], ritz, bnd, wptr, ref_neig, n);
        int neig = ref_neig[0];
        if (this.SVDVerbosity > 0L) {
            Svdlib.printf("NUMBER OF LANCZOS STEPS   = %6d\nRITZ VALUES STABILIZED    = %6d\n", steps + 1, neig);
        }
        if (this.SVDVerbosity > 2L) {
            Svdlib.printf("\nCOMPUTED RITZ VALUES  (ERROR BNDS)\n", new Object[0]);
            for (int i = 0; i <= steps; ++i) {
                Svdlib.printf("%3d  %22.14E  (%11.2E)\n", i + 1, ritz[i], bnd[i]);
            }
        }
        wptr[0] = null;
        wptr[1] = null;
        wptr[2] = null;
        wptr[3] = null;
        wptr[4] = null;
        wptr[7] = null;
        wptr[8] = null;
        kappa = Svdlib.svd_dmax(Svdlib.fabs(kappa), this.eps34);
        R = new SVDRec();
        R.d = dimensions;
        R.Ut = new DMat(R.d, A.rows);
        R.S = Svdlib.svd_doubleArray(R.d, true, "las2: R->s");
        R.Vt = new DMat(R.d, A.cols);
        this.ritvec(n, A, R, kappa, ritz, bnd, wptr[6], wptr[9], wptr[5], steps, neig);
        if (this.SVDVerbosity > 1L) {
            Svdlib.printf("\nSINGULAR VALUES: ", new Object[0]);
            Svdlib.svdWriteDenseArray(R.S, R.d, "-", false);
            if (this.SVDVerbosity > 2L) {
                Svdlib.printf("\nLEFT SINGULAR VECTORS (transpose of U): ", new Object[0]);
                Svdlib.printf("\nRIGHT SINGULAR VECTORS (transpose of V): ", new Object[0]);
            }
        } else if (this.SVDVerbosity > 0L) {
            Svdlib.printf("SINGULAR VALUES FOUND     = %6d\n", R.d);
        }
        if (transpose) {
            DMat swap = R.Ut;
            R.Ut = R.Vt;
            R.Vt = swap;
        }
        return R;
    }

    static void svdWriteDenseArray(double[] s, int d, String string, boolean b) {
        System.out.println("Declare victory!");
    }

    static void rotateArray(double[][] a, int size, int x) {
        if (x == 0) {
            return;
        }
        int start = 0;
        int j = 0;
        double t1 = a[0][0];
        int len = a.length;
        for (int i = 0; i < size; ++i) {
            int n = j >= x ? j - x : j + size - x;
            double t2 = a[n % len][n / len];
            a[n % len][n / len] = t1;
            t1 = t2;
            j = n;
            if (j != start) continue;
            start = ++j;
            t1 = a[j % len][j / len];
        }
    }

    long ritvec(int n, SMat A, SVDRec R, double kappa, double[] ritz, double[] bnd, double[] alf, double[] bet, double[] w2, int steps, long neig) {
        int i;
        double[] w1 = R.Vt.value[0];
        int js = steps + 1;
        int jsq = js * js;
        double[] s = Svdlib.svd_doubleArray(jsq, true, "ritvec: s");
        double[] xv2 = Svdlib.svd_doubleArray(n, false, "ritvec: xv2");
        for (i = 0; i < jsq; i += js + 1) {
            s[i] = 1.0;
        }
        Svdlib.svd_dcopy(js, alf, 1, w1, -1);
        Svdlib.svd_dcopy(steps, bet, 1, 1, w2, 1, -1);
        this.imtql2(js, js, w1, w2, s);
        if (0L != this.ierr) {
            return 0L;
        }
        int nsig = 0;
        int x = 0;
        int id2 = jsq - js;
        for (int k = 0; k < js; ++k) {
            int tmp = id2;
            if (bnd[k] <= kappa * Math.abs(ritz[k]) && (long)k > (long)js - neig - 1L) {
                if (--x < 0) {
                    x = R.d - 1;
                }
                w1 = R.Vt.value[x];
                for (i = 0; i < n; ++i) {
                    w1[i] = 0.0;
                }
                for (i = 0; i < js; ++i) {
                    this.store(n, storeVals.RETRQ, i, w2);
                    Svdlib.svd_daxpy(n, s[tmp], w2, 1, w1, 1);
                    tmp -= js;
                }
                ++nsig;
            }
            ++id2;
        }
        s = null;
        Svdlib.rotateArray(R.Vt.value, R.Vt.rows * R.Vt.cols, x * R.Vt.cols);
        R.d = Svdlib.svd_imin(R.d, nsig);
        for (x = 0; x < R.d; ++x) {
            Svdlib.svd_opb(A, R.Vt.value[x], xv2, this.OPBTemp);
            double tmp0 = Svdlib.svd_ddot(n, R.Vt.value[x], 1, xv2, 1);
            Svdlib.svd_daxpy(n, -tmp0, R.Vt.value[x], 1, xv2, 1);
            tmp0 = Math.sqrt(tmp0);
            double xnorm = Math.sqrt(Svdlib.svd_ddot(n, xv2, 1, xv2, 1));
            Svdlib.svd_opa(A, R.Vt.value[x], R.Ut.value[x]);
            double tmp1 = 1.0 / tmp0;
            Svdlib.svd_dscal(A.rows, tmp1, R.Ut.value[x], 1);
            bnd[i] = xnorm *= tmp1;
            R.S[x] = tmp0;
        }
        xv2 = null;
        return nsig;
    }

    int lanso(SMat A, int iterations, int dimensions, double endl, double endr, double[] ritz, double[] bnd, double[][] wptr, int[] neigp, int n) {
        int j = 0;
        int intro = 0;
        double[] alf = wptr[6];
        double[] eta = wptr[7];
        double[] oldeta = wptr[8];
        double[] bet = wptr[9];
        double[] wrk = wptr[5];
        double[] ref_rnm = new double[]{0.0};
        double[] ref_tol = new double[]{0.0};
        this.stpone(A, wptr, ref_rnm, ref_tol, n);
        double tol = ref_tol[0];
        double rnm = ref_rnm[0];
        if (0.0 == rnm || 0L != this.ierr) {
            return 0;
        }
        eta[0] = this.eps1;
        oldeta[0] = this.eps1;
        int ll = 0;
        int first = 1;
        int last = Svdlib.svd_imin(dimensions + Svdlib.svd_imax(8, dimensions), iterations);
        boolean ENOUGH = false;
        while (!ENOUGH) {
            if (rnm <= tol) {
                rnm = 0.0;
            }
            int[] ref_ll = new int[]{ll};
            boolean[] ref_ENOUGH = new boolean[]{ENOUGH};
            double[] ref2_rnm = new double[]{rnm};
            double[] ref2_tol = new double[]{tol};
            j = this.lanczos_step(A, first, last, wptr, alf, eta, oldeta, bet, ref_ll, ref_ENOUGH, ref2_rnm, ref2_tol, n);
            ll = ref_ll[0];
            ENOUGH = ref_ENOUGH[0];
            tol = ref2_tol[0];
            rnm = ref2_rnm[0];
            j = ENOUGH ? --j : last - 1;
            first = j + 1;
            bet[j + 1] = rnm;
            int l = 0;
            for (int id2 = 0; id2 < j && l <= j; ++id2) {
                int id3;
                int i;
                for (i = l; i <= j && 0.0 != bet[i + 1]; ++i) {
                }
                if (i > j) {
                    i = j;
                }
                Svdlib.svd_dcopy(i - l + 1, alf, l, 1, ritz, l, -1);
                Svdlib.svd_dcopy(i - l, bet, l + 1, 1, wrk, l + 1, -1);
                this.imtqlb(i - l + 1, ritz, wrk, bnd, l);
                if (0L != this.ierr) {
                    Svdlib.svd_error("svdLAS2: imtqlb failed to converge (ierr = %ld)\n", this.ierr);
                    Svdlib.svd_error("  l = %ld  i = %ld\n", l, i);
                    for (id3 = l; id3 <= i; ++id3) {
                        Svdlib.svd_error("  %ld  %lg  %lg  %lg\n", id3, ritz[id3], wrk[id3], bnd[id3]);
                    }
                }
                for (id3 = l; id3 <= i; ++id3) {
                    bnd[id3] = rnm * Svdlib.fabs(bnd[id3]);
                }
                l = i + 1;
            }
            Svdlib.svd_dsort2((j + 1) / 2, j + 1, ritz, bnd);
            boolean[] ref2_ENOUGH = new boolean[]{ENOUGH};
            int neig = this.error_bound(ref2_ENOUGH, endl, endr, ritz, bnd, j, tol);
            ENOUGH = ref2_ENOUGH[0];
            neigp[0] = neig;
            if (neig < dimensions) {
                if (0 == neig) {
                    last = first + 9;
                    intro = first;
                } else {
                    last = first + Svdlib.svd_imax(3, 1 + (j - intro) * (dimensions - neig) / neig);
                }
                last = Svdlib.svd_imin(last, iterations);
            } else {
                ENOUGH = true;
            }
            ENOUGH = ENOUGH || first >= iterations;
        }
        this.store(n, storeVals.STORQ, j, wptr[1]);
        return j;
    }

    int lanczos_step(SMat A, int first, int last, double[][] wptr, double[] alf, double[] eta, double[] oldeta, double[] bet, int[] ll, boolean[] refEnough, double[] rnmp, double[] tolp, int n) {
        int j;
        double rnm = rnmp[0];
        double tol = tolp[0];
        for (j = first; j < last; ++j) {
            double[] mid = wptr[2];
            wptr[2] = wptr[1];
            wptr[1] = mid;
            mid = wptr[3];
            wptr[3] = wptr[4];
            wptr[4] = mid;
            this.store(n, storeVals.STORQ, j - 1, wptr[2]);
            if (j - 1 < MAXLL) {
                this.store(n, storeVals.STORP, j - 1, wptr[4]);
            }
            bet[j] = rnm;
            if (0.0 == bet[j]) {
                rnm = this.startv(A, wptr, j, n);
                if (0L != this.ierr) {
                    return j;
                }
                if (0.0 == rnm) {
                    refEnough[0] = true;
                }
            }
            if (refEnough[0]) {
                mid = wptr[2];
                wptr[2] = wptr[1];
                wptr[1] = mid;
                break;
            }
            double t = 1.0 / rnm;
            Svdlib.svd_datx(n, t, wptr[0], 1, wptr[1], 1);
            Svdlib.svd_dscal(n, t, wptr[3], 1);
            Svdlib.svd_opb(A, wptr[3], wptr[0], this.OPBTemp);
            Svdlib.svd_daxpy(n, -rnm, wptr[2], 1, wptr[0], 1);
            alf[j] = Svdlib.svd_ddot(n, wptr[0], 1, wptr[3], 1);
            Svdlib.svd_daxpy(n, -alf[j], wptr[1], 1, wptr[0], 1);
            if (j <= MAXLL && Math.abs(alf[j - 1]) > 4.0 * Math.abs(alf[j])) {
                ll[0] = j;
            }
            for (int i = 0; i < Svdlib.svd_imin(ll[0], j - 1); ++i) {
                this.store(n, storeVals.RETRP, i, wptr[5]);
                t = Svdlib.svd_ddot(n, wptr[5], 1, wptr[0], 1);
                this.store(n, storeVals.RETRQ, i, wptr[5]);
                Svdlib.svd_daxpy(n, -t, wptr[5], 1, wptr[0], 1);
                eta[i] = this.eps1;
                oldeta[i] = this.eps1;
            }
            t = Svdlib.svd_ddot(n, wptr[0], 1, wptr[4], 1);
            Svdlib.svd_daxpy(n, -t, wptr[2], 1, wptr[0], 1);
            if (bet[j] > 0.0) {
                bet[j] = bet[j] + t;
            }
            t = Svdlib.svd_ddot(n, wptr[0], 1, wptr[3], 1);
            Svdlib.svd_daxpy(n, -t, wptr[1], 1, wptr[0], 1);
            alf[j] = alf[j] + t;
            Svdlib.svd_dcopy(n, wptr[0], 1, wptr[4], 1);
            rnm = Math.sqrt(Svdlib.svd_ddot(n, wptr[0], 1, wptr[4], 1));
            double anorm = bet[j] + Math.abs(alf[j]) + rnm;
            tol = this.reps * anorm;
            this.ortbnd(alf, eta, oldeta, bet, j, rnm);
            double[] ref_rnm = new double[]{rnm};
            this.purge(n, ll[0], wptr[0], wptr[1], wptr[4], wptr[3], wptr[5], eta, oldeta, j, ref_rnm, tol);
            rnm = ref_rnm[0];
            if (!(rnm <= tol)) continue;
            rnm = 0.0;
        }
        rnmp[0] = rnm;
        tolp[0] = tol;
        return j;
    }

    void ortbnd(double[] alf, double[] eta, double[] oldeta, double[] bet, int step, double rnm) {
        if (step < 1) {
            return;
        }
        if (0.0 != rnm) {
            if (step > 1) {
                oldeta[0] = (bet[1] * eta[1] + (alf[0] - alf[step]) * eta[0] - bet[step] * oldeta[0]) / rnm + this.eps1;
            }
            for (int i = 1; i <= step - 2; ++i) {
                oldeta[i] = (bet[i + 1] * eta[i + 1] + (alf[i] - alf[step]) * eta[i] + bet[i] * eta[i - 1] - bet[step] * oldeta[i]) / rnm + this.eps1;
            }
        }
        oldeta[step - 1] = this.eps1;
        Svdlib.svd_dswap(step, oldeta, 1, eta, 1);
        eta[step] = this.eps1;
    }

    void purge(int n, int ll, double[] r, double[] q, double[] ra, double[] qa, double[] wrk, double[] eta, double[] oldeta, int step, double[] rnmp, double tol) {
        double rnm = rnmp[0];
        if (step < ll + 2) {
            return;
        }
        int k = Svdlib.svd_idamax(step - (ll + 1), eta, ll, 1) + ll;
        if (Math.abs(eta[k]) > this.reps) {
            int i;
            double reps1 = this.eps1 / this.reps;
            boolean flag = true;
            for (int iteration = 0; iteration < 2 && flag; ++iteration) {
                double t;
                if (!(rnm > tol)) continue;
                double tq = 0.0;
                double tr = 0.0;
                for (i = ll; i < step; ++i) {
                    this.store(n, storeVals.RETRQ, i, wrk);
                    t = -Svdlib.svd_ddot(n, qa, 1, wrk, 1);
                    tq += Math.abs(t);
                    Svdlib.svd_daxpy(n, t, wrk, 1, q, 1);
                    t = -Svdlib.svd_ddot(n, ra, 1, wrk, 1);
                    tr += Math.abs(t);
                    Svdlib.svd_daxpy(n, t, wrk, 1, r, 1);
                }
                Svdlib.svd_dcopy(n, q, 1, qa, 1);
                t = -Svdlib.svd_ddot(n, r, 1, qa, 1);
                tr += Math.abs(t);
                Svdlib.svd_daxpy(n, t, q, 1, r, 1);
                Svdlib.svd_dcopy(n, r, 1, ra, 1);
                rnm = Math.sqrt(Svdlib.svd_ddot(n, ra, 1, r, 1));
                if (!(tq <= reps1) || !(tr <= reps1 * rnm)) continue;
                flag = false;
            }
            for (i = ll; i <= step; ++i) {
                eta[i] = this.eps1;
                oldeta[i] = this.eps1;
            }
        }
        rnmp[0] = rnm;
    }

    static double fabs(double a) {
        return Math.abs(a);
    }

    void stpone(SMat A, double[][] wrkptr, double[] rnmp, double[] tolp, int n) {
        double[] alf = wrkptr[6];
        double rnm = this.startv(A, wrkptr, 0, n);
        if (rnm == 0.0 || this.ierr != 0L) {
            return;
        }
        double t = 1.0 / rnm;
        Svdlib.svd_datx(n, t, wrkptr[0], 1, wrkptr[1], 1);
        Svdlib.svd_dscal(n, t, wrkptr[3], 1);
        Svdlib.svd_opb(A, wrkptr[3], wrkptr[0], this.OPBTemp);
        alf[0] = Svdlib.svd_ddot(n, wrkptr[0], 1, wrkptr[3], 1);
        Svdlib.svd_daxpy(n, -alf[0], wrkptr[1], 1, wrkptr[0], 1);
        t = Svdlib.svd_ddot(n, wrkptr[0], 1, wrkptr[3], 1);
        Svdlib.svd_daxpy(n, -t, wrkptr[1], 1, wrkptr[0], 1);
        alf[0] = alf[0] + t;
        Svdlib.svd_dcopy(n, wrkptr[0], 1, wrkptr[4], 1);
        rnm = Math.sqrt(Svdlib.svd_ddot(n, wrkptr[0], 1, wrkptr[4], 1));
        double anorm = rnm + Svdlib.fabs(alf[0]);
        rnmp[0] = rnm;
        tolp[0] = this.reps * anorm;
    }

    double startv(SMat A, double[][] wptr, int step, int n) {
        int i;
        double rnm2 = Svdlib.svd_ddot(n, wptr[0], 1, wptr[0], 1);
        Random random = new Random(918273L + (long)step);
        double[] r = wptr[0];
        for (int id = 0; id < 3; ++id) {
            if (id > 0 || step > 0 || rnm2 == 0.0) {
                for (i = 0; i < n; ++i) {
                    r[i] = random.nextDouble();
                }
            }
            Svdlib.svd_dcopy(n, wptr[0], 1, wptr[3], 1);
            Svdlib.svd_opb(A, wptr[3], wptr[0], this.OPBTemp);
            Svdlib.svd_dcopy(n, wptr[0], 1, wptr[3], 1);
            rnm2 = Svdlib.svd_ddot(n, wptr[0], 1, wptr[3], 1);
            if (rnm2 > 0.0) break;
        }
        if (rnm2 <= 0.0) {
            this.ierr = 8192L;
            return -1.0;
        }
        if (step > 0) {
            double t;
            for (i = 0; i < step; ++i) {
                this.store(n, storeVals.RETRQ, i, wptr[5]);
                t = -Svdlib.svd_ddot(n, wptr[3], 1, wptr[5], 1);
                Svdlib.svd_daxpy(n, t, wptr[5], 1, wptr[0], 1);
            }
            t = Svdlib.svd_ddot(n, wptr[4], 1, wptr[0], 1);
            Svdlib.svd_daxpy(n, -t, wptr[2], 1, wptr[0], 1);
            Svdlib.svd_dcopy(n, wptr[0], 1, wptr[3], 1);
            t = Svdlib.svd_ddot(n, wptr[3], 1, wptr[0], 1);
            if (t <= this.eps * rnm2) {
                t = 0.0;
            }
            rnm2 = t;
        }
        return Math.sqrt(rnm2);
    }

    int error_bound(boolean[] enough, double endl, double endr, double[] ritz, double[] bnd, int step, double tol) {
        int i;
        int mid = Svdlib.svd_idamax(step + 1, bnd, 0, 1);
        for (i = (step + 1 + (step - 1)) / 2; i >= mid + 1; --i) {
            if (!(Svdlib.fabs(ritz[i - 1] - ritz[i]) < this.eps34 * Svdlib.fabs(ritz[i])) || !(bnd[i] > tol) || !(bnd[i - 1] > tol)) continue;
            bnd[i - 1] = Math.sqrt(bnd[i] * bnd[i] + bnd[i - 1] * bnd[i - 1]);
            bnd[i] = 0.0;
        }
        for (i = (step + 1 - (step - 1)) / 2; i <= mid - 1; ++i) {
            if (!(Svdlib.fabs(ritz[i + 1] - ritz[i]) < this.eps34 * Svdlib.fabs(ritz[i])) || !(bnd[i] > tol) || !(bnd[i + 1] > tol)) continue;
            bnd[i + 1] = Math.sqrt(bnd[i] * bnd[i] + bnd[i + 1] * bnd[i + 1]);
            bnd[i] = 0.0;
        }
        int neig = 0;
        double gapl = ritz[step] - ritz[0];
        for (i = 0; i <= step; ++i) {
            double gap = gapl;
            if (i < step) {
                gapl = ritz[i + 1] - ritz[i];
            }
            if ((gap = Svdlib.svd_dmin(gap, gapl)) > bnd[i]) {
                bnd[i] = bnd[i] * (bnd[i] / gap);
            }
            if (!(bnd[i] <= 16.0 * this.eps * Svdlib.fabs(ritz[i]))) continue;
            ++neig;
            if (enough[0]) continue;
            enough[0] = endl < ritz[i] && ritz[i] < endr;
        }
        return neig;
    }

    void imtqlb(int n, double[] d, double[] e, double[] bnd, int offset) {
        double[] dn = new double[n];
        System.arraycopy(d, offset, dn, 0, n);
        double[] en = new double[n];
        System.arraycopy(e, offset, en, 0, n);
        double[] bndn = new double[n];
        System.arraycopy(bnd, offset, bndn, 0, n);
        this.imtqlb(n, dn, en, bndn);
        System.arraycopy(dn, 0, d, offset, n);
        System.arraycopy(en, 0, e, offset, n);
        System.arraycopy(bndn, 0, bnd, offset, n);
    }

    void imtqlb(int n, double[] d, double[] e, double[] bnd) {
        int i;
        if (n == 1) {
            return;
        }
        this.ierr = 0L;
        bnd[0] = 1.0;
        int last = n - 1;
        for (i = 1; i < n; ++i) {
            bnd[i] = 0.0;
            e[i - 1] = e[i];
        }
        e[last] = 0.0;
        for (int l = 0; l < n; ++l) {
            long iteration = 0L;
            while (iteration <= 30L) {
                int m;
                for (m = l; m < n; ++m) {
                    boolean convergence = false;
                    if (m == last) break;
                    double test = Svdlib.fabs(d[m]) + Svdlib.fabs(d[m + 1]);
                    if (test + Svdlib.fabs(e[m]) == test) {
                        convergence = true;
                    }
                    if (convergence) break;
                }
                double p = d[l];
                double f = bnd[l];
                if (m != l) {
                    if (iteration == 30L) {
                        this.ierr = l;
                        return;
                    }
                    ++iteration;
                    double g = (d[l + 1] - p) / (2.0 * e[l]);
                    double r = Svdlib.svd_pythag(g, 1.0);
                    g = d[m] - p + e[l] / (g + Svdlib.svd_fsign(r, g));
                    double s = 1.0;
                    double c = 1.0;
                    p = 0.0;
                    boolean underflow = false;
                    i = m - 1;
                    while (!underflow && i >= l) {
                        f = s * e[i];
                        double b = c * e[i];
                        e[i + 1] = r = Svdlib.svd_pythag(f, g);
                        if (r == 0.0) {
                            underflow = true;
                            continue;
                        }
                        s = f / r;
                        c = g / r;
                        g = d[i + 1] - p;
                        r = (d[i] - g) * s + 2.0 * c * b;
                        p = s * r;
                        d[i + 1] = g + p;
                        g = c * r - b;
                        f = bnd[i + 1];
                        bnd[i + 1] = s * bnd[i] + c * f;
                        bnd[i] = c * bnd[i] - s * f;
                        --i;
                    }
                    if (underflow) {
                        int n2 = i + 1;
                        d[n2] = d[n2] - p;
                        e[m] = 0.0;
                        continue;
                    }
                    int n3 = l;
                    d[n3] = d[n3] - p;
                    e[l] = g;
                    e[m] = 0.0;
                    continue;
                }
                boolean exchange = true;
                if (l != 0) {
                    i = l;
                    while (i >= 1 && exchange) {
                        if (p < d[i - 1]) {
                            d[i] = d[i - 1];
                            bnd[i] = bnd[i - 1];
                            --i;
                            continue;
                        }
                        exchange = false;
                    }
                }
                if (exchange) {
                    i = 0;
                }
                d[i] = p;
                bnd[i] = f;
                iteration = 31L;
            }
        }
    }

    void imtql2(int nm, int n, double[] d, double[] e, double[] z) {
        int k;
        double p;
        int l;
        int i;
        if (n == 1) {
            return;
        }
        this.ierr = 0L;
        int last = n - 1;
        for (i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[last] = 0.0;
        int nnm = n * nm;
        block1: for (l = 0; l < n; ++l) {
            int iteration = 0;
            while (iteration <= 30) {
                int m;
                for (m = l; m < n; ++m) {
                    boolean convergence = false;
                    if (m == last) break;
                    double test = Svdlib.fabs(d[m]) + Svdlib.fabs(d[m + 1]);
                    if (test + Svdlib.fabs(e[m]) == test) {
                        convergence = true;
                    }
                    if (convergence) break;
                }
                if (m == l) continue block1;
                if (iteration == 30) {
                    this.ierr = l;
                    return;
                }
                p = d[l];
                ++iteration;
                double g = (d[l + 1] - p) / (2.0 * e[l]);
                double r = Svdlib.svd_pythag(g, 1.0);
                g = d[m] - p + e[l] / (g + Svdlib.svd_fsign(r, g));
                double s = 1.0;
                double c = 1.0;
                p = 0.0;
                boolean underflow = false;
                i = m - 1;
                while (!underflow && i >= l) {
                    double f = s * e[i];
                    double b = c * e[i];
                    e[i + 1] = r = Svdlib.svd_pythag(f, g);
                    if (r == 0.0) {
                        underflow = true;
                        continue;
                    }
                    s = f / r;
                    c = g / r;
                    g = d[i + 1] - p;
                    r = (d[i] - g) * s + 2.0 * c * b;
                    p = s * r;
                    d[i + 1] = g + p;
                    g = c * r - b;
                    for (k = 0; k < nnm; k += n) {
                        int index = k + i;
                        f = z[index + 1];
                        z[index + 1] = s * z[index] + c * f;
                        z[index] = c * z[index] - s * f;
                    }
                    --i;
                }
                if (underflow) {
                    int n2 = i + 1;
                    d[n2] = d[n2] - p;
                    e[m] = 0.0;
                    continue;
                }
                int n3 = l;
                d[n3] = d[n3] - p;
                e[l] = g;
                e[m] = 0.0;
            }
        }
        for (l = 1; l < n; ++l) {
            int j;
            k = i = l - 1;
            p = d[i];
            for (j = l; j < n; ++j) {
                if (!(d[j] < p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < nnm; j += n) {
                p = z[j + i];
                z[j + i] = z[j + k];
                z[j + k] = p;
            }
        }
    }

    long[] machar() {
        double temp;
        double ONE = 1.0;
        double TWO = ONE + ONE;
        double ZERO = ONE - ONE;
        double a = ONE;
        double temp1 = ONE;
        while (temp1 - ONE == ZERO) {
            a += a;
            temp = a + ONE;
            temp1 = temp - a;
        }
        double b = ONE;
        long itemp = 0L;
        while (itemp == 0L) {
            b += b;
            temp = a + b;
            itemp = (long)(temp - a);
        }
        long ibeta = itemp;
        double beta = ibeta;
        long it = 0L;
        b = ONE;
        temp1 = ONE;
        while (temp1 - ONE == ZERO) {
            ++it;
            temp = (b *= beta) + ONE;
            temp1 = temp - b;
        }
        long irnd = 0L;
        double betah = beta / TWO;
        temp = a + betah;
        if (temp - a != ZERO) {
            irnd = 1L;
        }
        double tempa = a + beta;
        temp = tempa + betah;
        if (irnd == 0L && temp - tempa != ZERO) {
            irnd = 2L;
        }
        long negep = it + 3L;
        double betain = ONE / beta;
        a = ONE;
        for (long i = 0L; i < negep; ++i) {
            a *= betain;
        }
        b = a;
        temp = ONE - a;
        while (temp - ONE == ZERO) {
            --negep;
            temp = ONE - (a *= beta);
        }
        negep = -negep;
        long machep = -it - 3L;
        a = b;
        temp = ONE + a;
        while (temp - ONE == ZERO) {
            ++machep;
            temp = ONE + (a *= beta);
        }
        this.eps = a;
        return new long[]{ibeta, it, irnd, machep, negep};
    }

    void store(int n, storeVals isw, int j, double[] s) {
        switch (isw) {
            case STORQ: {
                if (null == this.LanStore[j + MAXLL]) {
                    this.LanStore[j + Svdlib.MAXLL] = Svdlib.svd_doubleArray(n, false, "LanStore[j]");
                }
                Svdlib.svd_dcopy(n, s, 1, this.LanStore[j + MAXLL], 1);
                break;
            }
            case RETRQ: {
                if (null == this.LanStore[j + MAXLL]) {
                    throw new Error(String.format("svdLAS2: store (RETRQ) called on index %d (not allocated)", j + MAXLL));
                }
                Svdlib.svd_dcopy(n, this.LanStore[j + MAXLL], 1, s, 1);
                break;
            }
            case STORP: {
                if (j >= MAXLL) {
                    throw new Error("svdLAS2: store (STORP) called with j >= MAXLL");
                }
                if (null == this.LanStore[j]) {
                    this.LanStore[j] = Svdlib.svd_doubleArray(n, false, "LanStore[j]");
                }
                Svdlib.svd_dcopy(n, s, 1, this.LanStore[j], 1);
                break;
            }
            case RETRP: {
                if (j >= MAXLL) {
                    Svdlib.svd_error("svdLAS2: store (RETRP) called with j >= MAXLL", new Object[0]);
                    break;
                }
                if (null == this.LanStore[j]) {
                    throw new Error(String.format("svdLAS2: store (RETRP) called on index %d (not allocated)", j));
                }
                Svdlib.svd_dcopy(n, this.LanStore[j], 1, s, 1);
            }
        }
    }

    static SMat svdLoadSparseTextHBFile(File file) throws FileNotFoundException {
        int x;
        int i;
        Scanner scanner = new Scanner(file);
        scanner.nextLine();
        scanner.nextLine();
        scanner.next();
        int rows = scanner.nextInt();
        int cols = scanner.nextInt();
        int vals = scanner.nextInt();
        int num_mat = scanner.nextInt();
        scanner.nextLine();
        if (num_mat != 0) {
            throw new Error("svdLoadSparseTextHBFile: I don't know how to handle a file with elemental matrices (last entry on header line 3)");
        }
        scanner.nextLine();
        SMat S = new SMat(rows, cols, vals);
        for (i = 0; i <= S.cols; ++i) {
            x = scanner.nextInt();
            S.pointr[i] = x - 1;
        }
        S.pointr[S.cols] = S.vals;
        for (i = 0; i < S.vals; ++i) {
            x = scanner.nextInt();
            S.rowind[i] = x - 1;
        }
        for (i = 0; i < S.vals; ++i) {
            S.value[i] = scanner.nextDouble();
        }
        return S;
    }

    static enum storeVals {
        STORQ,
        RETRQ,
        STORP,
        RETRP;

    }
}

